<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Page Ajax Class Controller
 * @Module      Page
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_Page_Ajax extends Controller_Space_Ajax {
    
    public function before() {
        parent::before();        
        $this->model_history = Model::factory('history');
    }
    
    public function action_index() {
        die();
    }
    
    
    public function action_remake_order_max() {
        $this->identify();
        $this->authorized(array('page'=>'add,edit'));
        if ($this->post && $this->authorisation){
            $job = 'create';
            extract($this->post);
            $total_item = $this->db->pre_order('site_menus',false)
                            ->where('parent_id = '.$parent)
                            ->execute()
                            ->current();
                        
            $return['status'] = true;
            $return['max'] = empty($total_item->total) 
                                        ? 1 
                                        : ( $job == 'edit' ? ($parent == $previous ? $total_item->total : $total_item->total+1) : $total_item->total+1);
            $return['tooltip'] = $return['max'] > 1 ? __('info_range',array('%min'=>1,'%max'=>$return['max'])) : '';
        } else {
            $return = array('status',false);
        }
        $this->ajax = json_encode($return);
    }
    
    /*
     * 
     */
    public function action_delete_page() {
        $id = $this->param1;
        
        $query = DB::select('site_menu_id')
                ->from('pages')
                ->where('id', '=', $id)
                ->as_object()
                ->execute();
        
        if($query->valid()){
            $site_menu_id = $query->current()->site_menu_id;
            $this->db->delete('site_menus')->where('id = '.$site_menu_id)->execute();
        }
        
        $delete = $this->db->delete('pages')->where('id = '.$id)->execute();
        
        $result = false;  
        
        if ($delete == 1) {
            $result = true;            
        }
        
        $this->ajax = json_encode($result);
    }
    
}