<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Module Setting Class Controller
 * @Module      Base
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 
 


class Controller_Cms_System_Modulesetting extends Controller_Space_Cms {
    protected $site;
    
    public function before() {
        parent::before();
    }
    
    protected function condition() {
        // Filter Condition
        $filter = $this->site->session->get('filter');        
        if (!empty($filter['news-category'])) {
            $infilter = 0;
            foreach ($filter['news-category'] as $key => $value) {
                if (!empty($value)) {
                    if ($infilter <= 0) 
                        Paging::$init->list_items->and_where_open();                        
                    Paging::$init->list_items->or_where('news.news_category_id = '.$key);
                    $infilter++;
                }
            }
            if ($infilter >= 1) 
                Paging::$init->list_items->and_where_close();
        }
        // Search Condition
        $param_condition = array('search');
        if (in_array($this->param1,$param_condition)){
            $function = 'condition_'.$this->param1;
            $this->$function();    
        }
    } 
    
    protected function condition_search() {
        $this->site->search_value = $value_condition = $this->param2;
        
        Paging::$init->list_items->and_where_open()
            ->where('news.id = '.$value_condition)
            ->or_where('modules.label like %'.$value_condition.'%')
            ->or_where('modules.status like %'.$value_condition.'%')
            ->and_where_close();
    }
    
    public function action_index() {
        $this->action_list();
    }
    
    public function action_manage() {
        $this->action_list();
    }
        
    public function action_list() {   
        if ($this->authorisation === true) {
            Paging::factory(array(
                    'model' => 'module',
                    'items_per_page' => 20
                ));
            $this->condition();
            Paging::$init->compile();
            
            $this->meta('title',__('manage_module'))
                 ->set('title',__('module_listing'))
                 ->set('content',$this->html('module-list'))
                 ->scripts($this->site->system_js.'plugin/jquery.validate')
                 ->render();
        }
    }
    
}
