<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    General Api
 * @Module      General
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors
**/ 

class Kohana_General {    
    /**
     * @var array   general configuration
     */
    public $config = array (
            'table'       => null,
            'field'       => 'id',
            'outer_query' => null,
            'name'        => null,
            'value'       => null,
            'attribute'   => array(),
            'total_item'  => null,
            'job'         => null
        );
        
    /**
     * @var string  table name
     */
    public $table;
    
    /**
     * @var string  field name
     */
    public $field;
    
    /**
     * @var string  outer database query
     */
    public $outer_query;
    
    /**
     * @var string  field attribute name
     */
    public $name;
    
    /**
     * @var mixed   field attribute value
     */
    public $value;
    
    /**
     * @var array   field attributes
     */
    public $attribute;
    
    /**
     * @var integer total item
     */
    public $total_item;
    
    /**
     * @var string  transaction database job (create new or edit)
     */
    public $job;
    
    public static function factory($config = NULL) {
        return new General($config);
    }
            
    public function __construct($config = NULL) {
        Package::$init->populate($this,$config);
    } 
    
    public function form_select_menu() {
        $menu = '';
        return Form::render('html/general/form-select-menu');
    }   
    
    public function form_menu_position($data) {
        extract($data);
        $name = empty($data['name']) ? 'check_for_name' : $data['name'];
        $value = !isset($data['value']) ? null : $data['value'];
        $attributes = !isset($data['attribute']) ? array() : $data['attribute'];
                    
        $idx = Request::$initial->action() == 'form' && 
              Request::$initial->param('param1') == 'edit'
                ? Request::$initial->param('param2') : 0;
                  
        $positions = Model::factory('base')
                            ->select('smp.*',array('spa.site_menu_id','applicable'))
                            ->from(array('site_menu_positions','smp'))
                            ->join(array('site_menu_position_applications','spa'))
                            ->on('spa.site_menu_id = '.$idx,true)
                            ->on('smp.id = spa.site_menu_position_id')
                            ->execute();
        
        #$positions = $positions->execute();
        $html  = '';  
        if (!empty($positions[0])) {
            $html  .= '<div class="ls5"></div>';
            foreach ($positions as $position) {
                $checked = !empty($position->applicable) ? true : false;
                $html  .= '<div>';
                $html  .= '<div class="fl" style="width:20px;">';
                $html  .= Form::checkbox($name.'[]',$position->id,$checked,$attributes);
                $html  .= '</div>';
                $html  .= '<div class="fl" style="margin-top:-2px;">';
                $html  .= $position->label;
                $html  .= '</div>';
                $html  .= '<div class="clear ls5"></div>';
                $html  .= '</div>';
            }
        }   
                         
        return $html;
    }
    
    public function menu_order(array $data = array()) {
        if (empty($data['table'])) {
            return 'Order need table name';
        }        
        $total_item   = $this->model_menu->pre_order($data['table']);
        $data['item'] = $total_item->total;        
        return $this->input_order($data);
    }
    
    /**
     * Set general ordering form input
     * 
     * General::factory(array(
     *  'table' => string table name,
     *  'field' => string field name, "id" will be using as default
     *  'outer_query' => string outer sql query, must contain field aliasing as 'total'
     * ))->total_row();
     */
    public function total_row() {
        if (!empty($this->outer_query)) {
            $exe = Database::instance('default')
                        ->query(Database::SELECT,$this->outer_query,true)
                        ->current();
            return !isset($exe->total) ? false : $exe->total;
        }
                    
        if (!empty($this->table)) {
            $exe = $this->db->select(array(DB::expr("COUNT(`$this->field`)"),'total'))
                            ->from($this->table)
                            ->execute()
                            ->current();
            return !isset($exe->total) ? false : $exe->total; 
        }   
        return false; 
    }
    
    /**
     * Set general ordering form input
     * 
     * General::factory(array(
     *  'total_item' => integer total item,
     *  'name'       => string input name,
     *  'value'      => integer input value
     *  'attribute'  => array attribute 
     *                  eg. array('class'=>'required integer','id'=>'ordering')
     * ))->input_order();
     */
    public function input_order() {
        $name  = isset($this->name) ? $this->name : "check_for_name";
        $this->total_item = !isset($this->total_item)  ? $this->total_row() : $this->total_item;
        
        $this->attribute['min'] = 1;
        $this->attribute['max'] = empty($this->total_item) 
                                        ? 1 
                                        : ((!empty($this->job) && $this->job == 'edit') || (
                                                Request::$initial->action() == 'form' && 
                                                Request::$initial->param('param1') == 'edit') 
                                                    ? $this->total_item : $this->total_item+1);
        
        $this->value = !isset($this->value) ? $this->attribute['max'] : $this->value;
        
        // Html Coding
        $html  = Form::input($name,$this->value,$this->attribute);
        if (!empty($this->attribute['max']) && $this->attribute['max'] > 1) {
            $html .= 
                '<div class="ls2"></div><span class="tooltip">'
                .__('info_range',array('%min'=>$this->attribute['min'],'%max'=>$this->attribute['max']))
                .'</span>';
        }       
        return $html;
    }
}