<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Module Model
 * @Module      General
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Model_Menu extends Model_Base {
    /**
     * @var string pre-definition status table record
     */ 
    public $_status = null;
        
    /**
     * @param boolean execute query data or return object
     */ 
    
    public function limit_menu($execution = TRUE){
        $menu = Setup::join_histories('site_menus')
                    ->offset(Paging::$page->offset)
                    ->limit(Paging::$page->items_per_page);
        
        return $execution === true ? $menu->execute() : $menu;
    }
    
    public function traverse_limit_menu($value = 0,$offset = 0, $limit = 10,$level=0) {        
        $object = Setup::join_histories('site_menus','sm',array('sm.ordering','sm.status','sm.parent_id'))
                    ->and_where('sm.parent_id = '.$value)
                    ->order_by('ordering');
        
        if ($value == 0) {
            if (!empty($this->position_id))
                $object->join(array('site_menu_position_applications','smpa'))
                       ->on('sm.id = smpa.site_menu_id')
                       ->and_where('smpa.site_menu_position_id = '.$this->position_id);    
            
                        
            $object->offset($offset);
                        
            if (!empty($limit))
                $object->limit($limit);
        }
        
        if (!empty($this->status_menu)) 
            $object->and_where('sm.status = '.$this->status_menu);    
                
        $arr_data = $object->execute();
        
        if (!empty($arr_data[0]->id)) {
            $index_data = 0;
                        
            foreach ($arr_data as $item) {                
                $result[$index_data]['data']  = $item;
                $result[$index_data]['level'] = $level;
                $result[$index_data]['child'] = $this->traverse_limit_menu($item->id,$offset,$limit,$level+1);
                $index_data++; 
            }
        }else{
            return null;
        }
        
        return $result;
    }
    
    /**
     * Get total menu
     */
    public function item_total($execution = true) {
        $total = $this->total_record('site_menus',false);
        
        return $execution === true ? $total->execute()->current()->total : $total;
    }
    
    /**
     * @param string status table record
     */
    public function status($value = 'active') {
        $this->_status = $value;
        return $this;        
    }
    
    public function get_menu($execution = true) {
        $prepare = $this->select()->from('site_menus');
        $this->alter_status($prepare);
        return $execution === true ? $prepare->execute() : $prepare;
    }
    
    public function get_menu_position($execution = true) {
        $prepare = $this->select()->from('site_menu_positions');
        $this->alter_status($prepare);
        return $execution === true ? $prepare->execute() : $prepare;
    }
    
    public function module_menu() {
        return $this->select('menu.id','menu.parent_id','menu.label','menu.permalink',
                              array('mod.label','module'))
                    ->from(array('module_menus','menu'))
                    ->join(array('modules','mod'),'left')->on('mod.id = menu.module_id')
                    ->where('mod.status = active')->and_where('menu.status = active')
                    ->order_by('mod.ordering','asc')
                    ->order_by('menu.ordering','asc')
                    ->execute();
    }
    
    /**
     * @param string menu title
     */
    public function menu_id($permalink) {
        $get = $this->select('id')
                    ->from('site_menus')
                    ->where('permalink = '.$permalink)
                    ->execute()->current();
        return !isset($get->id) ? null : $get->id;
    }
    
    protected function alter_status(&$object) {
        if (isset($this->_status)) {
            $object = $object->where('status = '.$this->_status);
            $this->_status = null;    
        }
    }
}