<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Module Model
 * @Module      General
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Model_Module extends Model_Base {
    
    /**
     * @var integer content id of history item
     */
    public function historymap($id) {
        $check = $this->select(array('label','label'))->from('modules')->where('id = '.$id)->execute();
        return empty($check[0]->label) 
            ? __('unknown') 
            : __('install_module',array(
                '%module' => __($check[0]->label,array('%s'=>'s'))
            ));
    }    
    
    /**
     * @var integer content id of history item
     */
    public function historymap_modulemenu($id) {
        $check = $this->select(array('label','label'))->from('module_menus')->where('id = '.$id)->execute();
        return empty($check[0]->label) 
            ? __('unknown') 
            : __('create_module_menu',array(
                '%menu' => __($check[0]->label,array('%s'=>'s'))
                ));
    }     
    
    /**
     * @var integer content id of history item
     */
    public function historymap_modulemenupermission($id) {
        $check = $this->select(array('p.label','permission'),array('mm.label','menu'))
                ->from(array('module_menu_permissions','mmp'))
                ->join(array('permissions','p'))->on('p.id = mmp.permission_id')
                ->join(array('module_menus','mm'))->on('mm.id = mmp.module_menu_id')
                ->where('mmp.id = '.$id)
                ->execute();
        
        return empty($check[0])
            ? __('unknown')
            : __('set_menu_permission',array(
                '%permission' => __($check[0]->permission,array('%s'=>'')),
                '%menu' => __($check[0]->menu,array('%s'=>''))
            ));
    }      
    
    /**
     * @var integer content id of history item
     */
    public function historymap_modulemenuposition($id) {
        $check = $this->select(array('mm.label','menu'),array('mmp.position','position'))
                ->from(array('module_menu_positions','mmp'))
                ->join(array('module_menus','mm'))->on('mm.id = mmp.module_menu_id')
                ->where('mmp.id = '.$id)
                ->execute();
                
        return empty($check[0])
            ? __('unknown')
            : __('set_menu_position',array(
                '%position' => __($check[0]->position,array('%s'=>'')),
                '%menu' => __($check[0]->menu,array('%s'=>''))
            ));
    }  
    
    /**
     * @param boolean execute query data or return object
     */ 
    
    public function limit_module($execution = TRUE){
        $menu = Setup::join_histories('modules')
                    ->order_by('ordering')
                    ->offset(Paging::$page->offset)
                    ->limit(Paging::$page->items_per_page);
        
        return $execution === true ? $menu->execute() : $menu;
    }
}