<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Login Form
 * @Module      User
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 
   
$page = empty($transaction) ? 'create' : $transaction;

?>
<script>
    $(document).ready(function(){
        // Auto fill permalink
        <?php if ($page === 'create') { ?>
        $('.menu_title#menu_title-<?php echo Translate::$default_lang;?>').keyup(function(){
            $('.permalink').val(cute_url($(this).val()));
        });
        $('.menu_title#menu_title-<?php echo Translate::$default_lang;?>').blur(function(){
            $('.permalink').val(cute_url($(this).val()));   
        });
        <?php } ?>
        $('select[name="parent"]').val(<?php echo empty($data->parent_id) ? 0 : $data->parent_id;?>);
        
        $('select[name="parent"]').change(function(){
            var val = $(this).val();
            $.ajaxSetup({ async: false });
            $.post(bs_cms+'page/ajax/remake-order-max',{
                'parent' : val,
                'session' : '<?php echo $site->cookie;?>',
                'job'   : "<?php echo $transaction;?>",
                'previous' : $(this).attr('parent_id')         
            },function(response){
                if(response.status === true) {
                    $('input[name="ordering"]').attr('max',response.max).val(response.max);
                    $('input[name="ordering"]').siblings('span').text(response.tooltip);
                }else{
                    jAlert('Error');
                }
            },'json');
        });
        // Validate Form
        $('form#frm_page').validate({
            errorPlacement  : function(error, element) {
                $(element).closest('.input-form').find('.error_field').after(error); 
            },
            rules : {
                label    : {
                    onfocusout : false,
                    minlength : 3,
                    check_availablity : {
                        "table" : "site_menus",
                        "field" : "label",
                        "job"   : "<?php echo $page;?>",
                        "prev"  : "<?php echo empty($data->label) ? '' : $data->label; ?>"
                    }
                },
                permalink : {
                    check_availablity : {
                        "table" : "site_menus",
                        "field" : "permalink",
                        "job"   : "<?php echo $page;?>",
                        "prev"  : "<?php echo empty($data->permalink) ? '' : $data->permalink; ?>"
                    }
                }    
            }
        });
        
        // Additional Form
        $('.menu_title').each(function(){
            var lang_id  = $(this).attr('id').split("-").pop();
            var prev_val = lang_id == '<?php echo Translate::SYS_LANG;?>' 
                ? "<?php echo empty($data->menu_title) ? '' : $data->menu_title; ?>"
                : $(this).val(); 
            $('#menu_title-'+lang_id).rules("add",{
                minlength : 3,
                check_availablity : {
                    "table" : "site_menus",
                    "field" : "menu_title",
                    "job"   : "<?php echo $transaction;?>",
                    "prev"  : prev_val
                }
            });
        });
        
        $('.permalink').each(function(){
            var lang_id = $(this).attr('id').split("-").pop();
            $('#permalink-'+lang_id).rules("add",{
                minlength : 3,
                check_availablity : {
                    "table" : "site_menus",
                    "field" : "permalink",
                    "job"   : "<?php echo $transaction;?>",
                    "prev"  : "<?php echo empty($data->permalink) ? '' : $data->permalink; ?>"
                }
            });
        });
        
        
        <?php if (!empty($data->is_system)) { ?>
        $('input.permalink').attr('readonly',true);
            <?php if (Translate::$multi_lang === true) { ?>
            $('input.permalink').each(function(){
               $(this).val($('input.permalink#permalink-en').val()); 
            });
            <?php } ?>
        <?php } ?>
        
    });
</script>

<?php

    echo Config::check_message();
    
    if ($form_action != 'save' && empty($data->id)) {
        echo '<label class="no_data">'.__('no_data').'</label>';   
        return;    
    } else {    
        $form = Form::init(array('multilang' => true, 
                        'banner'    => array('site_menus',isset($data->id) ? $data->id : null)))
                ->set_data($data)
                ->action($site->bs_cms.'system/site-menu/'.$form_action)
                ->attribute('class','frm-general frm-cms no_validation')
                ->attribute('id','frm_page')->attribute('class','frm_page')
                
                // Altering input attribute, needed for update maximum page order                   
                ->before_form(2)
                ->inject('job',$transaction)
                ->inject('item_id',empty($data->id) ? 0 : $data->id)
                ->inject('parent_id',empty($data->parent_id) ? 0 : $data->parent_id);
                
                
        
        if (isset($data->id)) {
            $form  
                ->add('hidden')
                    ->set_name('previous_ordering')
                    ->set_value(!isset($data->ordering) ? null : $data->ordering)
                    ->order(28)
                    
                ->add('hidden')
                    ->set_name('previous_parent')
                    ->set_value(!isset($data->parent_id) ? null : $data->parent_id)
                    ->order(29) 
                    
                /** Remove if you disable field parent_id from form menu    
                ->add('hidden')
                    ->set_name('parent')
                    ->set_value(!isset($data->parent_id) ? null : $data->parent_id)
                    ->order(32) 
                **/
                
                ->add('hidden')
                    ->set_name('site_menu_id')
                    ->set_value(!isset($data->id) ? null : $data->id)
                    ->order(31);
        }
        
        echo $form
                ->add('submit')->set_value('')->order(45)->set_label('')
                ->build("base::menu");
    }
?>