<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Media Library CMS Ajax Controller
 * @Module      Media Library
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_MediaLibrary_Ajax extends Controller_Space_Ajax {
    
    public function before() {
        parent::before();
        
        $this->model_role = Model::factory('role');
    }
    
    public function action_index() {
        $this->ajax = 'Working';
    }
    
    public function action_delete_media() {
        $ajax = false;
        if ($this->post && !empty($this->post['data'])) {
            $this->authorized('medialibrary','manage_image_library');
            if ($this->authorisation === true) {
                $post = $this->site->tool->arr_to_object($this->post['data'],false);
                if (!empty($post->file) && !empty($post->type)) {
                    if ($post->type == 'image') {
                        $ajax = Imagelibrary::remove_media_image($this->param1);
                    }
                }
            }    
        }
        $this->ajax = json_encode($ajax);
    }
    
    public function action_image_upload() {  
        $return = false;
        if ($this->post && !empty($this->post['directory'])) {
            if (!empty($this->site->user->profile->is_admin)) {
                $file = $_FILES['image_upload'];
                $name = $this->site->session->id().'_ii_'.helper_tool::file_name_beautification($file['name']);
                                
                $temp_dir = empty($this->post['temp_dir']) 
                            ? ImageLibrary::$temp_dir 
                            : $this->post['temp_dir'];
                            
                //Check in temp dir
                $is_in_temp = file_exists($temp_dir.'/'.$name);
                $temp =  !$is_in_temp
                    ? Upload::save($file,$name,$temp_dir)
                    : true;
                    
                if ($temp) {
                    $json_object = json_decode($this->post['directory']); 
                    $index = 0;
                    foreach ($json_object as $object) {
                        $remove_temp = $index >= count($json_object) ? true : false; 
                        $return = ImageLibrary::factory(array(
                                'temp_dir'       => $temp_dir,
                                'resize'         => empty($object->resize) ? false : $object->resize,
                                'resize_width'   => empty($object->width) ? 0 : $object->width,
                                'resize_height'  => empty($object->height) ? 0 : $object->height,
                                'file_name'      => $name,
                                'dest_dir'       => empty($object->location) ? null : $object->location,
                                'owner'          => $this->site->user->profile->is_admin
                            ))->zero_uploader($remove_temp);
                        $return = 1;
                        $index++;
                    }
                } else {
                    $return = __('upload_error',array('%message',''));
                }
                
            }
        }
        $this->ajax = $return;
    }
    
    public function action_browse() {
        // Get Libraries
        $libraries = $this->db
                          ->select()
                          ->from('media_libraries')
                          ->where('type = image')
                          ->execute();
        $html = $this->load('html/cms/medialibrary/ajax-libraries-listener',array(
                'libraries' => $libraries
            ));                          
        $this->ajax = $html;    
    }  
    
    public function action_append_banner() {
        $post = helper_tool::arr_to_object($this->post);
        $html = '';
        if (!empty($post->id) && !empty($post->src) && !empty($post->sty)) {
            // Get Banner Position
            $positions = Medialibrary::media_positions();
                                      
            $html = $this->load('html/cms/medialibrary/libraries-item',array(
                    'positions' => $positions,
                    'post'      => $post
                )); 
        }                      
        $this->ajax = $html;
    }
}


?>