<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Cms Class Controller
 * @Module      News
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_News_Category extends Controller_Space_Cms {
    protected $site;
    protected $model;
    
    public function before() {
        parent::before();
        $this->site->menu->active = 'news_category_list';
        $this->authorized(array(
                'news' => 'create_category,edit_category,delete_category,view_category',
            )); // Check permission           
         
        
        $this->scripts(array(
                $this->site->system_js.'plugin/jquery.validate.additional',
                $this->site->system_js.'plugin/jquery.validate'
            ));
    }  
    
    protected function condition() {
        // Condition Search
        $param_condition = array('search');
        if (in_array($this->param1,$param_condition)){
            $function = 'condition_'.$this->param1;
            $this->$function();    
        }
    } 
    
    protected function condition_search() {
        $this->site->search_value = $value_condition = $this->param2;
        
        Paging::$init->list_items->and_where_open()
            ->where('news_categories.id = '.$value_condition)
            ->or_where('news_categories.label like %'.$value_condition.'%')
            ->or_where('news_categories.status like %'.$value_condition.'%')
            ->or_where('news_categories.ordering = '.$value_condition)
            ->and_where_close();
    }
    
    public function action_index() {
        $this->action_list();
    }
    
    public function action_manage() {
        $this->action_list();
    }
        
    public function action_list() {        
        $this->scripts(array(
                $this->site->themes_js.'plugin/nested_table/jquery.treeTable.js',
                $this->site->system_js.'library/ui/jquery.ui.draggable.min.js',
                $this->site->system_js.'library/ui/jquery.ui.droppable.min.js',
                $this->site->system_js.'library/ui/jquery.ui.sortable.min.js',
                $this->site->system_js.'library/ui/jquery-ui-1.8.16.custom.min.js',
            ));
                 
        if ($this->authorisation === true) {
            Paging::factory(array(
                    'model' => 'newscategory',
                    'items_per_page' => 10
                ));            
            Paging::$init->list_items->order_by('ordering','asc');            
            $this->condition();
            Paging::$init->compile();
                        
            $this->meta('title',__('manage_news_category'))
                 ->set('title',__('manage_news_category'))
                 ->set('content',$this->html('news-category-list'))
                 ->scripts($this->site->system_js.'plugin/jquery.validate')
                 ->render();
        }
    }
    
    public function action_form() {
        // Extend permission
        $class_action = $this->param1."_category";
        $this->authorized(array('news' => $class_action));
        
        if ($this->authorisation === true) {
            if ($this->param1 == 'create' || $this->param1 == 'edit') {
                $title = __($this->param1,array('%item'=>__('news_category',array('%s'=>''))));
                
                /** Get data **/
                $data  = $this->param1 == 'create' 
                    ? null 
                    : Model::factory('newscategory')->get_by('field','id',$this->param2)->current();
                           
                /** Form configuration **/
                /** Form action **/
                $form_action  = $this->param1 == 'create' ? 'save' : 'update';                
                $form_action .= !empty($data->id) ? '/'.$data->id : '';
                
                /** Form Build **/
                $form = $this->html('news-category-form')
                            ->set('transaction',$this->param1)
                            ->set('data',$data)
                            ->set('form_action',$form_action);
                            
                /** Rendering **/        
                $this->meta('title',$title)
                     ->set('title',$title)
                     ->set('content',$form)
                     ->render();
            }    
        }
    }
    
    public function action_save() {        
        $this->authorized(array(
            'news' => 'create_category'
        ));
        
        if ($this->authorisation === true) {
            if($this->post){
                $result = false;
                $transaction =  Transaction::insert(array(
                       'package'        => 'news',
                       'form'           => 'news_category',
                       'owner'          => $this->site->user->profile->id,   
                       'order_option'   => array (
                                'table'          => 'news_categories',
                                'field'          => 'ordering',
                                'input_name'     => 'ordering',
                                'previous_input' => 'previous_ordering'
                            ),
                  ));
                $transaction->check(false);            
                $transaction->execute($result);   
                                           
                if ($result === false){
                    Session::instance()->set('message',__('transaction_failed',array('%item'=>strtolower(__('news_category')))));
                    $this->request->redirect('admin-cp/news/category/form/create/error');
                }
            }
        }        
        $this->request->redirect('admin-cp/news/category/manage'); 
    }
    
    public function action_update() {        
        $this->authorized(array(
            'news' => 'edit_category'
        ));
         
        if ($this->authorisation === true) {
            if($this->post){
                $transaction =  Transaction::update(array(
                       'package'        => 'news',
                       'form'           => 'news_category',
                       'owner'          => $this->site->user->profile->id,   
                       'order_option'   => array (
                                'table'          => 'news_categories',
                                'field'          => 'ordering',
                                'input_name'     => 'ordering',
                                'previous_input' => 'previous_ordering'
                            ),
                                              
                  ));
                $transaction->check(false);
                $transaction->execute($result);  
                
                if ($result === true) {
                    Session::instance()->set('message',__('success_update'));
                }else{
                    Session::instance()->set('message',__('no_transaction',array('%transaction'=>'update')));
                }
            }
        }    
        
        $this->request->redirect('admin-cp/news/category/form/edit/'.$this->param1);
    }
    
    public function action_delete() {       
        $this->authorized('news','delete_category');
        if ($this->authorisation) {            
           $delete = Transaction::delete('news_categories')
                        ->owner($this->site->user->profile->id,$this->site->user->profile->full_name)
                        ->history_item('label')
                        ->row($this->param1)
                        ->execute($result);
                            
        }
        $this->request->redirect('admin-cp/news/category');
    }
}
   

?>