<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Codename	Nouspeed.Com
 * @copyright 	2012
 * @Package	    News Read Controller
 * @Module      News
 * @Themes      ~
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Site_News_Read extends Controller_Space_Site {
    protected $site;
    protected $permalink;
    
    public function before() {  
       parent::before();     
       $this->site->menu->id = Model::factory('menu')->menu_id('news');       
       $this->site->menu->active = 'news';
       $this->permalink = $this->request->param('permalink');
    }
    
	public function action_item() {
	   $banner = Widget::$instance->load('banner-travia')
                                  ->set('table','site_menus')
                                  ->set('source_id',$this->site->menu->id);
                                  
       $news = empty($this->permalink)
                ? Model::factory('news')->recent_news(1)
                : Model::factory('news')->get_by('field','permalink',$this->permalink);
                
       $content = $this->html('news-detail')->set('item',$news); 
       
       $this->meta('title',$this->site->meta->title)
             ->set('title','Welcome')
             ->set('banner',$banner)
             ->set('content',$content);
	}
    
    public function after() {        
        $this->render();
        parent::after();
    }

} // End Welcome
