<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Module Package Installation
 * @Module      News &amp; Event
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

return array (
    'configuration' => 
        '
            {
                "news_categories" :
                    {
                        "id" :
                            {
                                "type" : "int",                            
                                "primary" : true,
                                "increment" : true
                            },
                        "label" :
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "multilang" : true,
                                "form" :
                                    {
                                        "news_category" :
                                            {
                                                "type" : "text",
                                                "label" : "label",
                                                "name" : "title",
                                                "class" : "title required"
                                            }
                                    }
                            },
                        "description" : 
                            {
                                "type" : "text",
                                "multilang" : true,
                                "form" :
                                    {
                                        "news_category" :
                                            {
                                                "label" : "description"
                                            }
                                    }
                            },
                        "status" : 
                            {
                                "type" : "enum",
                                "option" : "active,inactive",
                                "default" : "active",
                                "form" :
                                    {
                                        "news_category" :
                                            {
                                                "label" : "Status",
                                                "order" : 2
                                            }
                                    }
                            },
                        "ordering" : 
                            {
                                "type" : "int",
                                "form" :
                                    {
                                        "news_category" :
                                            {
                                                "order" : 3,
                                                "label" : "order",
                                                "class" : "ordering digits required",
                                                "function" : "news::input_order_category" 
                                            }
                                    }
                            }
                    },
                "news" :
                    {
                        "id" : 
                            {
                                "type" : "int",
                                "primary" : true,
                                "notnull" : true,
                                "increment" : true
                            },
                        "news_category_id" : 
                            {
                                "type" : "int",
                                "form" :
                                    {
                                        "news" :
                                            {
                                                "label" : "news_category",
                                                "class" : "news_category  required",
                                                "function" : "news::select_category",
                                                "order" : 2
                                            }
                                    }
                            },
                        "news_date" : 
                            {
                                "type" : "date",
                                "form" :
                                    {
                                        "news" :
                                            {
                                                "order" : 3,
                                                "label" : "date",
                                                "class" : "datepicker required",
                                                "readonly" : "readonly"
                                            }
                                    }
                            },
                        "news_title" : 
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "multilang" : true,
                                "form" :
                                    {
                                        "news" :
                                            {
                                                "label" : "title",
                                                "class" : "title required"
                                            }
                                    }
                                
                            },
                        "intro" : 
                            {
                                "type" : "text",
                                "form" :
                                    {
                                        "news" :
                                            {
                                                "label" : "intro",
                                                "type" : "textarea",
                                                "class" : "intro"
                                            }
                                    }
                            },
                        "description" : 
                            {
                                "type" : "longtext",
                                "form" :
                                    {
                                        "news" :
                                            {
                                                "label" : "description",
                                                "class" : "description"
                                            }
                                    }
                            },
                        "status" : 
                            {
                                "type" : "enum",
                                "option" : "active,inactive",
                                "default" : "active",
                                "form" :
                                    {
                                        "news" :
                                            {
                                                "label" : "status",
                                                "class" : "status"
                                            }
                                    }
                            }
                    }
            }
        ',
    'alter_configuration' => 
        '
            {
                "news_categories" :
                    {
                        "permalink" : 
                            {
                                "type" : "varchar",
                                "length" : 400,
                                "multilang" : true,
                                "after" : "label",
                                "form" :
                                    {
                                        "news_category" :
                                            {
                                                "label" : "permalink",
                                                "class" : "permalink required",
                                                "order" : 2
                                            }
                                    }
                            }
                    },
                "news" :
                    {
                        "permalink" : 
                            {
                                "type" : "varchar",
                                "length" : 400,
                                "multilang" : true,
                                "after" : "news_title",
                                "form" :
                                    {
                                        "news" :
                                            {
                                                "label" : "permalink",
                                                "class" : "permalink",
                                                "order" : 2
                                            }
                                    }
                            }
                    }
            }
                
        ',
    'mandatory' => 
        '
            {
                "modules" : 
                    [
                        {
                            "id" : "news",
                            "label" : "news",
                            "ordering" : "SELECT COUNT(`id`)+1 `id` FROM `modules`",      
                            "is_system" : 0
                        }
                    ],
                "permissions" : 
                    [
                        {
                            "module_id" : "news",
                            "action" : "create",
                            "label" : "create_news"
                        },
                        {
                            "module_id" : "news",
                            "action" : "edit",
                            "label" : "edit_news"
                        },
                        {
                            "module_id" : "news",
                            "action" : "delete",
                            "label" : "delete_news"
                        },
                        {
                            "module_id" : "news",
                            "action" : "view",
                            "label" : "view_news"
                        },
                        {
                            "module_id" : "news",
                            "action" : "create_category",
                            "label" : "create_news_category"
                        },
                        {
                            "module_id" : "news",
                            "action" : "edit_category",
                            "label" : "edit_news_category"
                        },
                        {
                            "module_id" : "news",
                            "action" : "delete_category",
                            "label" : "delete_news_category"
                        },
                        {
                            "module_id" : "news",
                            "action" : "view_category",
                            "label" : "view_news_category"
                        }
                    ],
                "module_menus" : 
                    [
                        {
                            "id" : "news_1",
                            "module_id" : "news",
                            "parent_id" : 0,
                            "label" : "news_category_list",
                            "permalink" : "category/manage",
                            "ordering" : 1
                        },
                        {
                            "id" : "news_2",
                            "module_id" : "news",
                            "parent_id" : 0,
                            "label" : "news_list",
                            "permalink" : "manage",
                            "ordering" : 2
                        }
                    ],
                "module_menu_permissions" : 
                    [
                        {
                            "module_menu_id" : "news_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'news\' AND `action` = \'create_category\'"
                        },
                        {
                            "module_menu_id" : "news_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'news\' AND `action` = \'edit_category\'"
                        },
                        {
                            "module_menu_id" : "news_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'news\' AND `action` = \'delete_category\'"
                        },
                        {
                            "module_menu_id" : "news_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'news\' AND `action` = \'view_category\'"
                        },
                        
                        {
                            "module_menu_id" : "news_2",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'news\' AND `action` = \'create\'"
                        },
                        {
                            "module_menu_id" : "news_2",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'news\' AND `action` = \'edit\'"
                        },
                        {
                            "module_menu_id" : "news_2",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'news\' AND `action` = \'delete\'"
                        },
                        {
                            "module_menu_id" : "news_2",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'news\' AND `action` = \'view\'"
                        }
                    ],
                "module_menu_positions" : 
                    [
                        {
                            "module_menu_id" : "news_1",
                            "position" : "left"
                        },
                        {
                            "module_menu_id" : "news_2",
                            "position" : "left"
                        }
                    ],
                "site_menus" :
                    [
                        {
                            "is_system" : 1,
                            "parent_id" : 0,
                            "menu_title" : "News",
                            "permalink" : "news",
                            "ordering" : "SELECT COUNT(`id`)+1 `id` FROM `site_menus`"     
                        }
                    ],
                "site_menu_position_applications" :
                    [
                        {
                            "site_menu_id" : "SELECT `id` FROM `site_menus` WHERE `menu_title` = \'News\'",
                            "site_menu_position_id" : 1
                        }
                    ]
            }
        '
);

?>