<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Simplified Kohana Model
 * @Module      Plug
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Model_Base extends Model {
    /**
     * @var string config database group to use
     */
    public $_db_group = 'default';
    
    /**
     * @var object Kohana Database Object
     */
    protected $object = NULL;
    
    /**
     * @var array Kohana Select Item
     */
    protected $_select = array();
    
    /**
     * @var string Mysql Function
     */
    protected $function = NULL;
    
    /**
     * @var string  Table to use
     */ 
    protected $table = NULL;
    
    /**
     * @var string  Query to excute
     */ 
    protected $query = NULL;
    
    /**
     * @var array   Field table
     */
    public $_fields = array();
    
    /**
     * @var array   Field Value
     */
    protected $_values = array();
    
    /**
     * @var array   Buffer the fields and values need to update with an associative array.
     */
    protected $_updates = array();
    
    /**
     * @var object or array Result of query execution
     */
    protected $_result;
    
    /**
     * @var integer or empty multi insert
     */
    protected $_multi_insert = null;
    
    /**
     * Reset function 
     */    
    public function reset() {
        
        $this->object   = NULL;
        $this->function = NULL;
        $this->table    = NULL;
        $this->query    = NULL;
        $this->_fields  = array();
        $this->_values  = array();
        
    }
    
    /**
     * Return database query instead execution
     */
    public function __print() {
        if (empty($this->object)) $this->object = $this->pre_compile();
        $result = $this->object;
        #$this->reset();
        return $result;       
    }
    
    /**
     * Return database query
     */
    public function object() {
        if (empty($this->object)) $this->object = $this->pre_compile();
        $result = $this->object;
        $this->object = null;
        return $result;       
    }
    
    /**
     * Execute database query
     */
    public function execute($type = NULL, $object = true) {
        $result = NULL;
        if (empty($type)):
            if (empty($this->object)) $this->object = $this->pre_compile();
            $result = $object === true ? $this->object->as_object()->execute($this->_db_group) : $this->object->execute($this->_db_group)->as_array();
        else:
            if (!empty($this->query)):
                if (strtolower($type) == 'update'):
                    $dbtype = Database::UPDATE;
                    $object = false;
                elseif (strtolower($type) == 'delete' || strtolower($type) == 'del'):
                    $dbtype = Database::DELETE;
                    $object = false;
                elseif (strtolower($type) == 'insert'):
                    $dbtype = Database::INSERT;
                    $object = false;
                elseif (strtolower($type) == 'select'):
                    $dbtype = Database::SELECT;
                else:
                    return NULL;
                endif;
                
                $result = Database::instance('default')->query($dbtype,$this->query,$object);
            endif;            
        endif;    
        $this->reset();
        
        return $result;
    }        
        
    public function pre_configuration($table = NULL, $type = NULL) {
        $this->table    = $table;
        $this->function = $type; 
    }
        
    /**
     * @param string    Type of query function  ||  select,update,delete,insert or print
     * @param boolean   Return query            ||  Object if True and Array if False 
     */ 
          
    protected function pre_compile() {
        $result = NULL;        
        
        if (!empty($this->function)):
            $object     = strtolower($this->function);
            
            if ($object == 'insert'):
                $result = DB::INSERT($this->table, $this->_fields);
                if (!empty($this->_multi_insert)):
                    for ($i = 0; $i < $this->_multi_insert; $i++) {
                        $new_value = array();
                        foreach ($this->_values as $value) {
                            $new_value[] = !is_array($value)
                                                ? $value
                                                : (empty($value[$i]) ? '' : $value[$i]);  
                        }
                        $result = $result->values($new_value);
                    }
                else: 
                    $result = $result->values($this->_values);
                endif;                
            elseif ($object == 'update'):
                $raw    = $this->_updates;
                $result = DB::UPDATE($this->table)->set($raw);
            elseif ($object == 'delete'):
                $result = DB::DELETE($this->table);
            endif;            
        endif;   
        
        return $result;
    }
    
    /**
     * Select row data from a table
     * @param  
     */
    public function select($columns = NULL) {
        $columns = func_get_args();
        if (empty($this->object))
            $this->object = new Database_Query_Builder_Select($columns);
        else             
            $this->object->select_array($columns);
        return $this;
    } 
    
    public function select_array(array $column = null) {
        $this->object = new Database_Query_Builder_Select($column);
        return $this;
    } 
     
    /**
     * Insert row data into a table
     * 
     * @param string    table name
     */            
    public function insert($table = NULL) {
        $this->pre_configuration($table,'insert');        
        return $this;
    }
    
    /**
     * Updating raw data in a table
     * 
     * @param string    table name
     */
    public function update($table = NULL) {
        $this->pre_configuration($table,'update');        
        return $this;
    }
    
    /**
     * Delete row data from table 
     */
    public function delete($table = NULL) {
        $this->pre_configuration($table,'delete');        
        return $this;
    }
    
    /**
     * Set from table
     */    
    public function from($table) {
        $this->object->from($table);
        return $this;
    }
    
    /**
     * Set Database Field
     */ 
    public function set($field = NULL ,$value = NULL) {
        if ($this->function == 'insert') {
            $this->_fields[] = $field;
            $this->_values[] = $value;
            
            if (is_array($value)) {
                $count = count($value);
                $this->_multi_insert = empty($this->_multi_insert)
                    ? $count
                    : ($count >= $this->_multi_insert ? $count : $this->_multi_insert);
            }
            
        } else {
            $raw[$field] = $value;
            $this->_updates = $raw + $this->_updates;
        }
           
        return $this;      
    }    
            
    public function where($args = NULL) {
        if (empty($this->object)) $this->object = $this->pre_compile();
        
        if (!empty($args)) {
            $argument = func_get_args();
            if (empty($argument[1])) {
                list($field,$operand,$value) = explode(' ',$argument[0],3);    
            }else{
                $field   = $argument[0];
                $operand = $argument[1];
                $value   = $argument[2];
            }
            $value = !is_array($value) && strtolower($value) == 'null' ? NULL : $value;
            $this->object->where($field,$operand,$value);
        }
        
        return $this;    
    }  
            
    public function or_where($args = NULL) {
        if (empty($this->object)) $this->object = $this->pre_compile();
        
        if (!empty($args)) {
            $argument = func_get_args();
            if (empty($argument[1])) {
                list($field,$operand,$value) = explode(' ',$argument[0],3);    
            }else{
                $field   = $argument[0];
                $operand = $argument[1];
                $value   = $argument[2];
            }
            $value = !is_array($value) && strtolower($value) == 'null' ? NULL : $value;
            $this->object->or_where($field,$operand,$value);
        }
        
        return $this;    
    }
           
    public function or_where_open() {
        if (empty($this->object)) $this->object = $this->pre_compile();
        $this->object->or_where_open();
        return $this;    
    }
            
    public function or_where_close() {
        if (empty($this->object)) $this->object = $this->pre_compile();
        $this->object->or_where_close();
        return $this;    
    }
            
    public function and_where($args = NULL) {
        if (empty($this->object)) $this->object = $this->pre_compile();
        
        if (!empty($args)) {
            $argument = func_get_args();
            if (empty($argument[1])) {
                list($field,$operand,$value) = explode(' ',$argument[0],3);    
            }else{
                $field   = $argument[0];
                $operand = $argument[1];
                $value   = $argument[2];
            }
            $value = !is_array($value) && strtolower($value) == 'null' ? NULL : $value;
            $this->object->and_where($field,$operand,$value);
        }
        
        return $this;    
    }
            
    public function and_where_open() {
        if (empty($this->object)) $this->object = $this->pre_compile();
        $this->object->and_where_open();
        return $this;    
    }
            
    public function and_where_close() {
        if (empty($this->object)) $this->object = $this->pre_compile();
        $this->object->and_where_close();
        return $this;    
    }
    
    public function where_open() {
        return $this->and_where_open();
    }
    
    public function where_close() {
        return $this->and_where_close();
    }
    
    public function join($table = NULL, $type = "LEFT") {
        $this->object->join($table,$type);
        return $this;
    }
    
    public function on($args = NULL) {
        if (empty($this->object)) $this->object = $this->pre_compile();
        if (!empty($args)) {
            $argument = func_get_args();
            if (empty($argument[1]) || $argument[1] === true) {
                $expression = !empty($argument[1]) && $argument[1] === true ? true : false;
                list($field,$operand,$value) = explode(' ',$argument[0],3);    
            }else{
                $field   = $argument[0];
                $operand = $argument[1];
                $value   = $argument[2];
            }
            
            if ($expression === false)
                $this->object->on($field,$operand,$value);
            else
                $this->object->on($field,$operand,DB::expr("'$value'"));
        }
        return $this;    
    }
    
    
    public function limit($number = NULL) {
        if (!empty($number) && is_int($number)) {
            if (empty($this->object)) $this->object = $this->pre_compile();
            $this->object->limit($number);   
        }
        return $this;
    }
    
    public function offset($number = NULL) {
        if (!empty($number) && is_int($number)) {
            if (empty($this->object)) $this->object = $this->pre_compile();
            $this->object->offset($number);   
        }
        return $this;
    }
    
    public function instance($instance = NULL) {
        if (!empty($instance)) $this->instance = $instance;
        return $this;
    }
    
    
    public function group_by($field) {
        $this->object->group_by($field);
        return $this;
    }
    
    
    public function order_by($field,$direction = 'asc') {
        $this->object->order_by($field,$direction);
        return $this;
    }
    
    public function as_object($class=TRUE, array $params = NULL) {
        $this->object->as_object($class,$params);
        return $this;
    }
    
    public function as_array() {
        $this->object->as_array();
        return $this;    
    }
    
    public function process_data($object,$execute=true) {
        if ($execute === false) return $object;
        $get = $object->execute();
        return count($get) == 1 ? $get[0] : $get;
    }
    
    /**
     * @param string table name
     * @param mixed string field name or boolean
     * @param boolean execution statement
     * 
     * If given field is boolean, field will be set automatically to "id" and given boolean value will be assign into
     * execution var
     * False will return select object query rather than query result
     * True will return query result
     */
    public function base_total($table,$field='id',$execution=TRUE) {
        $execution = is_bool($field) ? $field : $execution;
        $field = is_bool($field) ? 'id' : $field;
        
        $prepare = $this->select(array('count("'.$table.'.'.$field.'")','total'))
                        ->from(array($table,$table));
        
        if ($execution === TRUE) {
            $get = $prepare->execute();
            return empty($get[0]->total) ? 0 : $get[0]->total;
        } elseif ($execution === FALSE) {
            return $prepare;
        } else {
            throw new Kohana_Exception('Wrong Configuration. See manual');
        }
        
    }
    
    
    /**
     * We might need this in our next model. 
     * Creating to ampflified your coding time 
     */
    public function pre_order($table_name,$execute=true) {
        $prepare = $this->select(array(DB::expr('COUNT(`ordering`)'),'total'))
                                ->from($table_name);
        return $execute === true ? $prepare->execute()->current() : $prepare;    
    }
    
    /**
     * @param   string      table name to count
     * @param   mixed       string field name to count or boolean query execution
     * @param   boolean     query execution
     * @return  mixed       integer of total record or object query
     */
    public function total_record($table,$field='id',$execution = true) {
        if (is_bool($field)) {
            $execution = $field;
            $field     = 'id'; 
        }
        
        $query = $this->select(array(DB::expr('COUNT(`'.$table.'`.'.$field.')'),'total'))->from($table);
        return $execution === true ? $query->execute()->current()->total : $query;            
    }
    
    public function __toString() {
        echo $this->__print();
        return '<br/>';
    }
    
    public function class_var($var_name, $var_value) {
        $this->$var_name = $var_value;
        return $this;
    }      
}