<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Translator API Class
 * @Module      Plug
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 


class Translate extends Setup{
    // system lang
    const SYS_LANG = 'en';
    
    // boolean multi language status;
    public static $multi_lang = false;
    
    // default lang
    public static $default_lang = 'en';
    
    // current lang
    public static $current_lang;
    
    // array active lang 
    public static $active_lang = array();
    
        
    // Mixed : array or string of a single table name
    protected $table; 
    
    // Mixed : array or string(integer) of a single table source/record id
    protected $id;
    
    
    // object item after translation check
    public $item;
    
    // object data query
    protected $query_result;
    
    // Translate Init
    public static function init() {
        $registered_lang = Model::factory('base')->select('id','label','ordering')
                                   ->from('languages')
                                   ->order_by('ordering','asc')
                                   //->where('status = active')
                                   ->execute();
                                                                      
        if (!empty($registered_lang[0]) && count($registered_lang) > 1) {
            Translate::$multi_lang   = true;
            Translate::$active_lang  = $registered_lang;
            Translate::$current_lang = I18n::$lang;
            Translate::$default_lang = $registered_lang[0]->id;
        } else {
            Translate::$default_lang = Translate::SYS_LANG;
        }
    }      
    
    // Translate factory
    public static function table($table_name) {
        return new Translate($table_name);
    }     
    
    // Constructor
    public function __construct($table=null) { 
        $this->table = $table;  
    }
    
    // Set item
    public function item($item=null) {
        $this->item = $item;
        return $this;    
    }
    
    // Set id
    public function id($id=null) {
        $this->id = $id;
        return $this;
    }
    
    // Final function
    public function compile($single_lang=true) {
        // Check Id 
        $this->id = isset($this->id) 
            ? $this->id
            : (isset($this->item->id) ? $this->item->id : null);
                
        // Return item if site lang equal to system language and need only single language
        if ($single_lang === true && Config::$site_config->lang === Translate::SYS_LANG)
            return $this->item;
            
        // Check Item, set as an object if null
        $this->item = $this->item === null ? new stdClass() : $this->item;
        
        // Query preparation
        $query = Model::factory('base')->select('lang_id','field','value')->from('translations');        
        if (is_array($this->table))
            $this->select_array_table($query);
        elseif (is_array($this->id))
            $query; // do nothing :)
        else
            $query->where('table = '.$this->table)->and_where('source_id = '.$this->id);
        
        if ($single_lang === true)    
            $query->and_where('lang_id like %'.Config::$site_config->lang.'%');
        
        // Execute query
        $items = $query->execute();
        
        // Process result
        if (!empty($items[0])) {
            foreach ($items as $item) {
                $item_field = $item->field;
                $current_lang = $item->lang_id;
                if ($single_lang === true) {
                    if ( gettype($this->item) == 'array' ) 
                        $this->item[$item_field] = $item->value;
                    elseif ( gettype($this->item) == 'object' )
                        $this->item->$item_field = $item->value;
                } else {
                    if ( gettype($this->item) == 'array' ) 
                        $this->item[$current_lang][$item_field] = $item->value;
                    elseif ( gettype($this->item) == 'object' ) {
                        if (empty($this->item->$current_lang))
                            $this->item->$current_lang = new stdClass();
                            
                        $this->item->$current_lang->$item_field = $item->value;
                    }
                }
            }
        }
        
        return $this->item;
    }
    
    /**
     * @param object query
     */
    protected function select_array_table(&$query) {
        $index = 0;
        foreach ($this->table as $k => $t) {
            $index == 0 ? $query->where_open() : $query->or_where_open();
            $query->where('table = '.$t);
            is_array($this->id) 
                ? $query->where('source_id = '.$this->id[$k]) 
                : $query->where('source_id = '.$this->id);   
            $index == 0 ? $query->where_close() : $query->or_where_close();            
            $index++;
        }
    }
}