<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Class HTML Template
 * @Module      Templanation
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 
class Controller_Space_Html extends Controller_Template {
    
    /** 
     * @var     string  of template name
     * @return  object 
    */ 
    public $template;
    
    /** 
     * @var     string  of layout name
     * @return  object  view 
    */ 
    public $layout;
    
    /**
     * @var     object  of site variables 
     */
    protected $site; 
    
    /**
     * @var     boolean page authorisation
     */
    protected $authorisation = true;
    
    /**
     * @var string url parameter 
     */
    protected $param1;
    protected $param2;
    protected $param3;
    protected $param4;
    
    /**
     * @var array form post
     */ 
    protected $post;
    
    /**
     * @var boolean decide whether you want to use predefined system constructor
     */
    protected $predefined = true;
    
    public function before() {
        // Set new file template
        if (empty($this->template))
            $this->template = 'space/html';
        
        // Set default layout
       $this->layout   = 'two-column';
        
        // Confirm to controller 
        parent::before();  
        
        // Load helper tool,
        $tool = Helper_Tool::factory();
        
        // Set Default Post        
        $this->post = $this->request->post();
        
        // Dual language mode
        Translate::init();
        
        if ($this->auto_render){
            $this->template->styles = array();
            $this->template->scripts = array();
            
            // Handle Site Default Configuration
            $site_config          = Kohana::$config->load('site')->default;
            $this->site           = $tool->arr_to_object($site_config); 
            $this->site->tool     = $tool;
            $this->site->content  = '';                
            $this->site->lang     = $this->request->param('lang'); 
            $this->site->view_dir = $this->request->directory(); 
            
            // Define User
            $this->site->user = User::factory();
        
            // Handle Cookie Salt
            $this->site->salt = $this->site->session->get('nousalt',NULL);   
            if (empty($this->site->salt)) 
                $this->site->session->set('nousalt',$tool->random_salt());      
            Cookie::$salt = $this->site->session->get('nousalt',$this->site->salt_name);         
            $this->site->salt = Cookie::salt($this->site->salt_name,$this->site->salt_value);
        }
        
        // Set themes attributes
        $this->site->themes_css = $this->site->bs_asset.'themes/'.$this->site->themes.'/css/';
        $this->site->themes_img = $this->site->bs_asset.'themes/'.$this->site->themes.'/images/';
        $this->site->themes_js  = $this->site->bs_asset.'themes/'.$this->site->themes.'/js/';
        
        // Set system attributes
        $this->site->system_css = $this->site->bs_asset.'system/css/';
        $this->site->system_img = $this->site->bs_asset.'system/images/';
        $this->site->system_js  = $this->site->bs_asset.'system/js/';
        
        // Set site to config
        Config::$site_config    = $this->site;
        
        $this->site->search_value = null;
        
        $this->template->site = $this->site;
        
        $this->param1 = $this->request->param('param1');
        $this->param2 = $this->request->param('param2');
        $this->param3 = $this->request->param('param3');
        $this->param4 = $this->request->param('param4');
        
        // Widget Initialisation
        Widget::factory(array('site'=>$this->site));
        
    }
    
    public function after() {
        $this->site->tool->search_value = $this->site->search_value;
        $scripts = $styles = array();
        $styles  = Kohana::find_file('../assets/themes/'.$this->site->themes.'/css/layout',$this->layout,'css')
                    ? array ($this->site->themes_css.'layout/'.$this->layout.'.css'=>'screen,projection')
                    : ( Kohana::find_file('../assets/themes/default/css/layout',$this->layout,'css')
                        ? array ($this->site->bs_css.'layout/'.$this->layout.'.css'=>'screen,projection')
                        : $styles);
        
        if ($this->predefined) {        
            $styles  = array_merge($styles,array (
                $this->site->themes_css.'general/colorbox.css'    => 'screen,projection',
                    $this->site->system_css.'general/default.css'    => 'screen,projection',
                    $this->site->system_css.'general/reset.css'      => 'screen,projection',
                ));            
            
            $scripts = array (
                    $this->site->themes_js.'plugin/jquery.colorbox.js',
                    $this->site->system_js.'custom/japi.js',
                    $this->site->system_js.'library/lib.jquery.1.7.1.js',
                    //$this->site->bs_js.'plugin/less-1.3.0.min.js',
                );
        }
            
        if ($this->auto_render){
            // Add defaults to template variables.
            $this->template->styles  = array_reverse(array_merge($this->template->styles, $styles));
            $this->template->scripts = array_reverse(array_merge($this->template->scripts, $scripts)); 
        }
            
        parent::after();
    }
    
    /**
     * Collect html meta element 
     * @param   mixed   string meta name or array ($key=>$value)
     * @param   mixed   it can be everything you want to ;)
     * @return  object  
    */
    public function meta($key,$value = NULL) {
        if (is_array($key))
            foreach ($key as $new_key=>$value) $this->site->meta->$new_key = $value;
        else
            $this->site->meta->$key = $value; 
        
        return $this;
    }
    
    /**
     * Collect page css style files
     * @param   mixed   string css file name or array ($media_name=>$media_type)
     * @param   mixed   it can be everything you want to ;)
     * @return  object  
    */
    public function styles($media_name,$media_type = NULL) {
        if (is_array($media_name))
            foreach ($media_name as $new_media_name=>$media_type) 
                $this->template->styles[$new_media_name] = $media_type;
        else
            $this->template->styles[$media_name] = $media_type; 
        
        return $this;
    }
    
    /**
     * Collect page javascript files
     * @param   mixed   string css file name or array ($media_name)
     * @param   mixed   it can be everything you want to ;)
     * @return  object  
    */
    public function scripts($media_name) {
        if (!is_array($media_name)) $media_name = func_get_args();
        foreach ($media_name as $new_media_name) 
            $this->template->scripts[] = $new_media_name; 
        
        return $this;
    }
    
    /**
     * Collect all required data to perform our site. I think it will 
     * increase developing timing and absolutely make simple our code.
     * @param   mixed   string variable name or array ($key=>$value)
     * @param   mixed   it can be everything you want to ;)
     * @return  object  
    */
    public function set($key = NULL,$value = NULL) {
        if (is_array($key))
            foreach ($key as $new_key=>$value) $this->site->$new_key = $value;
        else
            $this->site->$key = $value; 
        
        return $this;
    }
    
    public function render($layout = NULL) {
        $layout = empty($layout) ? $this->layout : $layout;
        $locate = Kohana::find_file('views/layout/'.$this->site->themes,$layout)
                    ? 'layout/'.$this->site->themes.'/'.$layout
                    : (Kohana::find_file('views/layout/default',$layout) || $layout == 'no-layout' ? 'layout/default/'.$layout : false);
                
        $this->template->content = !empty($locate)
            ? ( $layout == 'no-layout' ? $this->site->content : $this->load($locate) )
            : $this->view('general/error-container')->set('message',__('layout_not_found',array('%name'=>$layout)));
    }
    
    /**
     * @param   string  View file name 
     * @param   array   Passing variable
     * @return  object  View::factory() 
     */
    public function view($view = null, array $vars = array()) {
        return $this->load($view,$vars);
    }
    
    /**
     * @param   string  View file name 
     * @param   array   Passing variable
     * @return  object  View::factory() 
     */
    public function html($view = null, array $vars = array()) {
        return $this->load('html/'.$this->site->view_dir.'/'.$view,$vars);
    }
    
    /**
     * @param   string  View file name 
     * @param   array   Passing variable
     * @return  object  View::factory() 
     */
    private function load($view = null,  array $vars = array()) {
        return empty($view) ? NULL : View::factory($view,$vars)
                        ->set('site',$this->site);
    }
    
    protected function authorized($module,$action=null,$access = false) {
        if (empty($this->site->user->profile->role_id))
            return false;
            
        if ( $this->site->user->profile->role_id <= 1 )
            return $this->authorisation = true;        
        
        if (is_array($module)) {
            foreach ($module as $n_module => $action) {
                $actions = explode(',',$action);
                foreach ($actions as $n_action) {
                    if (!empty($this->site->user->profile->permission->$n_module->$n_action))
                        return $this->authorisation = true;
                    else 
                        $access = false;
                } 
            }
        } else {
            return $this->authorisation = !empty($this->site->user->profile->permission->$module->$action) 
                                                ? true: false;
        }
        
        $this->authorisation = $access;
    }
    
    protected function meta_rewrite($menu_id) {
        // Not implemented
        $get_meta = Model::factory('base')
                        ->select('nama','description')
                        ->from('meta')->where('site_menu_id = '.$menu_id)
                        ->execute()
                        ->current();
                        
        if (!empty($get_meta)) {
            $this->site->meta->name = $get_meta->name;
            $this->site->meta->description = $get_meta->description;
        }
    }
}    

?>