<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Cms Ajax User Class Controller
 * @Module      User
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_User_Ajax extends Controller_Space_Ajax {
    
    public function before() {
        parent::before();
        
        $this->model_role = Model::factory('role');
    }
    
    public function action_update_permission() {
        if ($this->post) {                
            $post = $this->site->tool->arr_to_object($this->post);
            $this->identify($post->cookie);
            
            if ($this->site->user->profile->role_id <= 2) {
                if ($post->value === 'true') {
                    // Insert to user_role_permissions
                    $set_permission = $this->model_role->insert_role_permission($post->role_id,$post->permission_id);
                    if (array($set_permission) && !empty($set_permission[1])) {
                        $last_row = $set_permission[0];
                        
                        // Insert to histories
                        $this->model_history->insert_history(array(
                                'source_id' => $last_row,
                                'owner' => $this->site->user->profile->id,
                                'table' => 'user_role_permissions',
                                'type' => 'set'
                            ));
                        $html = true;
                    } else{
                        $html = false;
                    }        
                } else {
                    $html = true;
                    
                    $get_role = $this->model_role->get_role_action_label($post->permission_id,$post->role_id);
                    if (!empty($get_role[0])) {
                        // Insert to histories
                        $history = $this->model_history->insert_history(array(
                                'source_id' => 0,
                                'owner' => $this->site->user->profile->id,
                                'table' => 'user_role_permissions',
                                'type' => 'unset'
                            ));
                        if (is_array($history) && !empty($history[0]) && !empty($history[1]) && count($history)==2) {
                            $description = __('unset_permission',array(
                                    '%actor' => __($this->site->user->profile->full_name),
                                    '%object' => __($get_role[0]->role),
                                    '%action' => __($get_role[0]->label)
                                    
                                ));
                            $this->model_history->insert_history_descriptions($history[0],$description);
                        }
                        
                        // Select histories id
                        $previous_history = Model::factory('history')->get_history(false)
                                                ->join(array('user_role_permissions','urp'))
                                                ->on('urp.id = histories.source_id')
                                                ->where('urp.permission_id = '.$post->permission_id)
                                                ->and_where('urp.role_id = '.$post->role_id)
                                                ->and_where('histories.table = user_role_permissions')
                                                ->execute()
                                                ->current();
                        if (isset($previous_history->id)) {
                            $description = __('set_permission',array(
                                    '%actor' => __($this->site->user->profile->full_name),
                                    '%object' => __($get_role[0]->role),
                                    '%action' => __($get_role[0]->label)                                    
                                ));
                            $this->model_history->insert_history_descriptions($previous_history->id,$description);    
                        }
                    }
                    $this->model_role->del_role_permission(true)->where('permission_id = '.$post->permission_id)
                        ->and_where('role_id = '.$post->role_id)
                        ->execute();
                    
                }  
            }else{
                $html = false;
            }
        } else {
            $html = false;
        }   
        $this->ajax = json_encode($html);
    }
    
    public function action_delete_roles() {
        $get_role = Model::factory('role')->get_role($this->param1);
        $delete = $this->db->delete('roles')->where('id = '.$this->param1)->execute();
        if ($delete == 1) {
            $history = Model::factory('history');
            $insert  = $history->insert_history(array(
                    'table' => 'roles',
                    'owner' => $this->site->user->profile->id,
                    'source_id' => $this->param1,
                    'type'  => 'delete',
                    'description' => $this->site->user->profile->full_name.' '.__('delete_role',array('%role'=>$get_role->label))
                ));
            
            $this->db->delete('user_role_permissions')->where('role_id = '.$this->param1)->execute();
            $this->db->update('users')->set('role_id',0)->where('role_id = '.$this->param1)->execute();
        }
        $result = true;
        $this->ajax = json_encode($result);
    }
    
    public function action_delete_user() {
        $result = false;
        $this->ajax = json_encode($result);
    }
}
   

?>