<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Role Listing View
 * @Module      User
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

?>
<script>
    $(document).ready(function(){
        $('form#frm_search').validate({
            errorPlacement : function(error, element) {},
            submitHandler: function(){
                window.location.href = bs_cms+'user/manage/search/'+($('input[name="search_key"]').val());    
            }  
        });    
    });
</script>

<div class="widget_cms">
    <div class="fl"><?php echo Form::button_new($site,'user/manage/form/create'); ?></div>
    <div class="fr">
        <form action="<?php echo $site->bs_cms;?>user/manage/search" method="POST" id="frm_search">        
            <input tabindex="0" type="text" name="search_key" class="required" value="<?php echo $site->search_value; ?>"/>
            <input type="submit"/>
        </form>
    </div>
    <div class="clear"></div>
</div>

<table class="webarq_percent_table" id="role-listing">
    <thead>
        <tr>
            <th class="checkbox"></th>
            <th class="no"><?php echo __('no');?></th>
            <th><?php echo __('full_name');?></th>
            <th><?php echo __('username');?></th>
            <th><?php echo __('email');?></th>
            <th><?php echo __('role_name');?></th>
            <th><?php echo __('status');?></th>
            <th class="action"><?php echo __('action');?></th>
        </tr>
    </thead>
    
    <tbody>
        <?php
            if (!empty(Paging::$init->list_items[0])) {
                $index = Paging::$page->current_first_item;
                foreach (Paging::$init->list_items as $user) {
                    $modify_class = __make_class($index,$user->status);
                    $modify_class = $user->username == 'superadmin' ? 'listing_restricted' : $modify_class;
                    
                    echo '<tr class="'.$modify_class.'">',"\n";
                        echo '<td class="checkbox">'; 
                            if ($user->is_system == 0) {       
                                echo Form::checkbox('','',false,array(
                                        'class' => 'tocheck',
                                        'idx' => $user->id
                                    ));       
                            }
                        echo '</td>';
                        echo '<td class="center">'.$index.'</td>';
                        echo '<td>'.$site->tool->mixed_search($user->full_name).'</td>';
                        echo '<td>'.$site->tool->mixed_search($user->username).'</td>';
                        echo '<td>'.$site->tool->mixed_search($user->email).'</td>';
                        echo '<td>'.$site->tool->mixed_search($user->role_name).'</td>';
                        echo '<td>'.__($user->status).'</td>';
                        echo '<td class="center">';
                            if ($user->is_system == 0) {
                                $list_action  = $user->status == 'active' ? 'deactivate' : 'activate';
                                $update_value = $user->status == 'active' ? 'inactive' : 'active';
                                  
                                echo Form::list_action($site,$list_action,array(   
                                        "class"  => "ajax",
                                        "href"   => $site->bs_cms.'system/ajax/update-status/users/'.$update_value.'/'.$user->id,
                                        "i_have" => '{
                                                "session": "'.$site->cookie.'",
                                                "message": [{
                                                            "title":"'.__('confirmation').'",
                                                            "body":"'.__('action_confirmation',array('%action'=>$list_action,'%data'=>__('user'.' '.$user->full_name))).'"
                                                        }]
                                            }',
                                    ));
                                echo '&nbsp; &nbsp;';
                                
                                echo Form::list_action($site,'edit',array(   
                                        'title' => __('edit_user'),
                                        'href'  => $site->bs_cms.'user/manage/form/edit/'.$user->id
                                    ));
                                echo '&nbsp; &nbsp;';
                                
                                /**                             
                                echo Form::list_action($site,'delete',array(   
                                        'title' => __('delete_role'),
                                        "href"   => $site->bs_cms.'user/ajax/delete-user/'.$user->id,
                                        'class' => 'ajax',
                                        "i_have" => '{
                                                "session": "'.$site->cookie.'",
                                                "message": [{
                                                            "title":"'.__('confirmation').'",
                                                            "body":"'.__('action_confirmation',array('%action'=>'delete','%data'=>__('role'.' '.$user->full_name))).'"
                                                        }]
                                            }',
                                    ));
                                **/
                                echo '&nbsp; &nbsp;';
                            }
                        echo '</td>';
                    echo '</tr>',"\n";
                    $index++;
                }
            } else {
                echo '<tr class="listing_no_data"><td colspan="8">'.__('no_data').'</td></tr>';
            }
        ?>
    </tbody>
    
    <tfoot>
        <tr>
            <td >
                <div id="corner"></div>
            </td>
            <td colspan="7">
                <?php 
                    echo Html::anchor('#',__('check_all'),array('class'=>'checkbox_trigger check', 'id'=>'active'));
                    echo '&nbsp;|&nbsp;';
                    echo Html::anchor('#',__('uncheck_all'),array('class'=>'checkbox_trigger uncheck', 'id'=>'inactive'));
                    echo '&nbsp;&nbsp;';
                    echo Form::select(
                            'run_trigger',
                            array(
                                ''  => __('with_selected'),
                                //'user/ajax/delete-user' => __('delete'),
                                'system/ajax/update-status/users/active' => __('activate'),
                                'system/ajax/update-status/users/inactive' => __('deactivate'),
                            ), 
                            null, 
                            array(
                                'class'    => 'general',
                                'id'       => 'run_trigger',
                                'href'     => $site->bs_cms,
                                'disabled' => 'disabled',
                                'i_have'   => '{"table":"histories","session":"'.$site->cookie.'","model":"history"}'
                            )
                        );
                ?>
            </td>
        </tr>
    </tfoot>
</table>

<div class="horizon_separator_two" style="margin-bottom: 0px;"></div>
<div class="right">
    <?php if (!empty(Paging::$init->list_items[0])) echo Paging::$page->render();?>
</div>
    