<?php

defined('SYSPATH') or die('No direct script access.');

/**
 * @Author 		Daniel Simangunsong
 * @Codename	Nouspeed.Com
 * @copyright 	2012
 * @Package	    Welcome Controller
 * @Module      ~
 * @Themes      ~
 * 
 * Calm seas, never make skillfull sailors	
 * */
class Controller_Site_Search_Pages extends Controller_Space_Site {
    
    protected $site;
    protected $permalink;
    
    public function before() {  
       parent::before();     
       $this->site->menu->id = Model::factory('menu')->menu_id('search');       
       $this->site->menu->active = 'search';
       $this->permalink = $this->request->param('permalink');
       
       /*** Banner ***/
       $this->banner = Widget::$instance->load('page-banner')
                                ->set('table','site_menus')
                                ->set('source_id',$this->site->menu->id)
                                ->set('position', 'Page Banner');
        
        $this->site->menu->title = Model::factory('search')->get_parent_menu_title('search');
       
       $this->title_menu = Model::factory('search')->menu_stuff('search');
       
       $current_active = Request::initial()->action();
       $category_active = (strcasecmp($current_active, 'index') == 0)?'address' : $current_active;
              
       /*** Left Content ***/
       $this->left_content = View::factory('general/left-content')
                ->set('search_left', true)
                ->set('email_widget', true);
    }

    public function action_view() {
       
        $raw_keyword = Arr::get(Request::initial()->post(), 'iptSearch');
        
        /* match <>%'\" /; */
        $pattern="/([&$<>%'\";\/])/";
        
        // replace with a space
        $keyword=preg_replace($pattern,' ',$raw_keyword);
        
        $search_result = $this->get_search_result($keyword);
                    
        /*** send $news_detail to be constructed at news detail view ** */
        $right_content = View::factory('html/site/search/right-content')
                ->set('search_result', $search_result);
        
        $this->set('title', 'Contact | ' . $this->site->meta->title)
             ->meta('title', 'Contact | ' . $this->site->meta->title)
             ->set('banner',$this->banner)
             ->set('left_content', $this->left_content)
             ->set('right_content', $right_content)
             ->render();
    }
    
    /*
     * 
     */
    private function get_search_result($param = null){
       
        if(empty($param)){
            $search_result = null;
        } else {
            $search_result =  Model::factory('search')->search_result($param);
        }
        
        return ($search_result==null) ? null : $search_result;
    }
        

}

// End Welcome
