<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Installation Configuration
 * @Module      User
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

$user = User::factory();

return array (
    'configuration' => '
        {
            "users" : 
                {
                    "id" : {
                            "type" : "int",
                            "primary" : true,
                            "notnull" : true,
                            "increment" : true
                        },
                    "is_system" : {
                            "type" : "boolean",
                            "default" : 0
                        },
                    "role_id" : {
                            "type" : "smallint",
                            "form" : {
                                    "default" : {
                                            "label" : "role_name",
                                            "name" : "role_id",
                                            "class" : "required",
                                            "function" : "user::form_select_role"
                                        },
                                    
                                    "cms_user_form" : { 
                                            "order" : "6"
                                        }
                                }
                        },
                    "username" : {
                            "type" : "varchar",
                            "length" : 20,
                            "form" : {
                                    "default" : {
                                            "label" : "username",
                                            "name" : "username",
                                            "class" : "required",
                                            "id" : "username"
                                        },
                                    "login" : { },
                                    "cms_user_form" : { }
                                }
                        },
                    "password" : {
                            "type" : "char",
                            "length" : 64,
                            "form" : {
                                    "default" : {
                                            "label" : "password",
                                            "name" : "password",
                                            "class" : "required",
                                            "type" : "password"
                                        },
                                    "login" : { },
                                    "cms_user_form" : {  }
                                }
                        },
                    "email" : {
                            "type" : "varchar",
                            "length" : 30,
                            "form" : {
                                    "default" : {
                                            "label" : "email",
                                            "name" : "email",
                                            "id" : "email",
                                            "class" : "required email",
                                            "type" : "text"
                                        },
                                    "cms_user_form": {  }    
                                }
                        },
                    "status" : { 
                            "type" : "enum",
                            "option" : "active,inactive,banned,pending,deleted",
                            "default" : "active"
                        },
                    "activation_key"  : {
                            "type" : "char",
                            "length" : 10
                        }
                },
            "user_details" : 
                {                       
                    "user_id" : {
                            "type" : "int",
                            "primary" : true,
                            "seek" : "users",
                            "used_in" : "cms_user_form"
                        },
                    "first_name" : {
                            "type" : "varchar",
                            "length" : 20,
                            "form" : {
                                    "default" : {
                                            "label" : "first_name",
                                            "name" : "first_name",
                                            "order" : 4,
                                            "class" : "required"
                                        },
                                    "register" : { } ,
                                    "cms_user_form" : { }
                                }
                        },
                    "last_name" : {
                            "type" : "varchar",
                            "length" : 20,
                            "form" : {
                                    "default" : {
                                            "label" : "last_name",
                                            "name" : "last_name",
                                            "order" : 5,
                                            "class" : "required"
                                        },
                                    "cms_user_form" : { }
                                }
                        },
                    "middle_name" : {
                            "type" : "varchar",
                            "length" : 20
                        },
                    "sex" : { 
                            "type" : "enum",
                            "option" : "male,female",
                            "default" : "male",
                            "form" : {
                                    "default" : {
                                            "label" : "sex",
                                            "name" : "jenis_kelamin",
                                            "order" : 7,
                                            "class" : "required"
                                        },
                                    "cms_user_form" : { }
                                }
                        },
                    "address" : {
                            "type" : "text",
                            "form" : {
                                    "default" : {
                                            "label" : "address",
                                            "name" : "address",
                                            "order" : 8,
                                            "class" : "required"
                                        },
                                    "cms_user_form" : { }
                                }
                        },
                    "phone" : {
                            "type" : "varchar",
                            "length" : 20   ,
                            "form" : {
                                    "default" : {
                                            "label" : "phone",
                                            "name"  : "phone",
                                            "order" : 8,
                                            "class" : "required"
                                        }
                                }                         
                        },
                    "avatar" : {
                            "type" : "varchar",
                            "length" : 50
                        }
                },
            "user_sessions" : {
                    "user_id" : {
                            "type" : "int"
                        },
                    "session" : {
                            "type" : "varchar",
                            "length" : 85
                        },
                    "login" : {
                            "type" : "datetime"
                        },
                    "logout" : {
                            "type" : "datetime"
                        }
                },
            "roles" : {
                    "id" : {
                            "type" : "smallint",
                            "primary" : true,
                            "notnull" : true,
                            "increment" : true
                        },
                    "is_admin" : {
                            "type" : "tinyint",
                            "length" : 1,
                            "default" : 0,
                            "form" : {
                                    "default" : {
                                            "name"    : "is_admin",
                                            "order"   : 3,
                                            "type"    : "checkbox",
                                            "wording" : "is_admin",
                                            "value"   : "1",
                                            "class"   : "is_admin"                                           
                                        },
                                    "cms_role_form" : { }
                                }
                        },
                    "is_system" : {
                            "type" : "boolean",
                            "default" : 0
                        },
                    "label" : {
                            "type" : "varchar",
                            "length" : 20,
                            "form" : {
                                    "default" : {
                                            "label" : "role_name",
                                            "name"  : "label",
                                            "order" : 1,
                                            "class" : "required"
                                        },
                                    "cms_role_form" : { }
                                }
                        },
                    "status" : { 
                            "type" : "enum",
                            "option" : "active,inactive",
                            "default" : "active",
                            "form" : {
                                    "default" : {
                                            "label" : "status",
                                            "name"  : "status",
                                            "order" : 2,
                                            "class" : "required"
                                        },
                                    "cms_role_form" : { }
                                }
                        }
                },
            "permissions" : {
                    "id" : {
                            "type" : "bigint",
                            "primary" : true,
                            "increment" : true
                        },
                    "module_id" : {
                            "type" : "char",
                            "primary" : true,
                            "lenght" : 15
                        },
                    "action" : {
                            "type" : "varchar",
                            "primary" : true,
                            "length" : 100
                        },
                    "label" : {
                            "type" : "varchar",
                            "length" : 250
                        },
                    "description" : {
                            "type" : "text"
                        }
                },
            "user_role_permissions" : {
                    "id" : {
                            "type" : "bigint",
                            "primary" : true,
                            "increment" : true
                        },
                    "role_id" : {
                            "type" : "smallint"
                    },
                    "permission_id" : {
                            "type" : "int"
                    }
                                                                       
                },
            "tokens" : {
                    "user_id" : {
                            "type" : "int"
                        },
                    "token" : {
                            "type" : "varchar",
                            "length" : 250
                        },
                    "expired" : {
                            "type" : "datetime"
                        }
                }
        }
    ',
    'mandatory' => '
        {
            "roles" : 
                [
                    {   
                        "id" : 1,
                        "is_admin" : true,
                        "is_system" : 1,
                        "label" : "Superadmin",   
                        "status" : "active"
                    },
                    {
                        "id" : 2,
                        "is_admin" : true,
                        "is_system" : 1,
                        "label" : "Administrator",
                        "status" : "active"                    
                    }
                ],
            "users" : 
                [
                    {
                        "id" : 1,
                        "role_id" : 1,
                        "email" : "deni@webarq.com",
                        "username" : "superadmin",
                        "password" : "'.$user->make_password('webarqc0m').'",
                        "status" : "active",
                        "activation_key" : "1stVenue",
                        "is_system" : 1                        
                    },
                    {
                        "id" : 2,
                        "role_id" : 2,
                        "email" : "admin@webarq.com",
                        "username" : "administrator",
                        "password" : "'.$user->make_password('webarq').'",
                        "status" : "active",
                        "activation_key" : "2ndVenue"
                    }
                ],
            "user_details"  :
                [
                    {
                        "user_id" : 1,
                        "first_name" : "Deni",
                        "last_name" : "Santana",
                        "sex" : "male",
                        "address" : "web architect"
                    },
                    {
                        "user_id" : 2,
                        "first_name" : "Esteban",
                        "last_name" : "Alejandro",
                        "sex" : "male",
                        "address" : "Nous Verse logbox"
                    }
                ],
            "modules" : 
                [
                    {
                        "id" : "user",
                        "label" : "user", 
                        "is_system" : 1,
                        "status" : "active",
                        "ordering" : 900
                    }
                ],
            "permissions" : 
                [
                    {
                        "module_id" : "user",
                        "action" : "manage_permission",
                        "label" : "manage_permission"
                    },
                    {
                        "module_id" : "user",
                        "action" : "manage_role",
                        "label" : "manage_role"
                    },
                    {
                        "module_id" : "user",
                        "action" : "manage_user",
                        "label" : "manage_user"
                    },
                    {
                        "module_id" : "user",
                        "action" : "edit",
                        "label" : "edit_profile"
                    },
                    {
                        "module_id" : "user",
                        "action" : "view",
                        "label" : "view_profile"
                    },                 
                    {
                        "module_id" : "system",
                        "action" : "manage_site_menu",
                        "label" : "manage_site_menu"
                    }
                ],
            "module_menus" :
                [
                    {
                        "id" : "user_1",
                        "module_id" : "user",
                        "parent_id" : 0,
                        "label" : "profile",
                        "permalink" : "profile",
                        "ordering" : 1
                    },
                    {
                        "id" : "user_2",
                        "module_id" : "user",
                        "parent_id" : 0,
                        "label" : "user_list",
                        "permalink" : "manage",
                        "ordering" : 2
                    },
                    {
                        "id" : "user_3",
                        "module_id" : "user",
                        "parent_id" : 0,
                        "permalink" : "role",
                        "label" : "role",
                        "ordering" : 3
                    },
                    {
                        "id" : "user_4",
                        "module_id" : "user",
                        "parent_id" : 0,
                        "label" : "permission",
                        "permalink" : "permission",
                        "ordering" : 4
                    }
                ],
            "module_menu_permissions" : 
                [
                    {
                        "module_menu_id" : "user_1",
                        "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'user\' AND `action` = \'view\'"
                    },
                    {
                        "module_menu_id" : "user_2",
                        "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'user\' AND `action` = \'manage_user\'"
                    },
                    {
                        "module_menu_id" : "user_3",
                        "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'user\' AND `action` = \'manage_role\'"
                    },
                    {
                        "module_menu_id" : "user_4",
                        "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'user\' AND `action` = \'manage_permission\'"
                    },
                    {
                        "module_menu_id" : "system_3",
                        "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'system\' AND `action` = \'manage_site_menu\'"
                    }
                ],
            "module_menu_positions" : 
                [
                    {
                        "module_menu_id" : "user_1",
                        "position" : "left"
                    },
                    {
                        "module_menu_id" : "user_2",
                        "position" : "left"
                    },
                    {
                        "module_menu_id" : "user_3",
                        "position" : "left"
                    },
                    {
                        "module_menu_id" : "user_4",
                        "position" : "left"
                    }
                ],
            "user_role_permissions" : 
                [
                    {
                        "role_id" : "2",
                        "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'user\' AND `action` = \'manage_permission\'"
                    },
                    {
                        "role_id" : "2",
                        "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'user\' AND `action` = \'manage_role\'"
                    },
                    {
                        "role_id" : "2",
                        "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'user\' AND `action` = \'manage_user\'"
                    },
                    {
                        "role_id" : "2",
                        "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'user\' AND `action` = \'edit\'"
                    },
                    {
                        "role_id" : "2",
                        "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'user\' AND `action` = \'view\'"
                    },
                    {
                        "role_id" : "3",
                        "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'user\' AND `action` = \'edit\'"
                    },
                    {
                        "role_id" : "3",
                        "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'user\' AND `action` = \'view\'"
                    }
                ]
        }
    '
);
?>
