<?php

defined('SYSPATH') or die('No direct script access.');

/**
 * @Author      Daniel Simangunsong
 * @author      Deni Budhi Santana
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Widget Site Menu Controller
 * @Module      Global Config
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
 * */
class Widget_Left_Menu_Pages_Controller extends Setup {

    public function data() {
        
        /*** the active menu ***/
        $current_menu = Request::initial()->param('param1');
        
        $menu_active = $current_menu;
                
        /*** search for id of parent ***/
        $query = DB::Select('parent_id', 'id')
                ->from('site_menus')
                ->where('permalink', '=', $menu_active)
                ->and_where('status','=','active')                
                ->as_object()
                ->execute();
        
        if ($query->valid()) {
            if($query->current()->parent_id==0){
                $id = $query->current()->id;
            }else{
                $id = $query->current()->parent_id;
            }            
        } else {
            $id = 0;
        }
        
        
        
        /*** traverse the menu ***/
        $menus = Model::factory('menu')
                ->class_var('position_id', 1)
                ->class_var('status_menu', 'active')
                ->traverse_limit_menu(intval($id));   
        
        /** * search for the first child of company ** */
        $query_top_menu = DB::Select('permalink')
                ->from('site_menus')
                ->where('parent_id', '=', $id)
                ->and_where('status','=','active')                
                ->limit(1)
                ->order_by('ordering', 'asc')
                ->as_object()
                ->execute();
               
        if ($query_top_menu->valid()) {
            $top_menu = str_replace('about-us/', '', $query_top_menu->current()->permalink);
        } else {
            $top_menu = null;
        }
        
        /*** define current active menu ***/
        if (strcmp($menu_active, 'about-us') == 0 ) {
            $active = $top_menu;
        } else {
            $active = $menu_active;
        }
        
        return $this->traversing_ul($menus, $active);
    }

    private function traversing_ul(array $sources = null, $active = 'home', $level = 0) {
        $result = '';        
        if (!empty($sources)) {
            $result .= '<ul ';

            /** Class Ul * */
            $result .= $level == '0' ? 'site-menu parent' : 'child level-' . $level;
            $result .= '"';
            /** End Class * */
            $result .= '>';

            foreach ($sources as $key => $value) {
                /** Pre-Data * */
                $item = Translate::table('site_menus')->item($value['data'])->compile();

                $href = $item->is_system ? Config::$site_config->bs_site . $item->permalink : Config::$site_config->bs_site . 'pages/' . $item->permalink;
                //$href = Config::lang_uri($href); // currently not need multilang

                if($active == strtolower(str_replace('about-us/', '', $item->permalink))){
                    $isactive = 'active';
                }else{
                    $isactive = '';
                }
                
                
                /** Li Section * */
                $result .= '<li ';
                $result .= '>';

                /** A Section * */
                $result .= '<a ';
                $result .= 'class="';
                $result .= $isactive ;
                $result .= '"  href="' . $href . '" ';
                $result .= '>';
                $result .= $item->menu_title;
                $result .= '</a>';

                /** Child * */
                /*
                if (!empty($value['child'])) {
                    $next_lvl = $level + 1;
                    $result .= $this->traversing_ul($value['child'], $active, $next_lvl);
                }
                */
                $result .= '</li>';
            }

            $result .= '</ul>';
        }
        return $result;
        
        
    }

}