<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Model Class (Events Management)
 * @Module      Events 
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 


class Model_Event extends Model_Base {
    
    /**
     * @var integer content id of history item
     */
    public function historymap($id,$action = 'create') {
        $check = $this->select('title')->from('events')->where('id = '.$id)->execute()->current();
        return empty($check->title) 
            ? __('unknown') 
            : __($action,array(
                    '%item' => 'events "'.$check->title.'"'
                ));
    }
    
    
    /**
     * @param boolean execute query data or return object
     */ 
    public function limit_event($execution = TRUE){
        $events = Setup::join_histories('events')
                    ->order_by('event_date','desc');                     
        return $execution === true ? $events->execution() : $events;
    }
    
    /**
     * @param
     */
    public function recent_event($limit = 5) {
        $result = DB::select()
                ->from('events')
                ->where('status', '=', 'active')
                ->order_by('event_date', 'desc')
                ->limit($limit)
                ->as_object()
                ->execute();
        
        return ($result->valid()) ? $result : null ;
    }    
    
   
    /**
     * @var mixed param 
     */ 
    public function get_by($params) {
        $get_params = func_get_args();
        $querying = Setup::join_histories('events');
        
        if ($get_params[0] == 'field') {
            $field_name = "events.$get_params[1]";
            $querying->where("$field_name = $get_params[2]");
        } else {
            return NULL;
        }
        
        return $querying->execute();
    }
    
    /*
     * 
     */
    public function get_all_published_events(){
        $result = DB::select()
                ->from('events')
                ->where('status', '=', 'active')
                ->order_by('event_date', 'desc')
                ->as_object()
                ->execute();
        
        return ($result->valid()) ? $result : null ;
    }
    
    /*
     * 
     */
    public function get_parent_menu_title($param){
        
        $menu_title = null;
        
        $query = DB::select('parent_id', 'permalink', 'menu_title')
                ->from('site_menus')
                ->where('permalink', '=', $param)
                ->as_object()
                ->execute();
        
        if($query->valid()){
            $parent_id = $query->current()->parent_id;
            
            if($parent_id==0){
                $menu_title = $query->current()->menu_title;
            } else {
                $query2 = DB::select('menu_title')
                    ->from('site_menus')
                    ->where('id', '=', $parent_id)
                    ->as_object()
                    ->execute();
                $menu_title = ($query2->valid()) ? $query2->current()->menu_title : null;
            }            
        }        
        return $menu_title;        
    }
    
    /*
     * 
     */
    public function get_image_path($permalink=null){
        $image_path = null;
        
        $query = DB::select('image_path')
                ->from('events')
                ->where('permalink', '=', $permalink)
                ->as_object()
                ->execute();
        
        if($query->valid()){
            $image_path = $query->current()->image_path;        
        }   
        
        return $image_path;
    }
    
    
}