<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Cms Class Controller
 * @Module      Page
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_System_SiteMenu extends Controller_Space_Cms {
    protected $site;
    protected $model_menu;
    
    public function before() {
        parent::before();
        $this->site->menu->active = 'site_menu';
        $this->authorized(array(
                'page' => 'create,edit,delete,view',
            )); // Check permission
        
        $this->model_menu = Model::factory('menu');
            
        $this->scripts(array(
                $this->site->system_js.'plugin/jquery.validate.additional',
                $this->site->system_js.'plugin/jquery.validate',
            ));
    }
    
    public function action_index() {
        $this->action_manage();
    }
        
    public function action_manage() {
        $this->styles(array(
                $this->site->themes_js.'plugin/nested_table/jquery.treeTable.css' => 'screen,projection',
            ));
        $this->scripts(array(
                $this->site->themes_js.'plugin/nested_table/jquery.treeTable.js',
                $this->site->system_js.'library/ui/jquery.ui.draggable.min.js',
                $this->site->system_js.'library/ui/jquery.ui.droppable.min.js',
                $this->site->system_js.'library/ui/jquery.ui.sortable.min.js',
                $this->site->system_js.'library/ui/jquery-ui-1.8.16.custom.min.js',
            ));
            
        if ($this->authorisation === true) {  
            $paging = Pagination::factory(array(
                    'total_items'    => $this->model_menu->item_total(false)
                                            ->where('site_menus.parent_id = 0')->execute()->current()->total,
                    'items_per_page' => 15,
                    'view'           => 'pagination/webarq'
                ));
            $content = Traversal::traversing_table(array(
                    'columns'    => array(
                            'menu_title'   => 'title',
                            'ordering'     => 'order',
                            'status'       => 'status',
                            'time_created' => 'create_time',
                            'last_updated' => 'last_update'
                        ),
                    'listing_template' => 'html/cms/system/traversing-listing-menu',    
                    'array_data'       => $this->model_menu->traverse_limit_menu(0,$paging->offset,$paging->items_per_page),
                    'paging'           => $paging,           
                ));
                
            $this->meta('title',__('manage_site_menu'))
                     ->set('title',__('site_menu_list'))
                     ->set('content',$content)
                     ->render();
        }
    }
    
    public function action_form() { 
        $this->authorized(array(
                'page' => 'create, edit, view',
            ));
                        
        if ($this->authorisation === true) {
            if ($this->param1 == 'create' || $this->param1 == 'edit') {
                $title = __($this->param1,array('%item'=>__('page_menu',array('%s'=>''))));
                $data  = $this->param1 == 'create' 
                    ? null 
                    : $this->model_menu->get_menu(false)->where('id = '.$this->param2)->execute()->current();
                
                $this->meta('title',__('manage_menu_page'))
                     ->set('title',$title)
                     ->set('content',$this->html('menu-form')
                            ->set('transaction',$this->param1)
                            ->set('data',$data)
                            ->set('form_action',$this->param1 == 'create' ? 'save' : 'update/'.$this->param2)
                          )
                     ->render();
            }    
        }
    }
    
    public function action_save() {
        $this->authorized('page','create');
        
        if ($this->post && $this->authorisation === true) {
            $transaction  = Transaction::insert(array(   
                    'package'   => 'base',
                    'form'      => 'menu',
                    'owner'     => $this->site->user->profile->id,   
                    'order_option'   => array (
                            'table'          => 'site_menus',
                            'field'          => 'ordering',
                            'input_name'     => 'ordering',
                            'previous_input' => 'previous_ordering',
                            'parent'   => array(
                                    'field_name'     => 'parent_id',
                                    'input_name'     => 'parent',
                                    'previous_input' => 'previous_parent'
                                )
                        ),
                ));
            $transaction->_transaction_items['site_menus']->set('is_system',1);
            $transaction->check(false);
            $transaction->execute($transaction);
            
            
            if ($transaction === false){
                Session::instance()->set('message',__('transaction_failed',array('%item'=>'user')));
                $this->request->redirect('admin-cp/system/site-menu/form/create/error');
            }else{
                $this->request->redirect('admin-cp/system/site-menu/manage/success');
                return;    
            }
        }
        $this->request->redirect('admin-cp/system/site-menu');
    }
    
    public function action_update() {
        $this->authorized('page','edit');
        if ($this->authorisation === true && $this->post) {
            
            $transaction  = Transaction::update(array(   
                    'package'   => 'base',
                    'form'      => 'menu',
                    'owner'     => $this->site->user->profile->id,   
                    'order_option'   => array (
                            'table'          => 'site_menus',
                            'field'          => 'ordering',
                            'input_name'     => 'ordering',
                            'previous_input' => 'previous_ordering',
                            'parent'   => array(
                                    'field_name'     => 'parent_id',
                                    'input_name'     => 'parent',
                                    'previous_input' => 'previous_parent'
                                )
                        ),
                ));
            
            $arrays = Transaction::arrays(array(
                    'table'      => 'site_menu_position_applications',
                    'item_field' => array('site_menu_id','site_menu_position_id'),
                    'item_value' => array($this->param1,$this->post['position'])
                ));            
            $transaction->check(false);                
            $transaction->execute($transaction);
            
            if ($transaction === true || $arrays === true) {
                Session::instance()->set('message',__('success_update'));
            }else{
                Session::instance()->set('message',__('no_transaction',array('%transaction'=>'update')));
            }
            
            $this->request->redirect('admin-cp/system/site-menu/form/edit/'.$this->param1);
            return;
        }
        
        $this->request->redirect('admin-cp/system/site-menu/manage');
    }
    
    protected function filter() {
        // Condition Search
        $param_condition = array('search');
        if (in_array($this->param1,$param_condition)){
            $function = 'condition_'.$this->param1;
            $this->$function();    
        }
    }    
    
    protected function condition_search() {
        $this->site->search_value = $value_condition = $this->param2;
        
        Paging::$init->list_items->and_where_open()
            ->where('site_menus.menu_title like %'.$value_condition.'%')
            ->or_where('site_menus.status like %'.$value_condition.'%')
            ->and_where_close();            
    }
    
}