<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Cms Permission Class Controller
 * @Module      User
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 
 


class Controller_Cms_User_Permission extends Controller_Space_Cms {
    protected $site;
    protected $accessible;
    
    public function before() {
        parent::before();
        $this->authorized('user','manage_permission');
    }
    
    public function action_index() {
        if ($this->authorisation === true)
            $this->meta('title',__('permission_setting'))
                 ->set('title',__('permission_setting'))
                 ->set('content',Widget::$instance->load('user::permission-settings')->set('role_id',$this->site->user->profile->role_id))
                 ->render();
                 
    }
    
    public function action_update() {
        $post = $this->request->post();
        
        if ($post) {
            foreach ($post as $permission_id => $roles) {
                foreach ($roles as $role_id => $on) {
                    echo $permission_id.' - '.$role_id.'<br/>';
                }        
            }
        }
    }
    
}
