<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Cms Class Controller
 * @Module      Career
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_Career_Manage extends Controller_Space_Cms {
    protected $site;
    protected $model;
    
    public function before() {
        parent::before();
        $this->site->menu->active = 'career_list';
        $this->authorized(array(
                'career' => 'create,edit,delete,view',
            )); // Check permission           
         
        
        $this->scripts(array(
                $this->site->system_js.'plugin/jquery.validate.additional',
                $this->site->system_js.'plugin/jquery.validate',
                $this->site->system_js.'party3d/ckeditor/adapters/jquery',
                $this->site->system_js.'party3d/ckeditor/ckeditor',
            ));
    }  
    
    protected function condition() {
        // Condition Search
        $param_condition = array('search');
        if (in_array($this->param1,$param_condition)){
            $function = 'condition_'.$this->param1;
            $this->$function();    
        }
    } 
    
    protected function condition_search() {
        $this->site->search_value = $value_condition = $this->param2;
        
        Paging::$init->list_items->and_where_open()
            ->where('careers.title like %'.$value_condition.'%')
            ->or_where('careers.status like %'.$value_condition.'%')
            ->or_where('careers.tanggal like %'.$value_condition.'%')
            ->and_where_close();
    }
    
    public function action_index() {
        $this->action_list();
    }
    
    public function action_manage() {
        $this->action_list();
    }
        
    public function action_list() {    
        if ($this->authorisation === true) {
            Paging::factory(array(
                    'model' => 'career',
                    'items_per_page' => 10
                ));
            $this->condition();
            Paging::$init->compile();
            
            $this->meta('title',__('manage_career'))
                 ->set('title',__('manage_career'))
                 ->set('content',$this->html('list'))
                 ->scripts($this->site->system_js.'plugin/jquery.validate')
                 ->render();
        }
    }
    
    public function action_form() {
        $this->styles(array(
                 $this->site->system_css.'js/ui/base/jquery.ui.all' => 'screen,projection'
            ));
        $this->scripts(array(
                //$this->site->system_js.'party3d/ui/jquery.ui.datetimepicker.js',
                $this->site->system_js.'library/ui/jquery.ui.datetimepicker.js',
                $this->site->system_js.'library/ui/jquery-ui-1.8.16.custom.min.js',
            ));
        // Extend permission
        $class_action = $this->param1;
        $this->authorized(array('career' => $class_action));
        
        if ($this->authorisation === true) {
            if ($this->param1 == 'create' || $this->param1 == 'edit') {
                $title = __($this->param1,array('%item'=>__('career',array('%s'=>''))));
                
                /** Get data **/
                $data  = $this->param1 == 'create' ? null : Model::factory('career')->getById($this->param2);
                           
                /** Form configuration **/
                /** Form action **/
                $form_action  = $this->param1 == 'create' ? 'save' : 'update';                
                $form_action .= !empty($data->id) ? '/'.$data->id : '';
                
                /** Form Build **/
                $form = $this->html('form')
                            ->set('transaction',$this->param1)
                            ->set('data',$data)
                            ->set('form_action',$form_action);
                            
                /** Rendering **/        
                $this->meta('title',$title)
                     ->set('title',$title)
                     ->set('content',$form)
                     ->render();
            }    
        }
        
    }
    
    public function action_save() {        
        $this->authorized(array(
            'career' => 'create'
        ));
        
        if ($this->authorisation === true) {
            if($this->post){
                $result = false;
                $transaction =  Transaction::insert(array(
                       'package'        => 'career',
                       'form'           => 'career',
                       'owner'          => $this->site->user->profile->id
                  ));
                $transaction->check(false);            
                $transaction->execute($result);   
                                           
                if ($result === false){
                    Session::instance()->set('message',__('transaction_failed',array('%item'=>strtolower(__('career')))));
                    $this->request->redirect('admin-cp/career/manage/form/create/error');
                }
            }
        }        
        $this->request->redirect('admin-cp/career/manage'); 
    }
    
    public function action_update() {        
        $this->authorized(array(
            'career' => 'edit'
        ));
         
        if ($this->authorisation === true) {
            if($this->post){
                $transaction =  Transaction::update(array(
                       'package'        => 'career',
                       'form'           => 'career',
                       'owner'          => $this->site->user->profile->id
                                              
                  ));
                $transaction->check(false);
                $transaction->execute($result);  
                
                if ($result === true) {
                    Session::instance()->set('message',__('success_update'));
                }else{
                    Session::instance()->set('message',__('no_transaction',array('%transaction'=>'update')));
                }
            }
        }    
        
        $this->request->redirect('admin-cp/career/manage/form/edit/'.$this->param1);
    }
    
    public function action_delete() {       
        $this->authorized('career','delete');
        if ($this->authorisation) {
            $delete = Transaction::delete('careers')
                    ->owner($this->site->user->profile->id,$this->site->user->profile->full_name)
                    ->history_item('title')
                    ->row($this->param1)
                    ->execute($result);
                            
        }
        $this->request->redirect('admin-cp/career/manage');
    }
    
    
    public function action_applicant()
    {
        $i = $this->param1; 
        $l = 10;        
        $m = Model::factory('careerapplicant');
        $t = $m->getTotalApplicant($i);       
        $p = Pagination::factory(array(                
                        'items_per_page' => $l,
                        'total_items'    => $t 
                    ));
        if ($this->param2 === 'search' && !empty($this->param3))
        {
            $this->site->search_value = $this->param3;
            $d = $m->getLimit($i,$l,$p->offset,false)
                    ->and_where_open()->where('name','like','%'.$this->param3.'%')->or_where('email','like','%'.$this->param3.'%')->and_where_close()
                    ->execute()->as_array();
        }
        else
        {
            $d = $m->getLimit($i,$l,$p->offset);    
        }
        
        
        $this->meta('title',__('manage_career'))
                ->set('title',__('manage_career') . ' Application')
                ->set('content',$this->html('applicant-list',array(
                        'paging' => $p,
                        'items'  => $d,
                        'total'  => $t
                    )))
                ->scripts($this->site->system_js.'plugin/jquery.validate')
                ->render();
    }
    
    public function action_followup()
    {
        $i = $this->param1;
        
        if (is_numeric($i))
        {
            $m = Model::factory('careerapplicant');
            $d = $m->getById($i,array('name','career_id'));
            if (!empty($d))
            {
                $s = $m->followup($i);
                if ($s)
                {
                    Session::instance()->set('followUp','Success. ' . $d['name'] . ' application has been mark as followed');
                }
                else 
                {
                    Session::instance()->set('followUp','Ups. ' . $d['name'] . ' application already mark as followed');
                }                
                $this->request->redirect('admin-cp/career/manage/applicant/' . $d['career_id']);
                return;
            }
        }
        $this->request->redirect('admin-cp/career/manage');
    }
}
   

?>