<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Model Class (Career)
 * @Module      Career
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 


class Model_Career extends Model_Base {
    
    /**
     * @var integer content id of history item
     */
    public function historymap($id,$action = 'create') {
        $check = $this->select('title')->from('career')->where('id = '.$id)->execute()->current();
        return empty($check->title) 
            ? __('unknown') 
            : __($action,array(
                    '%item' => 'career "'.$check->title.'"'
                ));
    }
    
    
    /**
     * @param boolean execute query data or return object
     */ 
    public function limit_career($execution = TRUE){
        $events = Setup::join_histories('careers')->order_by('tanggal');                     
        return $execution === true ? $events->execution() : $events;
    }
    
    public function getById($id,$activeness = null)
    {
        $g = Setup::join_histories('careers')->where('careers.id','=',$id);
        if (isset($activeness)) $g->where('careers.status','=',$activeness);
        
        return $g->execute()->current();
    }
    
    public function getTotalApplicant($careerId)
    {
        return DB::select(array(DB::expr('COUNT(id)'),'total'))->from('submit_careers')->where('career_id','=',$careerId)->execute()->get('total');
    }
}
?>