<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Module Package Installation
 * @Module      Career
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

return array (
    'configuration' => 
        '
            {
                "careers" :
                    {
                        "id" : 
                            {
                                "type" : "int",
                                "primary" : true,
                                "notnull" : true,
                                "increment" : true
                            },
                        "title" : 
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "multilang" : true,
                                "form" :
                                    {
                                        "career" :
                                            {
                                                "label" : "title",
                                                "class" : "title required"
                                            }
                                    }
                                
                            },
                        "tanggal" :
                            {
                                "type" : "date",
                                "form" : 
                                    {
                                        "career" :
                                            {
                                                "label" : "Date",
                                                "class" : "datepicker required"
                                            }
                                    }
                            },
                        "permalink" : 
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "form" :
                                    {
                                        "career" :
                                            {
                                                "label" : "permalink",
                                                "class" : "permalink"
                                            }
                                    }
                            },
                        "description" : 
                            {
                                "type" : "longtext",
                                "form" :
                                    {
                                        "career" :
                                            {
                                                "label" : "description",
                                                "class" : "description"
                                            }
                                    }
                            },
                        "status" : 
                            {
                                "type" : "enum",
                                "option" : "active,inactive",
                                "default" : "active",
                                "form" :
                                    {
                                        "career" :
                                            {
                                                "label" : "status",
                                                "class" : "status"
                                            }
                                    }
                            }
                    },
                    
                "submit_careers" :
                    {
                        "id" : 
                            {
                                "type" : "int",
                                "primary" : true,
                                "notnull" : true,
                                "increment" : true
                            },
                        "career_id" :
                            {
                                "type" : "int"
                            },    
                        "name" : 
                            {
                                "type" : "varchar",
                                "length" : 250
                                
                            },
                        "email" :
                            {
                                "type" : "varchar",
                                "length" : 250
                            },
                        "resume" : 
                            {
                                "type" : "varchar",
                                "length" : 250
                            },
                        "apply" : 
                            {
                                "type" : "datetime"
                            },
                        "state"  :
                            {
                                "type" : "char",
                                "length" : 1,
                                "default" : 0
                            }
                    }
            }
        ',
    'mandatory' => 
        '
            {
                "modules" : 
                    [
                        {
                            "id" : "career",
                            "label" : "career",
                            "ordering" : "SELECT COUNT(`id`)+1 `id` FROM `modules`",      
                            "is_system" : 0
                        }
                    ],
                "permissions" : 
                    [
                        {
                            "module_id" : "career",
                            "action" : "create",
                            "label" : "create"
                        },
                        {
                            "module_id" : "career",
                            "action" : "edit",
                            "label" : "edit"
                        },
                        {
                            "module_id" : "career",
                            "action" : "delete",
                            "label" : "delete"
                        },
                        {
                            "module_id" : "career",
                            "action" : "view",
                            "label" : "view"
                        }
                    ],
                "module_menus" : 
                    [
                        {
                            "id" : "career1",
                            "module_id" : "career",
                            "parent_id" : 0,
                            "label" : "career_list",
                            "permalink" : "manage",
                            "ordering" : 1
                        }
                    ],
                "module_menu_permissions" : 
                    [
                        {
                            "module_menu_id" : "career1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'career\' AND `action` = \'create\'"
                        },
                        {
                            "module_menu_id" : "career1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'career\' AND `action` = \'edit\'"
                        },
                        {
                            "module_menu_id" : "career1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'career\' AND `action` = \'delete\'"
                        },
                        {
                            "module_menu_id" : "career1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'career\' AND `action` = \'view\'"
                        }
                    ],
                "module_menu_positions" : 
                    [
                        {
                            "module_menu_id" : "career1",
                            "position" : "left"
                        }
                    ]
            }
        '
);