<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Career List
 * @Module      Career
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/

?>

<script>
    $(document).ready(function(){
        $('form#frm_search').validate({
            errorPlacement : function(error, element) {},
            submitHandler: function(){
                window.location.href = bs_cms+'career/manage/list/search/'+($('input[name="search_key"]').val());    
            }  
        });    
    });
</script>

<div class="widget_cms">
    <div class="fl"><?php echo Form::button_new($site,'career/manage/form/create'); ?></div>
    <div class="fr">
        <form action="<?php echo $site->bs_cms;?>career/manage/list/search" method="POST" id="frm_search">        
            <input tabindex="0" type="text" name="search_key" class="required" value="<?php echo $site->search_value; ?>"/>
            <input type="submit"/>
        </form>
    </div>
    
    <!-- Filter by category, if there are two or more(categories) existing -->
    <?php if (!empty($categories[0])) { ?>
    <div class="fr">
        <select>
        <?php foreach ($categories as $category) { ?>
        <?php } ?>
        </select>
    </div>
    <?php } ?>
    <!-- End category filter -->
    
    <div class="clear"></div>
</div>

<table class="webarq_percent_table" id="role-listing">
    <thead>
        <tr>
            <th class="checkbox"></th>
            <th class="no"><?php echo __('no');?></th>
            <th class="title"><?php echo __('title');?></th>
            <th class="status"><?php echo __('date');?></th>
            <th class="status"><?php echo __('status');?></th>
            <th class="status">Total Applications</th>
            <th class="action"><?php echo __('action');?></th>
        </tr>
    </thead>
    
    <tbody>
        <?php
            if (!empty(Paging::$init->list_items[0])) {
                $index = Paging::$page->current_first_item;
                foreach (Paging::$init->list_items as $item) {
                    $modify_class = __make_class($index,$item->status);
                    
                    echo '<tr class="'.$modify_class.'">',"\n";
                        echo '<td class="checkbox">';       
                            echo Form::checkbox('','',false,array(
                                    'class' => 'tocheck',
                                    'idx' => $item->id
                                ));       
                        echo '</td>';
                        echo '<td class="center">'.$index.'</td>';
                        echo '<td>'.$site->tool->mixed_search($item->title).'</td>';
                        echo '<td class="center">'.$item->tanggal.'</td>';
                        echo '<td class="center">'.$item->status.'</td>';
                        echo '<td class="center">';
                            $t = Model::factory('careerapplicant')->getTotalApplicant($item->id);
                            if ($t > 0)
                                echo HTML::anchor(URL::base(true) . 'admin-cp/career/manage/applicant/'.$item->id,$t);
                            echo '</td>';
                      
                        echo '<td class="center">';  
                            $list_action  = $item->status == 'active' ? 'deactivate' : 'activate';
                            $update_value = $item->status == 'active' ? 'inactive' : 'active';
                              
                            echo Form::list_action($site,$list_action,array(   
                                    "class"  => "ajax",
                                    "href"   => $site->bs_cms.'system/ajax/update-status/careers/'.$update_value.'/'.$item->id,
                                    "i_have" => '{
                                            "session": "'.$site->cookie.'",
                                            "message": [{
                                                        "title":"'.__('confirmation').'",
                                                        "body":"'.__('action_confirmation',array('%action'=>$list_action,'%data'=>__('career').' '.$item->title)).'"
                                                    }]
                                        }',
                                ));
                                
                            echo '&nbsp; &nbsp;';                            
                            echo Form::list_action($site,'edit',array(   
                                    'title' => __('edit_user'),
                                    'href'  => $site->bs_cms.'career/manage/form/edit/'.$item->id
                                ));
                                
                            if ($site->user->profile->role_id <= 1 
                                    || !empty($site->user->profile->permission->news->delete_category))  {
                                        
                                echo '&nbsp; &nbsp;';                                              
                                echo Form::list_action($site,'delete',array(  
                                        'class'  => 'no-ajax',  
                                        'title'  => __('delete_career'),
                                        "href"   => $site->bs_cms.'career/manage/delete/'.$item->id,
                                        "i_have" => '{
                                            "session": "'.$site->cookie.'",
                                            "module" : "news",
                                            "message": [{
                                                        "title":"'.__('confirmation').'",
                                                        "body":"'.__('action_confirmation',array('%action'=>'delete','%data'=>__('career').' '.$item->title)).'"
                                                    }]
                                        }',
                                    ));
                            }
                            /** **/
                        echo '</td>';
                    echo '</tr>',"\n";
                    $index++;
                }
            } else {
                echo '<tr class="listing_no_data"><td colspan="8">'.__('no_data').'</td></tr>';
            }
        ?>
    </tbody>
    
    <tfoot>
        <tr>
            <td >
                <div id="corner"></div>
            </td>
            <td colspan="7">
                <?php 
                    echo Html::anchor('#',__('check_all'),array('class'=>'checkbox_trigger check', 'id'=>'active'));
                    echo '&nbsp;|&nbsp;';
                    echo Html::anchor('#',__('uncheck_all'),array('class'=>'checkbox_trigger uncheck', 'id'=>'inactive'));
                    echo '&nbsp;&nbsp;';
                    echo Form::select(
                            'run_trigger',
                            array(
                                ''  => __('with_selected'),
                                //'user/ajax/delete-user' => __('delete'),
                                'system/ajax/update-status/careers/active' => __('activate'),
                                'system/ajax/update-status/careers/inactive' => __('deactivate'),
                            ), 
                            null, 
                            array(
                                'class'    => 'general',
                                'id'       => 'run_trigger',
                                'href'     => $site->bs_cms,
                                'disabled' => 'disabled',
                                'i_have'   => '{"table":"histories","session":"'.$site->cookie.'","model":"history"}'
                            )
                        );
                ?>
            </td>
        </tr>
    </tfoot>
</table>

<div class="horizon_separator_two" style="margin-bottom: 0px;"></div>
<div class="right">
    <?php if (!empty(Paging::$init->list_items[0])) echo Paging::$page->render();?>
</div>
    