<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Cms Ajax User Class Controller
 * @Module      User
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_Contact_Ajax extends Controller_Space_Ajax {
    
    public function before() {
        parent::before();
    }
    
    
    public function action_delete_contact_category() {
        $result = false;  
        $delete = $this->db->delete('contact_categories')
                ->where('id = '.$this->param1)
                ->execute();
        
        if ($delete == 1) {
            $result = true;            
        }
        
        $this->ajax = json_encode($result);
    }
    
    public function action_delete_contact_location() {
        $result = false;  
        $delete = $this->db->delete('contact_locations')
                ->where('id = '.$this->param1)
                ->execute();
        
        if ($delete == 1) {
            $result = true;            
        }
        
        $this->ajax = json_encode($result);
    }
    
    
   /*
     * check captcha validation;
     */
    public function action_check_captcha(){
        $code = Arr::get($this->request->initial()->post(), 'code');
        $valid = Captcha::valid($code);
        
        $ret = array('result'=>$valid);

        $this->ajax = json_encode($ret);
    }
    
    /*
     * send email
     */
    public function action_send_email(){
        
        $name = Arr::get($this->request->initial()->post(), 'name');
        $phone = Arr::get($this->request->initial()->post(), 'phone');
        $email = Arr::get($this->request->initial()->post(), 'email');
        $subject = Arr::get($this->request->initial()->post(), 'subject');
        $message = Arr::get($this->request->initial()->post(), 'message');
        $code = Arr::get($this->request->initial()->post(), 'code');
        $receiver = Arr::get($this->request->initial()->post(), 'attention');
        
        $send_email = $this->send_message($name, $phone, $email, $subject, $message, $receiver, $code);
        
        if($send_email){
            $ret = array('result'=>'success');
        } else {
            $ret = array('result'=>'failed');
        }
        
        $this->ajax = json_encode($ret);
    }
    
    
    /*
     * send message throught email
     */
    private function send_message($name, $phone, $email, $subject, $message, $receiver, $code) {
        $msg = '';
        
        $msg = "<style>#email-body {font-family:Arial,FreeSans,Helvetica,sans-serif;font-size:12px;}</style>";
        $msg .= "<div id=\"email-body\">";
        $msg .= "<strong>Dear Admin</strong>,<br /><br />You have new message from:.<br/><br/>" .                
                "Name    : " . $name . "<br />" .
                "Phone   : " . $phone . "<br/>" .
                "Email   : " . $email. "<br/>" .               
                "<br />Message: <br />" .
                "$message" .
                "<br /><br /><br />";
        $msg .= "Best Regards,<br/>
                <strong>Golden Agin Contact Page</strong>";
        $msg .= "</div>";

        $send_email = Email::factory($subject, html_entity_decode($msg), 'text/html')
                        ->to($receiver)
                        // ->from('deni@localhost', ' goldenagin website ')
                        ->from($email, ' goldenagin website ')
                        ->send();
        
        if($send_email){
            return true;
        } else {
            return false;
        }
    }
    
}