<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * Author 	Daniel Simangunsong
 * @author      Deni Budhi Santana
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Module Package Installation
 * @Module      Contact
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

return array (
    'configuration' => 
        '
            {
                "contact_categories" :
                    {
                        "id" :
                            {
                                "type" : "int",                            
                                "primary" : true,
                                "increment" : true
                            },
                        "title" :
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "multilang" : false,
                                "form" :
                                    {
                                        "contact_category" :
                                            {
                                                "type" : "text",
                                                "label" : "Title",
                                                "name" : "title",
                                                "class" : "title required"
                                            }
                                    }
                            },
                        "description" : 
                            {
                                "type" : "text",
                                "multilang" : false,
                                "form" :
                                    {
                                        "contact_category" :
                                            {
                                                "label" : "description",
                                                "type" : "textarea",
                                                "class" : "intro"
                                            }
                                    }
                            },
                        "receiver" : 
                            {
                                "type" : "text",
                                "form" :
                                    {
                                        "contact_category" :
                                            {
                                                "label" : "Receiver",
                                                "type" : "textarea",
                                                 "rows" : "2",
                                                 "cols" : "50"
                                            }
                                    }
                            },
                        "status" : 
                            {
                                "type" : "enum",
                                "option" : "active,inactive",
                                "default" : "active",
                                "form" :
                                    {
                                        "contact_category" :
                                            {
                                                "label" : "Status",
                                                "order" : 2
                                            }
                                    }
                            }
                    },
                "contact_locations" :
                    {
                        "id" : 
                            {
                                "type" : "int",
                                "primary" : true,
                                "notnull" : true,
                                "increment" : true
                            },
                        "title" : 
                            {
                                "type" : "varchar",
                                "length" : 250,
                                "multilang" : false,
                                "form" :
                                    {
                                        "contact_location" :
                                            {
                                                "label" : "title",
                                                "class" : "title required"
                                            }
                                    }
                                
                            },
                        "address" : 
                            {
                                "type" : "text",
                                "form" :
                                    {
                                        "contact_location" :
                                            {
                                                "label" : "address",
                                                "type" : "textarea",
                                                "class" : "intro"
                                            }
                                    }
                            },
                        "phone" : 
                            {
                                "type" : "varchar",
                                "length" : 25,
                                "form" :
                                    {
                                        "contact_location" :
                                            {
                                                "label" : "phone",
                                                "class" : "phone required"
                                            }
                                    }
                                
                            },
                        "fax" : 
                            {
                                "type" : "varchar",
                                "length" : 25,
                                "form" :
                                    {
                                        "contact_location" :
                                            {
                                                "label" : "fax",
                                                "class" : "fax required"
                                            }
                                    }
                                
                            },
                        "email" : 
                            {
                                "type" : "varchar",
                                "length" : 150,
                                "form" :
                                    {
                                        "contact_location" :
                                            {
                                                "label" : "email",
                                                "class" : "email required"
                                            }
                                    }
                                
                            },
                        "status" : 
                            {
                                "type" : "enum",
                                "option" : "active,inactive",
                                "default" : "active",
                                "form" :
                                    {
                                        "contact_location" :
                                            {
                                                "label" : "status",
                                                "class" : "status"
                                            }
                                    }
                            }
                    }
            }
        ',
    'alter_configuration' => 
        '
            {
              "contact_locations" :
                    {
                        "google_coordinate" : 
                            {
                                "type" : "varchar",
                                "length" : 400,
                                "multilang" : false,
                                "form" :
                                    {
                                        "contact_location" :
                                            {
                                                "label" : "Maps Coordinate",
                                                "class" : "google_coordinate",
                                                "info"  : "Please use google maps coordinates"
                                            }
                                    }
                            }
                    }
            }
                
        ',
    'mandatory' => 
        '
            {
                "modules" : 
                    [
                        {
                            "id" : "contact",
                            "label" : "contact",
                            "ordering" : "SELECT COUNT(`id`)+1 `id` FROM `modules`",      
                            "is_system" : 0
                        }
                    ],
                "permissions" : 
                    [
                        {
                            "module_id" : "contact",
                            "action" : "create_category",
                            "label" : "create_contact_category"
                        },
                        {
                            "module_id" : "contact",
                            "action" : "edit_category",
                            "label" : "edit_contact_category"
                        },
                        {
                            "module_id" : "contact",
                            "action" : "delete_category",
                            "label" : "delete_contact_category"
                        },
                        {
                            "module_id" : "contact",
                            "action" : "view_category",
                            "label" : "view_contact_category"
                        },
                        {
                            "module_id" : "contact",
                            "action" : "create_location",
                            "label" : "create_contact_location"
                        },
                        {
                            "module_id" : "contact",
                            "action" : "edit_location",
                            "label" : "edit_contact_location"
                        },
                        {
                            "module_id" : "contact",
                            "action" : "delete_location",
                            "label" : "delete_contact_location"
                        },
                        {
                            "module_id" : "contact",
                            "action" : "view_location",
                            "label" : "view_contact_location"
                        }
                    ],
                "module_menus" : 
                    [
                        {
                            "id" : "contact_1",
                            "module_id" : "contact",
                            "parent_id" : 0,
                            "label" : "contact_category_list",
                            "permalink" : "category/manage",
                            "ordering" : 1
                        },
                        {
                            "id" : "contact_2",
                            "module_id" : "contact",
                            "parent_id" : 0,
                            "label" : "office_location_list",
                            "permalink" : "location/manage",
                            "ordering" : 2
                        }
                    ],
                "module_menu_permissions" : 
                    [
                        {
                            "module_menu_id" : "contact_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'contact\' AND `action` = \'create_category\'"
                        },
                        {
                            "module_menu_id" : "contact_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'contact\' AND `action` = \'edit_category\'"
                        },
                        {
                            "module_menu_id" : "contact_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'contact\' AND `action` = \'delete_category\'"
                        },
                        {
                            "module_menu_id" : "contact_1",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'contact\' AND `action` = \'view_category\'"
                        },
                        
                        {
                            "module_menu_id" : "contact_2",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'contact\' AND `action` = \'create_location\'"
                        },
                        {
                            "module_menu_id" : "contact_2",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'contact\' AND `action` = \'edit_location\'"
                        },
                        {
                            "module_menu_id" : "contact_2",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'contact\' AND `action` = \'delete_location\'"
                        },
                        {
                            "module_menu_id" : "contact_2",
                            "permission_id" : "SELECT `id` FROM `permissions` WHERE `module_id` = \'contact\' AND `action` = \'view_location\'"
                        }
                    ],
                "module_menu_positions" : 
                    [
                        {
                            "module_menu_id" : "contact_1",
                            "position" : "left"
                        },
                        {
                            "module_menu_id" : "contact_2",
                            "position" : "left"
                        }
                    ],
                "site_menus" :
                    [
                        {
                            "is_system" : 1,
                            "parent_id" : 0,
                            "menu_title" : "Contact",
                            "permalink" : "contact",
                            "ordering" : "SELECT COUNT(`id`)+1 `id` FROM `site_menus`"     
                        }
                    ],
                "site_menu_position_applications" :
                    [
                        {
                            "site_menu_id" : "SELECT `id` FROM `site_menus` WHERE `menu_title` = \'Contact\'",
                            "site_menu_position_id" : 1
                        }
                    ]
            }
        '
);