<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Cms Ajax System Class Controller
 * @Module      Base
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_System_Ajax extends Controller_Space_Ajax {
    
    public function before() {
        parent::before();        
        $this->model_history = Model::factory('history');
    }
    
    public function action_delete_history() {  
        $return = false;
        
        if ($this->post) {
            if (!empty($this->site->user->profile->is_admin)) {
                $return = $this->model_history->row_delete($this->param1);                        
            }
        }
        $this->ajax = json_encode($return);
    }
    
    public function action_update_status() {
        $return = false;
        if ($this->post) {
            if (!empty($this->site->user->profile->is_admin)) {
                if (!empty($this->param1) && !empty($this->param2) && !empty($this->param3)) {
                    $field = empty($this->param4) ? "id" : $this->param4;
                    $transaction = $this->db->update($this->param1)
                                        ->set('status',$this->param2)
                                        ->where("$field = $this->param3");                                                            
                    $transaction->execute();
                    $return = true;
                    
                    if ($field == 'id') {
                        $get = $this->request->query('history_table');
                        $id  = $this->request->query('history_id');
                        
                        $history_table = empty($get) ? $this->param1 : $get;
                        $history_id    = empty($id)  ? $this->param3 : $id;
                          
                        Model::factory('history')->insert_history(array(
                            'table' => $history_table,
                            'owner' => $this->site->user->profile->is_admin,
                            'source_id' => $history_id,
                            'type'  => 'update',
                        )); 
                    }
                }
            }
        }
        $this->ajax = json_encode($return);
    }
    
    public function action_in_record() {
        $return = 'false';
        $post = $this->request->post();
        
        if (!empty($post['table']) && !empty($post['field'])) {
            // Init translation first
            Translate::init();
            
            // Objectify post data
            $data = $this->site->tool->arr_to_object($post);
            
            if (Translate::$multi_lang === true && !empty($data->lang) && $data->lang != Translate::SYS_LANG) {
                // Condition for translation data
                $translate = $this->db->select('field','source_id','value')->from('translations')
                                      ->where('field = '.$data->field)
                                      ->and_where('table = '.$data->table)
                                      ->and_where('value = '.$data->value)
                                      ->execute()
                                      ->current();
                                                      
                $return = empty($translate->field) ? 'true' : 'false';
                
                // Condition for edit
                if ( $data->job === 'edit'
                     && isset($data->src_id)
                     && $data->src_id != '' 
                     && isset($translate->source_id) ) {
                    $return = ($translate->value == $data->value) && 
                              ($translate->source_id == $data->src_id) 
                                ? 'true' : $return;
                }
            } else {
                // Condition for default language or multilang not available
                $select = $this->db->select($data->field)->from($data->table)
                            ->where($data->field.' = '.$data->value)
                            ->execute()
                            ->current();
                               
                $return = $data->field;
                $return = empty($select->$return) ? 'true' : 'false';
            }
        }
        $this->ajax = $return;
    }
    
    public function action_filter() {
        if ($this->post) {
            $post = helper_tool::arr_to_object($this->post);
            if (!empty($post->action) && !empty($post->filter_name) && isset($post->key)) {
                $value = $post->action === 'set' ? true : false;
                $exist_filter = $this->site->session->get('filter',null);
                if ($value === true) 
                    $exist_filter[$post->filter_name][$post->key] = $value;
                else
                    unset($exist_filter[$post->filter_name][$post->key]);
                    
                $this->site->session->set('filter',$exist_filter);
                $exist_filter = $this->site->session->get('filter',null);
            }    
        }
        
    }
}
   

?>