<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Image Library Api Class
 * @Module      MediaLibrary
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Kohana_ImageLibrary {
    public $dest_dir;
    public $root_dir   = 'media/images/original';
    public $thumb_dir  = 'media/images/thumb';
    public $temp_dir   = 'media/temp';
    public $banner_dir = 'media/images/banner'; 
    
    public $config = array (
            'allowed'       => '*gif;*.jpg;*.jpeg;*.png',   // Allowed Images
            'thumb_width'   => 60,
            'thumb_height'  => 60,
            'file_size'     => '2MB',                       // Maximum allowed file size  
            'replace'       => false,
            
            'resize'        => true,
            'using_canvas'  => false,                       // On going in development         
            'resize_width'  => 0,
            'resize_height' => 0,
            'file_name'     => null,  
            'dest_dir'      => null,
        );
    
    // Remove media image
    public static function remove_media_image($id) {
        $get = Model::factory('libraryimage')->limit_libraryimage(true,$id);
        $get = empty($get[0]) ? null : $get[0];
        
        if (!empty($get) && $get->total_used == 0) {
            $lib = ImageLibrary::factory();
            // Delete row from table
            $delete_row = Model::factory('library')->delete_library($id);
            
            if (!empty($delete_row)) {
                // Delete original image
                if (file_exists($lib->root_dir.'/'.$get->file_name))
                    unlink($lib->root_dir.'/'.$get->file_name);
                // Delete thumbnail image
                if (file_exists($lib->thumb_dir.'/'.$get->file_name))
                    unlink($lib->thumb_dir.'/'.$get->file_name);   
                // Looping as much as media positions
                $media_position = MediaLibrary::media_positions();
                if (!empty($media_position)) {
                    foreach ($media_position as $item) {
                        if (file_exists($lib->banner_dir.'/'.$item->label.'/'.$get->file_name))
                            unlink($lib->banner_dir.'/'.$item->label.'/'.$get->file_name);
                    }
                }
                return true;    
            } else {
                return false;
            }                        
        }
            
        return false;
    }
    
    public function resize_as_position($media_image,$owner=1) {
        $dot = strrpos($media_image,'.');
        if ($dot === false) {
            $get_media = Model::factory('base')
                                ->select('file_name')
                                ->from('media_libraries')
                                ->where('id = '.$media_image)
                                ->and_where('type = image')
                                ->execute()
                                ->current();
            $media_image = !isset($get_media->file_name) ? $media_image : $get_media->file_name;     
        }
        
        $dot = strrpos($media_image,'.');
        
        if (!empty($dot)) {
            $media_position = MediaLibrary::media_positions();        
            if (!empty($media_position)) {
                foreach ($media_position as $item) {  
                    $this->resize        = true;
                    $this->resize_width  = $item->width;
                    $this->resize_height = $item->height;
                    $this->file_name     = $media_image;
                    $this->owner         = $owner;
                    $this->replace       = true;
                    $this->temp_dir      = $this->root_dir;
                    $folder_label       = MediaLibrary::folder_naming($item->label); 
                    $this->dest_dir     = $this->banner_dir.'/'.$folder_label;
                    $this->zero_uploader(false);
                }
            }
        }
    }
    
    // Factory image library
    public static function factory($config=null) {
        return new ImageLibrary($config);    
    }
    
    public function __construct($config) {
        Package::$init->populate($this,$config);
        MediaLibrary::check_dir(array($this->root_dir,$this->thumb_dir,$this->temp_dir,$this->banner_dir));
        
        // Looping as much as media positions
        $media_position = MediaLibrary::media_positions();
        if (!empty($media_position)) {
            foreach ($media_position as $item) {
                // Check destination folder and create it if not exists
                $folder_name = MediaLibrary::folder_naming($item->label);
                MediaLibrary::check_dir($this->banner_dir.'/'.$folder_name);
            }
        }
    }
    
    // Upload and resize based on dimention given
    public function zero_uploader($remove_original_file = false) {
        // Define destination folder
        $this->dest_dir = empty($this->dest_dir) ? $this->root_dir : $this->dest_dir;
        
        // Check destination dir and create if not exist  
        Medialibrary::check_dir($this->dest_dir);
        
        // Open image
        $open_image  = Image::factory($this->temp_dir.'/'.$this->file_name);               
        $origin_width  = $open_image->width;
        $origin_height = $open_image->height;
       
        // Resize if requested
        if ($this->resize === true && (!empty($this->resize_width) || !empty($this->resize_height))) {
            if ($this->using_canvas === false) { 
                $crop_width    = empty($this->resize_width) ? 0 : $this->resize_width;
                $crop_height   = empty($this->resize_height) ? 0 : $this->resize_height; 
                $resize_width  = $crop_width;
                $resize_height = $crop_height;                
                
                // Define master ratio
                $ratio  = $origin_width > $origin_height  
                                ? Image::HEIGHT
                                : ($origin_width < $origin_height ? Image::WIDTH : Image::AUTO);
                
                // Define resize dimention
                $scale_width  = $origin_width/$crop_width;
                $scale_height = $origin_height/$crop_height;        
                
                if ($scale_width != $scale_height) {
                    $resize_width = $scale_width > $scale_height
                            ? null
                            : $crop_width;
                    $resize_height = $scale_width > $scale_height
                            ? $crop_height
                            : null;
                    $ratio = $scale_width > $scale_height ? Image::WIDTH : Image::HEIGHT;
                }
                
                // Resize image
                $open_image->resize($resize_width,$resize_height,$ratio);
                
                // Crop image from the center
                $open_image->crop($crop_width,$crop_height);
            } else {
                return $this->create_using_canvas();
            }
        }   
        
        // Process name
        $check_needle = strrchr($this->file_name,'_ii_');
        $save_name = $check_needle !== false 
                    ? helper_tool::file_name_beautification(substr(strrchr($this->file_name,'_ii_'),1))
                    : helper_tool::file_name_beautification($this->file_name);
                    
        $save_ext  = helper_tool::file_type($save_name);
        $save_name = helper_tool::file_name($save_name);
        
        if ($this->replace === false) {
            $save_idx = '';
            $complemen_name = '';
            while ( file_exists($save_true = ($this->dest_dir.'/'.$save_name.$complemen_name.'.'.$save_ext)) ){
                $save_idx++;
                $complemen_name = '('.$save_idx.')';
            }                
            $save_name = empty($save_idx) 
                            ? $save_name 
                            : $save_name.'('.$save_idx.')';
        }
               
        $save_name = $save_name.'.'.$save_ext;
        
        // Finally save it to destination
        $open_image->save($this->dest_dir.'/'.$save_name);
        
        // Record in database and remove temporary file
        if ($remove_original_file === true) {
            Model::factory('library')->create($this->owner,$save_name);
            unlink($this->temp_dir.'/'.$this->file_name);
        }
    }
        
    public function create_using_canvas() {
        $save_ext  = helper_tool::file_type($this->file_name);
        $save_name = helper_tool::file_name($this->file_name);
        
        if ( !empty($this->resize_width) 
             && !empty($this->resize_height) ) {
            
            // Resizing original image first 
            $dest_file   = $this->dest_dir.'/'.$save_name.'.'.$save_ext;
            $open_image  = Image::factory($this->temp_dir.'/'.$this->file_name);
            $open_image->resize($this->resize_width,$this->resize_height);
            $open_image->save($dest_file);
            $open_image  = Image::factory($dest_file);
            
            // Create our canvas
            $canvas =  imagecreatetruecolor($this->resize_width, $this->resize_height);
            
            // Alocate collor
            if (empty($this->rgb_code)) {
                $black = imagecolorallocate($canvas, 255, 255, 255);
                $background = imagecolortransparent($canvas, $black);
            } else {
                list($red,$green,$blue) = $this->rgb_code;
                $background = imagecolorallocate($canvas, $red, $green, $blue);
            } 

            // Fill canvas background
            imagefill($canvas, 0, 0, $background); 


            // Open temporary image
            if ($save_ext === 'jpg' || $save_ext === 'jpeg') {
                $temp = imagecreatefromjpeg($dest_file);
            } elseif ($save_ext === 'gif') {
                $temp = imagecreatefromgif($dest_file);
            } elseif ($save_ext === 'png') {
                $temp = imagecreatefrompng($dest_file);
            }
            
            // Count destination x and y point
            $dest_x = ($this->resize_width-$open_image->width)/2;
            $dest_y = ($this->resize_height-$open_image->height)/2;
            
            // Merge image to canvas
            imagecopymerge($canvas, $temp, $dest_x, $dest_y, 0, 0, $open_image->width, $open_image->height,100);
            
            // Save the image
            imagejpeg($canvas,$this->dest_dir.'/'.$this->file_name);
            // Free up memories
            imagedestroy($canvas);
        }        
    }
    
}

?>