<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    News Api Class
 * @Module      News
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class News extends Kohana_News {
    
    public static function input_order_category(array $data = null) {
        $data['table'] = 'news_categories';
        return General::factory($data)->input_order();
    }
    
    public static function select_category(array $data = null) {
        $categories = Model::factory('newscategory')
                        ->limit_newscategory(false)
                        ->order_by('news_categories.ordering')
                        ->execute();
        
        $options = array(''=>__('select_one'));
        if (!empty($categories[0])) 
            foreach ($categories as $category)
                $options[$category->id] = $category->label;
        
        return Form::select($data['name'],$options,$data['value'],$data['attribute']);
    }
}

?>