<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Page Api Classes
 * @Module      Page
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors
**/ 

class Page extends Kohana_Page {
        
    public function select_parent_page(array $configs = array()) {
        $attr['name']  = empty($configs['name']) ? 'parent' : $configs['name'];
        $attr['value'] = empty($configs['value']) ? 0 : $configs['value'];
        $attr['class'] = 
            empty($configs['attribute']['class']) 
                ? 'traversal' 
                : $configs['attribute']['class'].' traversal';
        
        $attr = array_merge($configs['attribute'],$attr);
        
        $and_condition[0] = array ('and_where','is_system = 0');
        
        if (!empty($attr['job']))
            $and_condition[1] = array('and_where','id != '.$attr['item_id']);
        
        return Traversal::select(array(
                'table'             => 'site_menus',
                'field_opt_value'   => 'id',
                'field_opt_text'    => 'menu_title',
                'extend_conditions' => $and_condition,
                'attributes'        => $attr
            ));
    }
    
    public function page_order(array $data = array()) {
        $total_item = $this->model_page->pre_order($data['table'],false);
        $parent_id  = empty($data['attribute']['parent_id']) 
                        ? 0 
                        : $data['attribute']['parent_id'];
        
        $total_item->where($data['table'].'.parent_id = '.$parent_id);
        $total_item = $total_item->execute()->current();
        $data['total_item'] = $total_item->total;        
        
        return General::factory($data)->input_order();
    }
}
?>