<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Extended Kohana Class Form
 * @Module      Plug
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
 * Versioning Extended Kohana Class Form. 
**/ 

class Form extends Kohana_Form {  
    /**
     * @var array default Form Configuration
     */         
    public $config = array (
            'column'     => 2,
            'themes'     => 'general',
            'omethod'    => 'sequence',       // Ordering Method swap or sequence
            'action'     => '#',
            'attributes' => array(),
            'name'       => null,
            'fields'     => array(),  
            'pointer'    => 0,
            'form_data'  => null, 
            'form_translation' => null,
            
            
            'multilang'  => null,          // Only working if used config to buid form          
            'banner'     => array(),        // Enabling banner in form, format array('table_name','source_id')                                                                 
        ); 
    
    /**
     * @var object form
     */
    public $ofs;
    
    /**
     * @var integer cheat index key
     */
    protected $cheat_key = null;
    
    /**
     * @var array cheat value
     */
    protected $cheat_value = null;
        
    public static function init(array $config = array()) {
        return new Form($config);            
    }   
    
    public function __construct(array $config = array()) {
        $config = array_merge($this->config,$config);
        $this->ofs = new stdClass();
        foreach ($config as $k => $vivi)
            $this->ofs->$k = $vivi;
    }
    
    public function action($action='#') {
        $this->ofs->action = $action;
        return $this;
    }
    
    public function id($id = null) {
        return $this->attribute('id',$id);
    }
    
    /**
     * @var mixed string key name or array key, value
     * @var string value
     */
    public function attribute($k = null,$vivi = null) {
        if (isset($k)) {
            if (is_array($k)) {                
                foreach ($k as $nk => $nvivi) {
                    if ($this->ofs->pointer == 0) {
                        $this->ofs->attributes[$nk] = empty($this->ofs->attributes[$nk]) 
                                ? $nvivi
                                : $this->ofs->attributes[$nk].' '.$nvivi;
                    } else {
                        $this->ofs->fields[$this->ofs->pointer]['attributes'][$nk] =
                            empty($this->ofs->fields[$this->ofs->pointer]['attributes'][$nk])
                                ? $nvivi
                                : $this->ofs->fields[$this->ofs->pointer]['attributes'][$nk].' '.$nvivi;
                    }
                }
            } elseif (isset($vivi)) {
                if ($this->ofs->pointer == 0) { 
                    $this->ofs->attributes[$k] = empty($this->ofs->attributes[$k]) 
                            ? $vivi
                            : $this->ofs->attributes[$k].' '.$vivi;
                } else {
                    if (is_object($vivi)) {
                        $array_vivi = array();
                        foreach ($vivi as $k_v => $v_v) {
                            $array_vivi[$k_v] = $v_v; 
                        }
                        
                        $this->ofs->fields[$this->ofs->pointer]['attributes'][$k] = 
                            empty($this->ofs->fields[$this->ofs->pointer]['attributes'][$k])
                                ? $array_vivi
                                : $this->ofs->fields[$this->ofs->pointer]['attributes'][$k] + $array_vivi;
                    } else {
                        $this->ofs->fields[$this->ofs->pointer]['attributes'][$k] =
                            empty($this->ofs->fields[$this->ofs->pointer]['attributes'][$k])
                                ? $vivi
                                : $this->ofs->fields[$this->ofs->pointer]['attributes'][$k].' '.$vivi;
                    }
                }
            }
        }     
        return $this;
    }
    
    public function add($type = 'text') {
        $this->ofs->pointer = $this->make_pointer($type);
        $this->ofs->fields[$this->ofs->pointer]['type'] = $type;
        $this->set_default($type);
        return $this->set_name();
    }
    
    protected function set_default($type='null') {
        $this->ofs->fields[$this->ofs->pointer]['value'] = null;
        $this->ofs->fields[$this->ofs->pointer]['attributes'] = array();
        if ($type == 'select') {
            $this->ofs->fields[$this->ofs->pointer]['options'] = array(); 
            $this->ofs->fields[$this->ofs->pointer]['selected'] = false;       
        }
    }
    
    public function set_name($name = null) {
        $name = empty($name) ? 'input_'.$this->ofs->pointer : $name;
        $this->ofs->fields[$this->ofs->pointer]['name'] = $name;
        return $this;       
    }
    
    public function set_value($value = null) {
        $this->ofs->fields[$this->ofs->pointer]['value'] = $value;
        return $this;       
    }
    
    public function set_label($label = null) {
        $label = !isset($label) ? 'label_'.$this->ofs->pointer : __($label);
        $this->ofs->fields[$this->ofs->pointer]['label'] = $label;
        return $this;       
    }
    
    /**
     * @var mixed object or array data
     */
    public function set_data($data) {
        $this->ofs->form_data = is_object($data)
                    ? $data
                    : (is_array($data) ? helper_tool::arr_to_object($data) : $this->ofs->form_data);
        return $this;
    }
    
    /**
     * @var mixed object or array translation data
     */
    public function set_translation($data) {
        $this->ofs->form_translation = is_object($data)
                    ? $data
                    : (is_array($data) ? helper_tool::arr_to_object($data) : $this->ofs->form_translation);
        return $this;
    }
    
    /**
     * @var mixed string value option or array value and label option
     * @var string label option
     */
    public function set_option($v_opt = '',$l_opt = '') {
        if (is_array($v_opt)) {
            foreach ($v_opt as $nv_opt => $l_opt)
                $this->ofs->fields[$this->ofs->pointer]['options'][$nv_opt] = __($l_opt);    
        } else {
            $this->ofs->fields[$this->ofs->pointer]['options'][$v_opt] = __($l_opt);
        }
        return $this;
    }
    
    /**
     * @var int index pointer fields
     * @var string order method, swap or sequence
     */
    public function order($pointer = null,$omethod=null) {
        $pointer = (int) $pointer;
        #$pointer = $pointer > count($this->ofs->fields) ? count($this->ofs->fields) : $pointer;        
        if ($pointer >= 1 && $pointer != $this->ofs->pointer) {
            $function  = 'make_';
            $function .= empty($omethod) ? $this->ofs->omethod : $omethod;            
            return $this->$function($pointer);              
        }
        return $this;
    }
    
    protected function make_pointer($type) {
        $total_fields = count($this->ofs->fields);
        if ($total_fields == 0) {
            return $total_fields+1;
        } else {
            ksort($this->ofs->fields);    
            $keys_array = array_keys($this->ofs->fields);
            $lastkey = array_pop($keys_array)+1;
            
            for ($i = 1; $i <= $lastkey; $i++) {
                if (empty( $this->ofs->fields[$i])) {
                    return $i;
                }                            
            }
        }
    }
    
    protected function make_swap($pointer) {
        if (empty($this->ofs->fields[$pointer]))
            $this->ofs->fields[$pointer] = $this->ofs->fields[$this->ofs->pointer];
        else {
            $temp = $this->ofs->fields[$pointer];
            $this->ofs->fields[$pointer] = $this->ofs->fields[$this->ofs->pointer];
            $this->ofs->fields[$this->ofs->pointer] = $temp;
        }
        $this->ofs->pointer = $pointer;
                     
        return $this;
    }
    
    protected function make_sequence($pointer) {
        if (empty($this->ofs->fields[$pointer])) {
            $this->ofs->fields[$pointer] = $this->ofs->fields[$this->ofs->pointer];
            unset($this->ofs->fields[$this->ofs->pointer]);
        } else {
            $actual_pointer = $this->ofs->pointer;            
            $to_move = $this->ofs->fields[$actual_pointer];
            
            if ($pointer < $actual_pointer) {
                for ($i_pointer = $actual_pointer;$i_pointer >= $pointer;$i_pointer--)
                    $this->ofs->fields[$i_pointer] = $i_pointer != $pointer && !empty($this->ofs->fields[$i_pointer-1])
                          ? $this->ofs->fields[$i_pointer-1]
                          : $to_move;
            } else {
                for ($i_pointer = $actual_pointer;$i_pointer <= $pointer;$i_pointer++) {
                    if (!empty($this->ofs->fields[$i_pointer+1]))
                        $this->ofs->fields[$i_pointer] = $i_pointer != $pointer
                              ? $this->ofs->fields[$i_pointer+1]
                              : $to_move;
                }
            }
        }
              
        $this->ofs->pointer = $pointer;
        return $this;
        
    }
    
    protected function package_form_builder($package) {        
        $alter_package = is_array($package) ? $package : array($package);
        
        foreach ($alter_package as $package) {
            list($package_name,$package_form) = explode('::',$package,2);
            
            // Config name using to perform form builder
            $array_config  = array('configuration','alter_configuration');
            foreach ($array_config as $item_config) {
                if ( !empty(Kohana::$config->load('package/'.$package_name)->$item_config)) {
                    $package_config = Kohana::$config->load('package/'.$package_name)->$item_config;
                    $json_data = is_array($package_config) 
                        ? json_decode(json_encode($package_config)) 
                        : json_decode($package_config);
                    $form = false;
                    foreach ($json_data as $tname => $tconf) {                 
                        foreach ($tconf as $fname => $fconf) {
                            if (isset($fconf->form->$package_form))  {  
                                $this->ofs->operation_table[$tname] = $tname;
                                                                                                                                                
                                $form = true;
                                $low_level = $this->low_level_input($fconf,$package_form,array(
                                        'type','name','label','order'
                                    )); 
                                $low_level['name'] = empty($low_level['name']) ? $fname : $low_level['name'];                                                  
                                $this->add($low_level['type']);
                                $this->ofs->fields[$this->ofs->pointer]['field'] = $fname;
                                $this->set_name($low_level['name']);
                                $this->set_label($low_level['label']);
                                $this->order($low_level['order']);
                                $this->low_level_attributes($fconf,$package_form);
                                
                                if ($low_level['type'] == 'select')
                                    $this->low_level_option($fconf,$package_form);
                                    
                            }
                            
                            if (!empty($fconf->multilang)) {
                                $this->attribute('multilang',true); 
                                                           
                                //$this->attribute('record_table',$tname);
                                //$this->attribute('record_field',$fname);
                            }
                        }
                    }
                    if (!$form && $item_config != 'alter_configuration') 
                        echo (__('no_config_file_found'));        
                }else{
                    if ($item_config != 'alter_configuration')
                        echo (__('no_config_file_found')); 
                }
            }
        }
    } 
    
    protected function low_level_option($config,$package_form) {
        $option = !empty($config->form->$package_form->option)
            ? $fconf->form->$package_form->option
            : (
                !empty($config->form->default->option)
                    ? $config->form->default->option 
                    : (!empty($config->option)? $config->option : null)
              );
        
        #$this->set_option('',__('select_one'));
        foreach (explode(',',$option) as $item) {
            $this->set_option($item,$item);
        }
    }
    /**
     * @var object field config
     * @var string form name
     * @mixed string 
     */ 
    protected function low_level_input($config,$package_form,array $_types = array()) {
        
        foreach ($_types as $type) {
            $low_level[$type] = 
                !empty($config->form->$package_form->$type)
                    ? $config->form->$package_form->$type
                    : (
                        !empty($config->form->default->$type) 
                            ? $config->form->default->$type
                            : (
                                $type == 'type' 
                                ? $this->db_form_field($config->type) 
                                : (empty($config->$type) ? '' : $config->$type))
                      );    
        }
        return $low_level;
    }  
    
    protected function low_level_attributes($config,$package_form) {
        $attr = array();
        if (!empty($config->form->default)) {
            foreach ($config->form->default as $a=>$b){
                $a != 'label' && $a != 'name' && $a != 'order' && $a != 'option'
                    ? $this->attribute($a,$b)
                    : '';
            }
        }
        if (!empty($config->form->$package_form)) {
            foreach ($config->form->$package_form as $a=>$b){
                $a != 'label' && $a != 'name' && $a != 'order' && $a != 'option'
                    ? $this->attribute($a,$b)
                    : '';
            }
        }
    }  
    
    protected function db_form_field($type) {
        $conf = Kohana::$config->load('db-form-field')->db_sys_input;        
        return empty($conf[$type]) ? 'text' : $conf[$type];        
    }
            
    public function build($package=null,array $external_configuration = array()) {
        if (!empty($package)) {
            $this->package_form_builder($package);                            
        }   
            
        ksort($this->ofs->fields); 
        
        if (!empty($this->cheat_value)){
            foreach ($this->cheat_value as $key => $arr_value)
                foreach ($arr_value as $n_c => $v_c)
                    $this->ofs->fields[$key]['attributes'][$n_c] = 
                            !empty($this->ofs->fields[$key]['attributes'][$n_c])
                                ? $this->ofs->fields[$key]['attributes'][$n_c].' '.$v_c
                                : $v_c;
        }
        
        // Translation data
        if (Translate::$multi_lang === true && $this->ofs->multilang === true) {
            foreach ($this->ofs->fields as $key => $field) {
                if (!empty($this->ofs->operation_table)) {
                    foreach ($this->ofs->operation_table as $table) {
                        $after_table_field = Historymap::trim_table_name($table).'_id';
                        if ($field['name'] == $after_table_field) {
                            $arr_table[]  = $table;
                            $arr_source[] = $field['value'];
                        }                                        
                    }
                }
            }    
            
            if (empty($this->ofs->form_translation) && !empty($arr_table) && !empty($arr_source)) {
                $this->ofs->form_translation = Translate::table($arr_table)->id($arr_source)->compile(false);
            }
        }
        
        return Form::render('html/plug/form-template')
            ->set('form',$this->ofs)
            ->set('external_configuration',$external_configuration);
    }  
    
    public static function render($view,array $configs = array()) {
        return View::factory($view,$configs)
            ->set('site',Config::$site_config);
    }
    
    /**
     * @param object site configuration
     * @param string button type eg. add, edit, ...
     * @param array  button attributes 
     */
    public static function list_action($site=null,$type='add',array $attributes = array(),$image=false) {
        $attributes['class'] = empty($attributes['class']) ? 'list_action '.$type : 'list_action '.$type.' '.$attributes['class'];
        $button  = '';
        if ($image === false){
            $button .= '<a ';
            $button .= HTML::attributes($attributes);
            $button .= '>';
        }
        $button .= '<img ';
        if ($image === true) {
            $button .= HTML::attributes($attributes);
        }
        $button .= ' src="'.$site->themes_img.'cms/icon/button_'.$type.'.png" style="width:20px;"/>';
        if ($image === false){
            $button .= '</a>';
        }
        
        return $button;
    }
    
    public static function button_new($site,$link="#") {
        return HTML::anchor($site->bs_cms.$link,
                HTML::image(
                    $site->themes_img.'cms/button/add_button.png',
                    array('width',80)
                )
            );
    }
    
    /**
     * Cheater 
     */
    public function before_form($key_index) {
        $this->cheat_key = $key_index;
        return $this;
    }  
    
    public function inject($key,$value) {
        if (is_array($key))
            $this->cheat_value[$this->cheat_key] = $key;
        else
            $this->cheat_value[$this->cheat_key][$key] = 
                empty($this->cheat_value[$this->cheat_key][$key]) 
                    ? $value
                    : $this->cheat_value[$this->cheat_key][$key].' '.$value;   
        return $this;
    }     
}