<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 	Daniel Simangunsong
 * @author      Deni Budhi Santana
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Cms Class Controller
 * @Module      Product
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_Product_Item extends Controller_Space_Cms {
    protected $site;
    protected $model;
    
    public function before() {
        parent::before();
        $this->site->menu->active = 'product_item_list';
        $this->authorized(array(
                //nama_module => action (separate by commas)
                'product' => 'create_product_item,edit_product_item,delete_product_item,view_product_item',
            )); // Check permission           
        
        $this->scripts(array(
                $this->site->system_js.'plugin/jquery.validate.additional',
                $this->site->system_js.'plugin/jquery.validate',
                $this->site->system_js.'party3d/ckeditor/adapters/jquery',
                $this->site->system_js.'party3d/ckeditor/ckeditor',
            ));
    }  
    
    protected function condition() {
        // Condition Search
        $param_condition = array('search');
        if (in_array($this->param1,$param_condition)){
            $function = 'condition_'.$this->param1;
            $this->$function();    
        }
    } 
    
    protected function condition_search() {
        $this->site->search_value = $value_condition = $this->param2;
        
        Paging::$init->list_items->and_where_open()
            ->where('product_items.id = '.$value_condition)
            ->or_where('product_items.title like %'.$value_condition.'%')
            ->or_where('product_items.description like %'.$value_condition.'%')
            ->or_where('product_items.status like %'.$value_condition.'%')
            ->and_where_close();
    }
    
    public function action_index() {
        $this->action_list();
    }
    
    public function action_manage() {
        $this->action_list();
    }
        
    public function action_list() {    
        if ($this->authorisation === true) {
            Paging::factory(array(
                    'model' => 'productitem',
                    'items_per_page' => 10
                ));
            $this->condition();
            Paging::$init->compile();
            
            $this->meta('title',__('manage_product_item'))
                 ->set('title',__('manage_product_item'))
                 ->set('content',$this->html('product-item-list'))
                 ->scripts($this->site->system_js.'plugin/jquery.validate')
                 ->render();
        }
    }
    
    public function action_form() {
        $this->styles(array(
                 $this->site->system_css.'js/ui/base/jquery.ui.all' => 'screen,projection'
            ));
        $this->scripts(array(
                //$this->site->system_js.'party3d/ui/jquery.ui.datetimepicker.js',
                $this->site->system_js.'library/ui/jquery.ui.datetimepicker.js',
                $this->site->system_js.'library/ui/jquery-ui-1.8.16.custom.min.js',
            ));
        // Extend permission
        $class_action = $this->param1;
        $this->authorized(array('product' => $class_action.'_product_item'));
        
        if ($this->authorisation === true) {
            if ($this->param1 == 'create' || $this->param1 == 'edit') {
                $title = __($this->param1,array('%item'=>__('product_item',array('%s'=>''))));
                
                /** Get data **/
                $data  = $this->param1 == 'create' 
                    ? null 
                    : Model::factory('productitem')->get_by('field','id',$this->param2)->current();
                
                $data_product_category = $this->param1 == 'create' 
                    ? null 
                    : Model::factory('productcategory')->get_by('field','id',$data->product_category_id)->current(); 
                
                
                /**
                 *if data of the parent is missing then go back to items listing 
                 * and delete this product item because it has no parent.
                 */
                if($class_action == 'edit'){
                    if($data_product_category == false){
                        $this->request->redirect(url::base(true).'admin-cp/product/item/manage');
                    }
                }                
                           
                /** Form configuration **/
                /** Form action **/
                $form_action  = $this->param1 == 'create' ? 'save' : 'update';                
                $form_action .= !empty($data->id) ? '/'.$data->id : '';
                
                /** Form Build **/
                $form = $this->html('product-item-form')
                            ->set('transaction',$this->param1)
                            ->set('data',$data)
                            ->set('form_action',$form_action);
                            
                /** Rendering **/        
                $this->meta('title',$title)
                     ->set('title',$title)
                     ->set('content',$form)
                     ->render();
            }    
        }
        
    }
    
    public function action_save() {   
        $this->authorized(array(
                //nama_module => action (separate by commas)
                'product' => 'create_product_item'
            )); // Check permission  
        
        if ($this->authorisation === true) {
            if($this->post){
                $result = false;
                
                /** Upload Image **/
                $image_type = $_FILES['image_path']['type'];
                
                if((strcmp($image_type, 'image/jpeg')== 0
                    OR
                    strcmp($image_type, 'image/png')== 0
                    OR
                    strcmp($image_type, 'image/gif') == 0   
                    ))
                {
                    $image_name = $this->upload_image('image_path');
                    $image_path = 'media/images/product/items/' . $image_name;
                }
                else
                {
                    $image_path = null;
                }
                
                if($image_path == null)
                {
                    $this->post['image_path'] = false;
                }
                else
                {
                    $this->post['image_path'] = $image_path;
                }     
                         
                // Upload Cover
                $im = Product::uploadCover('cover',940,238);
                
                if (isset($im))
                {
                    if (is_array($im))
                    {
                        Session::instance()->set('message',$im['message']);
                        $this->request->redirect('admin-cp/product/item/form/edit/'.$this->param1);
                        return;
                    }
                    else
                    {
                        $this->post['cover'] = $im;
                    }
                } else {
                    $this->post['cover'] = $this->post['cover_hidden'];
                }
                
                $transaction =  Transaction::insert(array(
                       'package'        => 'product',
                       'form'           => 'product_item',
                       'owner'          => $this->site->user->profile->id,
                    'post'          => $this->post
                  ));
                $transaction->check(false);            
                $transaction->execute($result);   
                                           
                if ($result === false){
                    Session::instance()->set('message',__('transaction_failed',array('%item'=>strtolower(__('product')))));
                    $this->request->redirect('admin-cp/product/item/form/create/error');
                }
            }
        }        
        $this->request->redirect('admin-cp/product/item/manage'); 
    }
    
    public function action_update() {        
        $this->authorized(array(
            'product' => 'edit_product_item'
        ));
         
        if ($this->authorisation === true) {
            if($this->post){
                
                /** Upload Image **/
                $image_type = $_FILES['image_path']['type'];
                
                if((strcmp($image_type, 'image/jpeg')== 0
                    OR
                    strcmp($image_type, 'image/png')== 0
                    OR
                    strcmp($image_type, 'image/gif') == 0   
                    ))
                {
                    $image_name = $this->upload_image('image_path');
                    $image_path = 'media/images/product/items/' . $image_name;
                }
                else
                {
                    $image_path = null;
                }
                
                if($image_path == null)
                {
                    $this->post['image_path'] = false;
                }
                else
                {
                    $this->post['image_path'] = $image_path;
                }     
                         
                // Upload Cover
                $im = Product::uploadCover('cover',940,238);
                
                if (isset($im))
                {
                    if (is_array($im))
                    {
                        Session::instance()->set('message',$im['message']);
                        $this->request->redirect('admin-cp/product/item/form/edit/'.$this->param1);
                        return;
                    }
                    else
                    {
                        $this->post['cover'] = $im;
                    }
                } else {
                    $this->post['cover'] = $this->post['cover_hidden'];
                }
                
                $transaction =  Transaction::update(array(
                       'package'        => 'product',
                       'form'           => 'product_item',
                       'owner'          => $this->site->user->profile->id,
                        'post'          => $this->post
                  ));
                
                $transaction->check(false);
                $transaction->execute($result);  
                
                if ($result === true) {
                    if ($this->post['cover'] !== $this->post['cover_hidden'] && is_file($this->post['cover_hidden']))
                    {
                        unlink($this->post['cover_hidden']);
                    }
                    Session::instance()->set('message',__('success_update'));
                }else{
                    Session::instance()->set('message',__('no_transaction',array('%transaction'=>'update')));
                }
            }
        }    
        
        $this->request->redirect('admin-cp/product/item/form/edit/'.$this->param1);
    }
    
    /*** upload image image file ***/
    private function upload_image($param)
    {   
        $data = $_FILES[$param]['name'];
        $pattern = "/ /";
        $replacement = "_";
        $data_ready = strtolower(preg_replace($pattern, $replacement, $data));
        $file_name = uniqid().'_'.$data_ready;
                  
        $upload_file = Upload::save($_FILES[$param],$file_name,'media/images/product/items');
        
        // if upload success //
        if($upload_file)
        {
            $image_file_name = $file_name;
        }
        else
        {
            $image_file_name = '';
        }
        
        return $image_file_name; 
    }
}