<?php

defined('SYSPATH') or die('No direct script access.');

/**
 * @Author 		Daniel Simangunsong
 * @Codename	Nouspeed.Com
 * @copyright 	2012
 * @Package	    Welcome Controller
 * @Module      ~
 * @Themes      ~
 * 
 * Calm seas, never make skillfull sailors	
 * */
class Controller_Site_Product_Product extends Controller_Space_Site {

    protected $site;
    protected $permalink;
    
    public function before() {  
       parent::before();     
       $this->site->menu->id = Model::factory('menu')->menu_id('product');       
       $this->site->menu->active = 'product';
       $this->permalink = $this->request->param('permalink');
       
       /*** Banner ***/
       $this->banner = Widget::$instance->load('page-banner')
                                ->set('table','site_menus')
                                ->set('source_id',$this->site->menu->id)
                                ->set('position', 'Page Banner');
        
       
       $this->site->menu->title = Model::factory('order')->get_parent_menu_title('product');
       
       $this->category_active = $this->param1;  
       $this->item_active = $this->param2; 
                            
       /*** Left Content ***/
       $this->left_content = View::factory('general/left-content')
                ->set('product_list_widget', true)
                ->set('email_widget', true);
       
       /*** category selected ***/
       if(strcmp($this->param1,'')==0){
            $this->category_selected = Model::factory('product')->get_top_category_permalink();
        } else {
            $this->category_selected = $this->param1;
        }
    }
    
    
    //Check for banner -- Added By Daniel June 22, 2015
    protected function setBanner($table,$permalink)
    {
        $banner = DB::select('cover','title')->from($table)->where('permalink','=',$permalink)->where('status','=','active')->limit(1)->execute()->current();
        if (isset($banner) && !empty($banner['cover']))
        {
            $this->banner = HTML::image($banner['cover'],array('width'=>940,'height'=>238,'rel'=>$banner['title']));
        } elseif ($table === 'product_items') {
            $this->setBanner('product_categories',$this->category_selected);       
        } 
    }
    
    public function action_index() {  
                
        if(!empty($this->param2)){
            $this->action_viewItem();
        } else {
            $this->action_viewCategoryItems();
        }
        
    }
    
    public function action_viewCategoryItems() {
        //Check for banner category -- Added By Daniel June 22, 2015
        $this->setBanner('product_categories',$this->category_selected);
                        
        /*** get all product ***/
        $product_items = Model::factory('product')->get_product_items($this->category_selected, 'active');
       
        $right_content = View::factory('html/site/product/right-content')
                ->set('product_items', $product_items)
                ->set('current_category', $this->category_selected);
       
        $this->set('title', 'Product | ' . $this->site->meta->title)
             ->meta('title', 'Product | ' . $this->site->meta->title)
             ->set('banner',$this->banner)
             ->set('left_content', $this->left_content)
             ->set('right_content', $right_content)
             ->render();
    }

    /*
     * 
     */
    public function action_viewItem() { 
        //Check for banner items -- Added By Daniel June 22, 2015
        $this->setBanner('product_items',$this->param2);
        
       /*** get a product item ***/
       $product_item = Model::factory('productitem')->get_product_item($this->param2); 
       
       /*** get related accessories ***/
       $product_accessories = Model::factory('productaccessory')->get_product_accessory($this->param2, 'active'); 
       
       /*** get related accessories ***/
       $product_downloads = Model::factory('productdownload')->get_product_download($this->param2, 'active'); 
        
       $right_content = View::factory('html/site/product/right-detail-content')
                ->set('product_item', $product_item)
                ->set('product_accessories', $product_accessories)
                ->set('product_downloads', $product_downloads)
                ->set('current_category', $this->category_selected);
       
        $this->set('title', 'Product | ' . $this->site->meta->title)
             ->meta('title', 'Product | ' . $this->site->meta->title)
             ->set('banner',$this->banner)
             ->set('left_content', $this->left_content)
             ->set('right_content', $right_content)
             ->render();
    }
        
    
    /*
     * return success send email
     */
    public function action_thankyou(){
        /*** send $news_detail to be constructed at news detail view ** */
        $right_content = View::factory('html/site/order/right-content')
                ->set('message', 'success');

        $this->set('title', 'How to Order | ' . $this->site->meta->title)
             ->meta('title', 'How to Order | ' . $this->site->meta->title)
             ->set('banner',$this->banner)
             ->set('left_content', $this->left_content)
             ->set('right_content', $right_content)
             ->render();
    }
    
    /*
     * return error send email
     */
    public function action_failed_send_email(){
        /*** send $news_detail to be constructed at news detail view ** */
        $right_content = View::factory('html/site/order/right-content')
                ->set('message', 'failed');

        $this->set('title', 'How to Order | ' . $this->site->meta->title)
             ->meta('title', 'How to Order | ' . $this->site->meta->title)
             ->set('banner',$this->banner)
             ->set('left_content', $this->left_content)
             ->set('right_content', $right_content)
             ->render();
    }
    
    
}

// End Welcome
