<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 	Daniel Simangunsong
 * @author      Deni Budhi Santana
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Model Class (Product Category)
 * @Module      Product Category
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 


class Model_Productcategory extends Model_Base {
    
    /**
     * @var integer content id of history item
     */
    public function historymap($id,$action = 'create') {
        $check = $this->select('label')->from('product_categories')->where('id = '.$id)->execute()->current();
        return empty($check->label) 
            ? __('unknown') 
            : __($action,array(
                    '%item' => 'product_categories "'.$check->label.'"'
                ));
    }
        
    /**
     * @param boolean execute query data or return object
     */ 
    public function limit_productcategory($execution = TRUE){
        $product_categories = Setup::join_histories('product_categories')
                    ->order_by('id','asc');                     
        return $execution === true ? $product_categories->execution() : $product_categories;
    }
   
    /**
     * @param mixed param 
     */ 
    public function get_by($params) {
        $get_params = func_get_args();
        $querying = Setup::join_histories('product_categories');
        
        if ($get_params[0] == 'field') {
            $field_name = "product_categories.$get_params[1]";
            $querying->where("$field_name = $get_params[2]");
        } else {
            return NULL;
        }
        
        return $querying->execute();
    }
    
    /*
     * get all categories and it's receiver email
     */
    public function get_all_active_product_categories(){
        $result = DB::select()
                ->from('product_categories')
                ->where('status', '=', 'active')
                ->as_object()
                ->execute();
        
        if($result->valid()){
            return $result;
        } else {
            return null;
        }
    }
    
    /*
     * get all categories and it's receiver email
     */
    public function get_cat_id($selected_category){
        $result = DB::select('id')
                ->from('product_categories')
                ->where('permalink', '=', $selected_category)
                ->as_object()
                ->execute();
        return ($result->valid()) ? $result->current()->id : null;
    }
}
?>