<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 	Daniel Simangunsong
 * @author      Deni Budhi Santana
 * @Company	Webarq
 * @copyright 	2012
 * @Package	Model Class (Product Category)
 * @Module      Product Category
 * @License	Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 


class Model_Productitem extends Model_Base {
    
    /**
     * @var integer content id of history item
     */
    public function historymap($id,$action = 'create') {
        $check = $this->select('label')->from('product_items')->where('id = '.$id)->execute()->current();
        return empty($check->label) 
            ? __('unknown') 
            : __($action,array(
                    '%item' => 'product_items "'.$check->label.'"'
                ));
    }
        
    /**
     * @param boolean execute query data or return object
     */ 
    public function limit_productitem($execution = TRUE){
        $product_items = Setup::join_histories('product_items')
                    ->order_by('id','desc');                     
        return $execution === true ? $product_items->execution() : $product_items;
    }
   
    /**
     * @param mixed param 
     */ 
    public function get_by($params) {
        $get_params = func_get_args();
        $querying = Setup::join_histories('product_items');
        
        if ($get_params[0] == 'field') {
            $field_name = "product_items.$get_params[1]";
            $querying->where("$field_name = $get_params[2]");
        } else {
            return NULL;
        }
        
        return $querying->execute();
    }
    
    /*
     * get all categories and it's receiver email
     */
    public function get_all_active_product_items(){
        $result = DB::select()
                ->from('product_items')
                ->where('status', '=', 'active')
                ->as_object()
                ->execute();
        
        if($result->valid()){
            return $result;
        } else {
            return null;
        }
    }
    
    /*
    * get all categories and it's receiver email
    */
    public function get_product_item($permalink=null){
        $result = DB::select('product_items.*',array('product_categories.title', 'category_title'))
                ->from('product_items')
                ->join('product_categories', 'left')
                ->on('product_items.product_category_id', '=', 'product_categories.id')
                ->where('product_items.permalink', '=', $permalink)
                ->as_object()
                ->execute();
        
        if($result->valid()){
            return $result;
        } else {
            return null;
        }
    }
    
        /*
    * get all categories and it's receiver email
    */
    public function get_product_id($permalink=null){
        $result = DB::select('id')
                ->from('product_items')
                ->where('permalink', '=', $permalink)
                ->as_object()
                ->execute();
        
        if($result->valid()){
            return $result;
        } else {
            return null;
        }
    }
    
    /*
     * 
     */
    public function get_all_feature_product($activeness='active'){
        
        $sql = "SELECT `pi`.`id`, `pi`.`title`, `pi`.`product_category_id`, `pi`.`description`, `pi`.`feature_product`, `pi`.`information`,
                `pi`.`model`, `pi`.`customer_benefit`, `pi`.`image_path`, `pi`.`permalink`, `pi`.`status`, 
                `pa`.`file_path`, pc.`permalink` AS `category_link`        
                FROM `product_items` AS `pi`
                LEFT JOIN `product_accessories`AS `pa`
                ON `pi`.`id` = `pa`.`product_item_id`
                LEFT JOIN `product_categories`AS `pc`
                ON `pi`.`product_category_id` = `pc`.`id`
                where `pi`.`feature_product` = '$activeness'";
        
         $query = DB::query(Database::SELECT, $sql);
         
        $result = $query->as_object()->execute();
              
        return ($result->valid()) ? $result : null;
    }
    
}