<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Class Cms Template
 * @Module      Templanation
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Space_Ajax extends Controller {
    public $ajax;
    public $param1;
    public $param2;
    public $param3;
    public $param4;
    public $site;
    public $model_history;
    public $authorisation = false;
    
    protected $cookie;
    protected $db;    
    protected $post;
    
    public function before() {
        // Run anything that need ot run before this.
        parent::before();
        
        $this->param1 = $this->request->param('param1');
        $this->param2 = $this->request->param('param2');
        $this->param3 = $this->request->param('param3');
        $this->param4 = $this->request->param('param4');
        
        // Dual language mode
        i18n::$lang       = $this->request->param('lang');
        
        // Set Model Base 
        $this->db = Model::factory('base');
        
        // Load helper tool,
        $tool = new Helper_Tool;  
        
        // Set Default Post        
        $this->post = $this->request->post();
        
        $site_config = Kohana::$config->load('site')->default;
        $this->site = $tool->arr_to_object($site_config);
        $this->site->tool = $tool;
        $this->site->user = User::factory();
        $this->model_history = Model::factory('history');
        
        Cookie::$salt = $this->site->session->get('nousalt',$this->site->salt_name);
        
        // Set themes attributes
        $this->site->themes_css = $this->site->bs_asset.'themes/'.$this->site->themes.'/css/';
        $this->site->themes_img = $this->site->bs_asset.'themes/'.$this->site->themes.'/images/';
        $this->site->themes_js  = $this->site->bs_asset.'themes/'.$this->site->themes.'/js/';
        
        // Set system attributes
        $this->site->system_css = $this->site->bs_asset.'system/css/';
        $this->site->system_img = $this->site->bs_asset.'system/images/';
        $this->site->system_js  = $this->site->bs_asset.'system/js/';
        
        // Set site to config
        Config::$site_config    = $this->site;
          
        $this->identify();
                        
        if (Kohana::$environment == Kohana::PRODUCTION && !$this->authorisation) 
        {
          #die(__('no_direct_access'));
        }
    }
    
    public function after() {
        $this->response->body($this->ajax);
        // Run anything that needs to run after this.
        parent::after();        
    }   
    
    protected function identify($cookie = Null) {
        $this->site->user->profile = NULL; // Reset Login User;
        if (empty($cookie)) {
            $cookie = empty($this->post['session']) ? 'cookie' : $this->post['session'];
            $cookie = empty($this->post['data']['session']) ? $cookie : $this->post['data']['session'];
        }
        
        $this->site->user->identify($cookie);
        $this->authorized();
    }
    
    protected function authorized($module=null,$action=null,$access = false) {
        if (empty($this->site->user->profile->role_id))
            return false;
            
        if ( $this->site->user->profile->role_id <= 1 )
            return $this->authorisation = true;        
        
        if (is_array($module)) {
            foreach ($module as $n_module => $action) {
                $actions = explode(',',$action);
                foreach ($actions as $n_action) {
                    if (!empty($this->site->user->profile->permission->$n_module->$n_action))
                        return $this->authorisation = true;
                    else 
                        $access = false;
                } 
            }
        } else {
            if (!empty($module) && !empty($action))
                return $this->authorisation = !empty($this->site->user->profile->permission->$module->$action) 
                                                ? true: false;
            else
                return false;
        }
        $this->authorisation = $access;
    }
    
    protected function load($view,array $vars = NULL) {
        return View::factory($view,$vars)
                    ->set('site',$this->site);
    }
}

?>