<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Library Image Model
 * @Module      Library
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Model_LibraryImage extends Model_Library {
    
    
    /**
     * 
     * @param boolean execute query data or return object
     */ 
    public function limit_libraryimage($execution = TRUE,$id = null){
        $libraries = $this->select('ml.*','ma.title',array(DB::expr('COUNT(`ma`.`media_library_id`)'),'total_used'))
                        ->from(array('media_libraries','ml'))
                        ->join(array('media_applications','ma'))
                        ->on('ma.media_library_id = ml.id')
                        ->where('ml.type = image')
                        ->group_by('ml.id')
                        ->order_by('ma.ordering');
        
        if (isset($id)) {
            $libraries->and_where('ml.id = '.$id);
        }
        
        return $execution === true ? $libraries->execute() : $libraries;
    }
    
    public function get_media_applications($table,$source_id,$media_position_id) {
        $get = $this->limit_libraryimage(false)
                    ->select('mp.label','mp.width','mp.height')
                    ->join(array('media_positions','mp'))
                    ->on('mp.id = ma.media_position_id')
                    ->and_where('ma.table = '.$table)
                    ->and_where('ma.source_id = '.$source_id);
        
        gettype($media_position_id) == 'integer' 
            ? $get->and_where('ma.media_position_id = '.$media_position_id)
            : $get->and_where('mp.label = '.$media_position_id);
        return $get->execute();
    }
}

?>