<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Model Class (News Management)
 * @Module      News 
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 


class Model_News extends Model_Base {
    
    /**
     * @var integer content id of history item
     */
    public function historymap($id,$action = 'create') {
        $check = $this->select('news_title')->from('news')->where('id = '.$id)->execute()->current();
        return empty($check->news_title) 
            ? __('unknown') 
            : __($action,array(
                    '%item' => 'news "'.$check->news_title.'"'
                ));
    }
    
    
    /**
     * @param boolean execute query data or return object
     */ 
    public function limit_news($execution = TRUE){
        $news = Setup::join_histories('news');                     
        return $execution === true ? $news->execution() : $news;
    }
    
    /**
     * @param
     */
    public function recent_news($limit = 5) {
        return $this->limit_news(false)->limit($limit)
                    ->order_by('news_date','desc')
                    ->execute();
    }
    
   
    /**
     * @var mixed param 
     */ 
    public function get_by($params) {
        $get_params = func_get_args();
        $querying = Setup::join_histories('news');
        
        if (!empty($get_params[0])) {
            if ($get_params[0] == 'field') {
                $field_name = "news.$get_params[1]";
                
                if (!empty($get_params[2]))
                    $querying->where("$field_name = $get_params[2]");
            } else {
                $querying->where("news.id = $get_params[0]");
            }
        }
        
        return $querying->execute();
    }
}
?>