<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Configuration Api Class
 * @Module      Plug
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 



class Config {    
    // Site default config; 
    public static $site_config;
    
    public static function site_config() {
        $site_config = Kohana::$config->load('site')->default;
        return Config::$site_config = helper_tool::arr_to_object($site_config);
    }
    
    
    public static function factory() { /* Still Empty */ }
        
    public static function check($config_id) {   
        $config = Model::factory('base')->select('value')
                                        ->from('configs')
                                        ->where("id = $config_id")
                                        ->execute()->current();
        
        
        if (!empty($config->value)) {
            return json_decode($config->value);
        } else {
            return null;
        }                 
    }
    
    public static function check_message($class='warning') {
        $message = Session::instance()->get('message',null);
        if (!empty($message)) {
            Session::instance()->set('message',null);
            return '<div class="'.$class.'">'.$message.'</div><div class="ls10"></div>';
        }
        return '';
    }
    
    public static function convert_message($i18n = 'null',array $options = array()) {
        $json  = '{"i18n":"'.$i18n.'"';
        if (count($options) >= 1) {
            $json .= ',"data":[';
            $i_opt = 1;
            foreach ($options as $k_opt => $v_opt) {
                $json .= $i_opt > 1 && $i_opt <= count($options) ? ',' : '';
                $json .= '{"name":"%'.$k_opt.'","value":"'.$v_opt.'"}';
                $i_opt++;
            }
            $json .= ']';
        }
        $json .= '}';
        return $json;
    }
    
    /**
     * @param string message, in json format or normal
     * Json Format must have i18n and data option 
     * ;eg sample below
     * {"i18n" : "i18n value","data" : [{"name":"data_item","value":"data item value",}]}
     * 
     */
    public static function reverse_message($message) {
        $j_message = json_decode($message);
        $change = array();
        if (gettype($j_message) == 'object' && !empty($j_message->i18n)) {
            if (!empty($j_message->data) && gettype($j_message->data) == 'array') {
                foreach ($j_message->data as $message) {
                    if (!empty($message->name))
                        $change[$message->name] = empty($message->value) ? "" : $message->value;
                }
            }
            return __($j_message->i18n,$change); 
        }else{
            return $message;
        }
    }
    
    public static function check_module($module_name = null) {
        $modules = Kohana::modules();
        return array_key_exists($module_name,$modules) ? true : false;
    }
    
    public static function active_url($type = null,$style = null) {
        $uris = array
            (
                'page' => array
                (
                    'a' => Request::$initial->uri(),
                    'b' => URL::site(Request::$initial->uri()),
                    'c' => URL::base(TRUE, FALSE).Request::$initial->uri(),
                    'd' => URL::site(Request::$initial->uri(), TRUE),
                ),
    
                'application' => array
                (
                    'a' => URL::base(),
                    'b' => URL::base(TRUE, TRUE),
                    'c' => URL::site(),
                    'd' => URL::site(NULL, TRUE),
                ),
            );
        if (!isset($type) && !isset($style))
            return $uris;
        elseif (isset($type) && !isset($style))
            return !empty($uris[$type]) 
                ? $uris[$type] 
                : (!empty($uris['page'][$type]) ? $uris['page'][$type] : 'unknown type');
        else
            return !empty($uris[$type][$style]) 
                ? $uris[$type][$style] 
                : (!empty($uris[$type]) ? 'unknown style' : 'unknown type');
    }
    
    public static function flag_uri($lang='en',$active_uri = null) {
        // Get active lang
        $active_lang = Config::$site_config->lang;
        
        // Get active uri
        $active_uri  = empty($active_uri) ? config::active_url('a') : $active_uri;
        
        // Check active lang in active uri        
        $find_lang   = stripos($active_uri,$active_lang.'/');
        
        // Check slash in active uri
        $find_slash  = strpos($active_uri,'/');
        
        // Translate uri
        $translate_uri = Config::active_url('c');
        
        if ($find_slash === false || $find_slash === "") { // Mean there is no slash in uri
            $translate_uri = $find_lang === false || $find_lang === ""
                ? Config::active_url('application','b').$lang.'/'.$active_uri
                : Config::active_url('application','b').$lang.'/';   
        } else {
            $active_uri = $active_uri == '/' ? '' : $active_uri;
            $translate_uri = $find_lang === false || $find_lang === ""
                ? Config::active_url('application','b').$lang.'/'.$active_uri
                : Config::active_url('application','b').str_replace("$active_lang/","$lang/",$active_uri);  
        }
        
        return $translate_uri;
    }
    
    public static function lang_uri($uri) {
        if (Translate::$multi_lang === true) {
       	    if (strpos($uri, '://') !== FALSE) {
    			$uri = str_replace(Config::$site_config->bs_site,'',$uri);
    		}
                        
            return config::flag_uri(Config::$site_config->lang,$uri);
        }
        return $uri;
    }
}