<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Transaction Class
 * @Module      Plug
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Transaction {
    /**
     * @var array   rewriteable transaction configuration
     * 
     * Please note, the first three configuration (package,form and owner) is basic requirement to run 
     * all database transaction
     * 
     * And the next two (item_field and item_id) are optionally and only working for
     * update transaction. But please remember, if you leave it empty system will be automatically 
     * match conditional update following ruled updating link, as mentioned below
     * 
     * Eg
     * {whatever-link-before-action}/action/id or
     * {whatever-link-before-action}/action/field/id
     * 
     * In this case, action to match against <strong>"update"</strong> only :), and field condition for
     * update is 'ID'
     * 
     */
    public $configs = array (
            // General Configuration
            'package'        => null,  // string package name
            'form'           => null,  // string form name
            'owner'          => null,  
            'item_field'     => '',   
            'item_id'        => 0,
            
            // Update foreign key            
            'foreign_key'    => null,
            
            // Auto ordering option
            'order_option'   => false, 
            /**
            'order_option'   => array (
                    'table'          => null,
                    'field'          => 'ordering',
                    'input_name'     => null,
                    'previous_input' => null,
                    'parent'   => array(
                            'field_name'  => null,
                            'input_name'  => null,
                            'previous'    => null
                        )
                ),
            **/
            // Auto record history or not
            'record_history' => true,
            
            // Auto Banner
            'auto_banner'    => true
        );
    
    /**
     * @var array   transaction data 
     * ;On going, next development data will be support both of post and get
     */
    public $transaction_data; 
    
    /**
     * @var array   fields which will be affected during transaction
     */
    protected $transaction_fields;
    
    /**
     * @var string  protected transaction job
     */ 
    protected $job;
    
    /**
     * @var array   compliment transaction order
     */
    public $_transaction_orders;
        
    /**
     * @var array object current transaction
     */
    public $_transaction_items = array();
    
    /**
     * @var array object translation query
     */
    public $_translate_items = array();
    
    /**
     * @var array insert row id
     */
    public $result_id;    
    
    /**
     * @param mixed table name
     * delete('table1','table2',...)
     */
    public static function delete() {
        $args = func_get_args();
        return new Transaction(array('table'=>$args,'job'=>'delete'));    
    }
    
    /**
     * @param array new transaction configuration
     * Initiate insert transaction
     */    
    public static function insert($configs) {
        $configs['job'] = 'insert';
        return new Transaction($configs);
    }
    
    /**
     * @param array new transaction configuration
     * Initiate update transaction
     */    
    public static function update($configs) {
        $configs['job'] = 'update';
        return new Transaction($configs);
    }       
    
    // Transaction Constructor
    public function __construct($configs) {
        $this->configs = array_merge($this->configs,$configs);
        
        // Initiate all needed variable
        foreach ($this->configs as $key => $value)
            $this->$key = $value;
        
        if (!empty($this->job) && $this->job != 'delete') {                    
            if (empty($this->transaction_data))
                $this->transaction_data = Request::$initial->post();
            
            if (!empty($this->post))
                $this->transaction_data = $this->post;
            
            if (!$this->pass_requirement())
                return false; // Return false if checking failed
                                                
            $this->prepare();        
            $this->start();
        } 
    }
    
    /**
     * @param mixed table field name using to record history
     * transaction::delete('site_menus','pages')
     *                   ->history_item('menu_title','page_title')
     * using on transaction delete only
     */
    public function history_item() {
        $args = func_get_args();
        $this->history_item = $args;
        return $this;
    } 
    
    /**
     * @param integer owner of transaction
     */
    public function owner($owner_id,$owner_name=null) {
        $this->owner = $owner_id;
        $this->owner_name = $owner_name;
        return $this;
    }
    
    /**
     * @param mixed table field record row to delete
     * transaction::delete('site_menus','pages')
     *                   ->row('1','2')
     * 
     *                   or
     *                  
     *                   ->row(array('id',1),array('permalink','permalink-of-page'))   
     * using on transaction delete only
     */
    public function row() {
        $args = func_get_args();
        foreach ($args as $v) {
            $this->row[] = is_array($v) ? $v : array('id',$v);     
        }
        
        return $this;
    }
    
    // Transaciton filtering    
    protected function pass_requirement() {
        
        if (empty($this->package) || empty($this->form))
            return false;
        
        if (!is_array($this->transaction_data))
            return false;
        
        return true;
    }
    
    /**
     * Gathering all transaction field based on package form given
     */         
    protected function prepare() {
        $alter_package   = is_array($this->package) ? $this->package : array($this->package);
        
        foreach ($alter_package as $key_package => $package) {                    
            $form_name = is_array($this->form) ? $this->form[$key_package] : $this->form;           
            
            $transaction_field = array();
            // Config name using to perform form builder
            $array_config  = array('configuration','alter_configuration');
            
            foreach ($array_config as $item_config) {
                if (!empty(Kohana::$config->load('package/'.$package)->$item_config)) {
                    $config    = Kohana::$config->load('package/'.$package)->$item_config;
                    $json_config = is_array($config) ? json_decode(json_encode($config)) : json_decode($config);
                    foreach ($json_config as $table_name => $table_config) {
                        foreach ($table_config as $field_name => $field_config) {
                            $seek_status = false;
                            if (!empty($field_config->seek)) {
                                $seek_status = true;
                                if (!empty($field_config->used_in)) {
                                    $arr_used_in = explode(',',$field_config->used_in);
                                    $seek_status = !(in_array($form_name,$arr_used_in)) ? false : $seek_status;
                                }    
                            }
                            
                            if (isset($field_config->form->$form_name) || $seek_status === true) {
                                                        
                                $in_form_field_name = empty($field_config->form->$form_name->name)
                                    ? ( empty($field_config->form->default->name) 
                                            ? $field_name                           // Use field table name
                                            : $field_config->form->default->name )  // Use default form name
                                    : $field_config->form->$form_name->name;        // Use exactlu form name
                                    
                                if (isset($field_config->form->$form_name) || (!empty($field_config->seek) && $this->job == 'insert')) {                                           
                                    $this->transaction_fields[$table_name][$in_form_field_name] = array(
                                        'name'      => $field_name,
                                        'default'   => !isset($field_config->default) ? null : $field_config->default,
                                        'multilang' => !empty($field_config->multilang) ? true : false
                                    );
                                }
                                
                                if (!empty($field_config->seek)) {
                                    if ($this->job == 'insert') {
                                        $get_query = DB::query(Database::SELECT,"SHOW TABLE STATUS LIKE '$field_config->seek'")
                                                        ->as_object()->execute();
                                                                                    
                                        $this->transaction_fields[$table_name][$in_form_field_name] = array (
                                            'name'    => $field_name,
                                            'default' => empty($get_query[0]->Auto_increment) ? 0 : $get_query[0]->Auto_increment,
                                        );
                                    } elseif ($this->job == 'update') {
                                        $this->foreign_key = new stdClass();
                                        $this->foreign_key->$table_name = $in_form_field_name;    
                                    }
                                }
                            }
                        }
                    }              
                }  
            }
        }
    }
    
    /**
     * Joining post data with field transaction
     */          
    protected function start() {
        // Make transaction data as an object 
        $objectify = helper_tool::arr_to_object($this->transaction_data,false);
                    
        // Looping as much tables transaction
        foreach ($this->transaction_fields as $table => $fields) {
            $array_value = false;
            
            if ($this->job == 'insert')
                $this->_transaction_items[$table] = Model::factory('base')->insert($table); // One Model for One transaction
            elseif ($this->job == 'update') 
                $this->_transaction_items[$table] = Model::factory('base')->update($table); // One Model for One transaction
            
                            
            $order_transaction = empty($order_transaction) ? null : $order_transaction;
                        
            // Looping as much fields transaction   
            foreach ($fields as $in_form_field_name => $attributes) {                    
                    // Get Value
                    $value = !isset($objectify->$in_form_field_name) 
                                ? (!isset($attributes['default']) ? 'Empty' : $attributes['default'])
                                : $objectify->$in_form_field_name;
                    
                    // Multilang Handler
                    if (Translate::$multi_lang === true 
                            && !empty($attributes['multilang'])
                            && !empty($this->transaction_data['multilang_form'])) {
                                
                        foreach (Translate::$active_lang as $lang){
                            if ($lang->id != Translate::SYS_LANG) {
                                if (is_array($value)) {
                                    $translate_value = $value[$lang->id];
                                    $translate_value = $translate_value == '' 
                                        ? $value[Translate::SYS_LANG]
                                        : $translate_value;
                                } else {
                                    $translate_value = $value;
                                }
                            
                                if ($this->job == 'insert'){
                                    $this->_translate_items[$table][$attributes['name']][$lang->id] = 
                                        Model::factory('base')
                                            ->insert('translations')
                                            ->set('table',$table)
                                            ->set('lang_id',$lang->id)
                                            ->set('field',$attributes['name'])
                                            ->set('value',$translate_value);
                                } else {  
                                    $this->_translate_items[$table][$attributes['name']][$lang->id] = 
                                            Model::factory('base')->update('translations')
                                                ->set('value',$translate_value);
                                                    
                                    $arr_translate_update[$table][$lang->id][$attributes['name']] = $translate_value;
                                }
                            }
                        }
                        
                        if (is_array($value))
                            $value = $value[Translate::SYS_LANG] == ''
                                        ? $value[Translate::$default_lang]
                                        : $value[Translate::SYS_LANG];
                    }
                    
                    // Transaction Default
                    if ($value !== false) {
                        $this->_transaction_items[$table]->set($attributes['name'],$value);
                    }
                    
                    if (is_array($value)) {
                        $array_value = true;    
                    }
                    
                    if ( $attributes['name'] == 'id' && empty($this->item_id) )                           
                        $this->item_id = $field_value;   
            }
            
            // Check item_field and item_id
            if ($this->job == 'update') {
                $check_post_field_table_id = Historymap::trim_table_name($table).'_id';
                $this->check_item_update($table);
                
                if (!isset($this->transaction_data[$check_post_field_table_id])) {
                    $this->_transaction_items[$table]->where($this->item_field.' = '.$this->item_id);
                } else {
                    $this->_transaction_items[$table]->where('id = '.$this->transaction_data[$check_post_field_table_id]);
                }
                
                // Multilang Handler
                if (!empty($this->_translate_items[$table])) {
                    foreach (Translate::$active_lang as $lang){
                        if ($lang->id != Translate::SYS_LANG) {
                            $where_translate = 
                                !isset($this->transaction_data[$check_post_field_table_id])
                                    ? $this->item_id
                                    : $this->transaction_data[$check_post_field_table_id];
                            foreach ($this->_translate_items[$table] as $field => $object) {                                
                                // We must check if data is exist
                                $check = Model::factory('base')->select('lang_id')
                                    ->from('translations')
                                    ->where('table','=',$table)
                                    ->and_where('field','=',$field)
                                    ->and_where('lang_id','=',$lang->id)
                                    ->and_where('source_id','=',$where_translate)
                                    ->execute()->current();
                                
                                if (!empty($check->lang_id)){
                                    $this->_translate_items[$table][$field][$lang->id]
                                        ->where('table','=',$table)
                                        ->and_where('field','=',$field)
                                        ->and_where('lang_id','=',$lang->id)
                                        ->and_where('source_id','=',$where_translate);
                                } else {
                                    $this->_translate_items[$table][$field][$lang->id] =
                                        Model::factory('base')->insert('translations')
                                                ->set('table',$table)
                                                ->set('lang_id',$lang->id)
                                                ->set('field',$field)
                                                ->set('value',$arr_translate_update[$table][$lang->id][$field])
                                                ->set('source_id',$where_translate);
                                }
                            }
                        }
                    }
                }
            }
            
            if ($this->job == 'update' && $array_value)
                unset($this->_transaction_items[$table]);
        }  
        
        // Check for order
        if (!empty($this->order_option)) {                
            $this->order_config($this->order_option);
            $this->_transaction_orders = Transaction::re_order($this->order_option);
        }
                     
    }
    
    protected function order_config(&$config) {
        $data   = helper_tool::arr_to_object($config);
        if (isset($this->transaction_data[$data->input_name]))
            $config['value'] = $this->transaction_data[$data->input_name];
            
        if (isset($this->transaction_data[$data->previous_input])) 
            $config['previous'] = $this->transaction_data[$data->previous_input];
        
        if (isset($data->parent)) {
            if (isset($this->transaction_data[$data->parent->input_name]))
                $config['parent']['value'] = $this->transaction_data[$data->parent->input_name];
            
            if (isset($this->transaction_data[$data->parent->previous_input]))
                $config['parent']['previous'] = $this->transaction_data[$data->parent->previous_input];
            
            unset($config['parent']['input_name'],$config['parent']['previous_input']);
        }
        
        unset($config['input_name'],$config['previous_input']);
    }
    
    public function check_item_update($table) {
        $action = Request::$initial->action();
        $param1 = Request::$initial->param('param1');              
        $param2 = Request::$initial->param('param2');
        
        if ($action == 'update' && !empty($param1)) {
            $this->item_field = empty($this->item_field)
                                ? (!empty($param2) ? $param1 : 'id')
                                : $this->item_field;
            
            if (!empty($this->foreign_key->$table)){
                $this->item_field = $this->foreign_key->$table;
            }
                                                    
            $this->item_id = empty($this->item_id)
                                ? (!empty($param2) ? $param2 : $param1)
                                : $this->item_id;
        }
    }
            
    // Check Configuration
    public function check($check=true) {
        if ($check === true) {
            echo '<p>';
            echo 'A. Post Data<br>=============================================<br/>';
            echo helper_tool::debug($this->transaction_data);
            echo '</p>';
            
            echo '<p>';
            echo 'B. Order<br>=============================================<br/>';
            if (is_array($this->_transaction_orders)) {
                foreach ($this->_transaction_orders as $model_order) {
                    if (!empty($model_order )) {
                        echo $model_order->object().'<br/>';       
                    }
                }
                
            }   
            echo '</p>';
                     
            echo '<p>';
            echo 'C. Data<br>=============================================<br/>';
            foreach ($this->_transaction_items as $table => $object) {
                echo $object->object().'<br/>';
            }
            echo '</p>';
            
            echo '<p>';
            echo 'D. Translations<br>=============================================<br/>';
            if (!empty($this->_translate_items[$table])) { 
                foreach ($this->_translate_items as $table => $object){
                    foreach ($object as $field => $object2)
                        foreach ($object2 as $lang => $new_object)
                            echo $lang.' '.$new_object->object().'<br/>';
                }
            }
            echo '</p>';
            
            die();
        }
    }
    
    protected function do_delete() {
        foreach ($this->table as $k=>$table) {
            // Check for history item
            if (!empty($this->history_item[0])) {
                $field_history = empty($this->history_item[$k]) 
                            ? $this->history_item[0] 
                            : $this->history_item[$k];
                $get_history[$table] = Model::factory('base')
                                            ->select($field_history)
                                            ->from($table)
                                            ->where($this->row[$k][0].' = '.$this->row[$k][1])
                                            ->execute()
                                            ->current();
                if (!empty($get_history[$table]->$field_history)) {
                    // Insert into histories
                    Model::factory('history')->insert_history(array(
                                'table' => $table,
                                'owner' => $this->owner,
                                'source_id' => $this->row[$k][1],
                                'type'  => 'delete',
                                'description' => __('delete_item',array(
                                        '%actor' => $this->owner_name,
                                        '%object' => __($table),
                                        '%item' => $get_history[$table]->$field_history
                                    ))
                            ));
                }                
                                            
            }
            
            // Delete current row from table
            $delete_data[$table] = Model::factory('base')
                                    ->delete($table)
                                    ->where($this->row[$k][0].' = '.$this->row[$k][1])
                                    ->execute();
                                    
            // Check for kohana modules library 
            $modules = Kohana::modules();
            if (!empty($modules['library'])) {
                $delete_library[$table] = Model::factory('base')->delete('media_applications')
                                        ->where('table = '.$table)
                                        ->and_where('source_id = '.$this->row[$k][1]);
            }             
            
            // Check for multilanguage
            if (Translate::$multi_lang === true) {
                $delete_translations[$table] = Model::factory('base')->delete('translations')
                                        ->where('table = '.$table)
                                        ->and_where('source_id = '.$this->row[$k][1])
                                        ->execute();
                
            }                       
                                                                
        }
        return ;
    }
    
    // Run transaction and return result
    public function execute(&$result) {        
        $result = false;
        
        if ($this->job === 'delete') { 
            $result = $this->do_delete(); 
        } else {
            // Process Order First
            if (is_array($this->_transaction_orders)) {
                foreach ($this->_transaction_orders as $model_order) {
                    if (!empty($model_order )) {                        
                        $model_order->execute();       
                    }
                }
            }
                    
            // Protect item_id in variable, so it will not be replacing in main process
            $previous_item_id = $this->item_id;
                            
            // Process  Main Transaction;        
            foreach ($this->_transaction_items as $table => $object) {
                $transactions[$table] = $object->execute();
                
                if ($this->job == 'insert' && !empty($transactions[$table][0]) && empty($previous_item_id)) {
                    $this->item_id = $transactions[$table][0];
                    $this->result_id[$table] = $transactions[$table][0];
                }
                
                // Auto Banner transaction :)
                if ( !empty($this->transaction_data['applicant_table'])
                        && $this->transaction_data['applicant_table'] == $table
                         && $this->auto_banner === true ) {
                            
                    $applicant_table_id = !isset($this->transaction_data['applicant_table_id']) 
                                            || $this->transaction_data['applicant_table_id'] == ''
                                            ? $this->item_id
                                            : $this->transaction_data['applicant_table_id'];
                                            
                    $auto_banner =  Transaction::banner_transaction(
                                    $this->transaction_data['applicant_table'],
                                    $applicant_table_id,
                                    $this->owner
                                );
                }
                
                if (!empty($this->_translate_items[$table])) { 
                    foreach ($this->_translate_items[$table] as $field => $new_object){
                        foreach ($new_object as $lang => $object){
                            if ($this->job == 'insert') {
                                $transactions['translate_'.$table] 
                                    = $object->set('source_id',$this->item_id)->execute();
                            } else{
                                $translate = $object->execute();
                                if (empty($transactions['translate_'.$table]))
                                    $transactions['translate_'.$table] = $translate;
                            }
                        }
                    }
                }
                
                $table_history = $table;            
                $result = $this->check_transaction($transactions);      
                $result = !empty($auto_banner) ? true : $result;      
                if ($result) $this->record_history($table_history);
            }   
        }
    }
    
    /**
     * @var banner transaction
     */
    public static function banner_transaction($applicant_table=null,$applicant_table_id=null,$post = null,$owner=null) {
        $owner = !empty($post) && !is_array($post) ? $post : $owner;
        $post  = empty($post) || !is_array($post)  ? Request::$initial->post() : $post;
        
        $transaction_banner = false;                
        if ( !empty($post['media_library_id'])
                && is_array($post['media_library_id'])) {
                    
            $index_ordering = 1; 
            foreach ($post['media_library_id'] as $key => $value) {
                // Check if exists
                $check = Model::factory('base')->select('table')
                            ->from('media_applications')
                            ->where('table = '.$applicant_table)
                            ->and_where('source_id = '.$applicant_table_id)
                            ->and_where('media_library_id = '.$value)
                            ->execute();
                            
                $transaction_object = empty($check[0])
                    ? Model::factory('base')->insert('media_applications')
                    : Model::factory('base')->update('media_applications');
                                        
                $transaction_object
                        ->set('table',$applicant_table)
                        ->set('source_id',$applicant_table_id)
                        ->set('media_position_id',$post['media_position_id'][$key])
                        ->set('media_library_id',$value)
                        ->set('ordering',$index_ordering);
                
                // Load another configuration
                $array_config = array('configuration','alter_configuration');
                $file_config  = Kohana::$config->load('package/medialibrary');
                
                foreach ($array_config as $item_config) {
                    if ( !empty($file_config->$item_config)) {
                        $package_config = $file_config->$item_config;
                        $json_data = is_array($package_config) 
                            ? json_decode(json_encode($package_config)) 
                            : json_decode($package_config);
                        
                        foreach ($json_data as $tname => $tconf) {                 
                            foreach ($tconf as $fname => $fconf) {                            
                                if (isset($fconf->form->banner))  {
                                    $frm = $fconf->form->banner;
                                    $ipt_name  = empty($frm->name) ? __($fname) : __($frm->name);
                                    $transaction_object->set($fname,$post[$ipt_name][$key]);
                                }
                            }
                        }
                    }
                }
                
                if (!empty($check[0])) {
                    $transaction_object
                            ->where('table = '.$applicant_table)
                            ->and_where('source_id = '.$applicant_table_id)
                            ->and_where('media_library_id = '.$value);
                }
                
                $run_query = $transaction_object->execute();
                
                // Resizing banner
                $img_library = ImageLibrary::factory();
                #$img_library->using_canvas = true;
                $img_library->resize_as_position($value,$owner);
                                
                if (!empty($run_query))
                    $transaction_banner = $run_query;
                    
                $not_in_id = empty($not_in_id) ? $value : $value.','.$not_in_id;
                $index_ordering++;
            }
            
            // Delete unselected banner
            $query_delete = "DELETE FROM `media_applications` WHERE `media_library_id` NOT IN ($not_in_id) AND `table` = '$applicant_table' AND `source_id` = '$applicant_table_id'";
            
            $do_delete    = DB::query(Database::DELETE,$query_delete)->execute();
            if (!empty($do_delete))
                $transaction_banner = $do_delete;            
            
        } else {
            // Trying delete all previous banner from table
            $query_delete = "DELETE FROM `media_applications` WHERE `table` = '$applicant_table' AND `source_id` = '$applicant_table_id'";
            $do_delete    = DB::query(Database::DELETE,$query_delete)->execute();
            if (!empty($do_delete))
                $transaction_banner = $do_delete;       
        }
        return $transaction_banner;
    }
    
    /**
     * @var array transaction database result to check 
     */
    protected function check_transaction($transactions) {
        $result = false;
        
        if ($this->job == 'update') {
            foreach ($transactions as $table => $transaction ) {
                if (!empty($transaction)) return true;
            }
        }elseif ($this->job == 'insert') {
            foreach ($transactions as $transaction ) {
                if (!empty($transaction[1])) {
                    return array ($transaction[1] => $transaction[0]);
                }
            }
        }
        
        return $result;
    }
    
    /**
     * Update History
     */
    public function record_history($table) {
        if (!empty($this->item_id) && $this->record_history === true) {
            $type = $this->job == 'insert' ? Package::instance()->history_type($table) : $this->job;
            $item_history = empty($this->item_history) ? $this->item_id : $this->item_history; 
            Model::factory('history')->insert_history(array(
                    'table' => $table,
                    'owner' => $this->owner,
                    'source_id' => $item_history,
                    'type'  => $type
                ));      
        }     
    }
    
    
    
    /**
     * @param array compliment array transaction configuration
     * 
     * transaction::arrays(array(
     *      'table'      => 'news_categories',
     *      'item_field' => array('news_id,category_id'),
     *      'item_value' => array('1',array('2','3','4'))
     * ));
     * 
     * This function not connected to the other function as this function just a helper,
     * to amplified when you want to do update data array, eg. category, positions, colour, size,
     * attributes or whatever you called it, which is an item could have more than one value;
     */
    public static function arrays(array $configs = array(),$histories_key = null) {
        extract($configs);
        
        if (empty($table))
            throw new Kohana_Exception('Please select table');
            
        elseif (empty($item_field) || !is_array($item_field) )
            throw new Kohana_Exception('Please set item field and it must be an array');
        
        elseif (empty($item_value) || !is_array($item_value) )
            throw new Kohana_Exception('Please set item value and it must be an array which have at least one array value');
        
        elseif (count($item_field) !== count($item_value))
            throw new Kohana_Exception('You got an inconsistent length in your item field compare to value');
            
        // Count array value length
        $length = 0;
        foreach ($item_value as $value)
            if (is_array($value)) $count = count($value); $length = $count >= $length ? $count : $length;
        
        if (empty($length))
            throw new Kohana_Exception('You do not have array in your item value');
                
        // Delete if not selected
        $i  = 0; 
        $delete = Model::factory('base')->delete($table);
        foreach ($item_field as $field){
            $action   = $i == 0 ? 'where' : 'and_where';
            $operator = !is_array($item_value[$i]) ? '=' : 'NOT IN';
            $delete->$action($field,$operator,$item_value[$i]);
            $i++;                                    
        }
        $delete = $delete->execute();
        
        $json = '';
        for ($i = 0; $i < $length; $i++) {
            $json .= $i > 0 ? ',' : '';
            $json .= '{';
            $i_field = 0;
            foreach ($item_field as $field) {
                $json    .= $i_field > 0 ? ',' : '';
                $i_value  = is_array($item_value[$i_field])
                                ? (empty($item_value[$i_field][$i])?'':$item_value[$i_field][$i])
                                : $item_value[$i_field];
                $json    .= '"'.$field.'" : "'.$i_value.'"';
                $i_field++;
            }
            $json .= '}';
        }
        $delete = empty($delete) ? false : true;
        // Insert if not exists
        $insert_ignore = '{"'.$table.'" :['.$json.']}';
        $insert_ignore = Package::$init->insert_row_table($insert_ignore,true,$delete);
        
        return empty($insert_ignore) ? $delete : true;
    }
    
    /**
     * @param   array transaction order configuration.
     * ; see default configs put within function
     * Ofcourse you asking me why there is 2(two) "parent" item in commented mode. :)
     * Simply, it talking about a parent category for our record like parent page, category product etc
     * Ok if you don't have any one just leave it with false(this is will be default value)
     * Or if you have, then you need to fill an array data for it which contain 3 items
     * 1. Field name : a column in table act as your record parent
     * 2. Value      : Of course this is selected value for your parent
     * 3. Previous   : Aha, for this item there is 2(two) way to assign a value for it
     *                 a. An array of (input name for previous value,previous value) or
     *                 b. Like current, only give it a previous value (but you must have an input form
     *                    called "previous_(Input Name)" );
     * Just like that 
    **/
    public static function re_order(array $configs = array()) {
        $default_configs = array (
                'table'    => null,         // Table to affected
                'field'    => 'ordering',   // Field name in your table
                'value'    => 1,            // Selected order value
                'previous' => null,         // Previous order
                'parent'   => false,
                /*
                'parent' => false
                'parent' => array (
                        'field_name' => 'parent_id',
                        'value'      => null, 
                        'previous'   => null, 
                    ),
                */
            );
            
        $configs = array_merge($default_configs,$configs);        
        $data = helper_tool::arr_to_object($configs);
        $data->value = (int)$data->value == 0 ? 1 : (int)$data->value;
        
        if (!empty($data->table) && isset($data->value)) {
            $transaction = null;
            
            /**
             * Pre checking
             * Return null if order value have same value with previous order.
             */
            if (isset($data->previous) && $data->value == $data->previous) {
                if (empty($data->parent) || !isset($data->parent->value) || 
                    !isset($data->parent->previous) || 
                    ($data->parent->value === $data->parent->previous)) {
                        return null;
                }
            }
            
            
            $transaction = Model::factory('base')->update($data->table);
            
            if (!isset($data->previous) || $data->previous === '') {
                $transaction
                    ->set($data->field,DB::expr("`$data->table`.`$data->field`+1"))
                    ->where("$data->table.$data->field >= $data->value");                    
            } else {
                if (!empty($data->parent)) {
                    if ($data->parent->value != $data->parent->previous) {
                        $transaction   = null;
                        $transaction[] = Model::factory('base')->update($data->table)
                                    ->set($data->field,DB::expr("`$data->table`.`$data->field`+1"))
                                    ->where("$data->table.$data->field >= $data->value")
                                    ->and_where($data->parent->field_name." = ".$data->parent->value);
                        
                        $transaction[] = Model::factory('base')->update($data->table)
                                    ->set($data->field,DB::expr("`$data->table`.`$data->field`-1"))
                                    ->where("$data->table.$data->field >= $data->previous")
                                    ->and_where($data->parent->field_name." = ".$data->parent->previous);
                                    
                        return $transaction;
                    }
                }
                // Up
                if ($data->previous > $data->value) {
                    $transaction
                        ->set($data->field,DB::expr("`$data->table`.`$data->field`+1"))
                        ->where("$data->table.$data->field >= $data->value")
                        ->and_where("$data->table.$data->field < $data->previous");                    
                                                       
                } elseif ($data->previous < $data->value) {
                    $transaction
                        ->set($data->field,DB::expr("`$data->table`.`$data->field`-1"))
                        ->where("$data->table.$data->field > $data->previous")
                        ->and_where("$data->table.$data->field <= $data->value");
                        
                }
                                         
            }   
            
            if (isset($data->parent->value))
                $transaction->where($data->parent->field_name.' = '.$data->parent->value);
                
            return array($transaction);
        }
        
        return null;
    }
    
    
    /**
     * Stop current transaction and destroy all variable
     */
    public function stop() {
        $this->package =
        $this->form    =
        $this->transaction_fields  =
        $this->transaction_data    =
        $this->_transaction_orders = 
        $this->_transaction_items  = null;    
    }
}