<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    General Form Fitting
 * @Module      General      
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

 #$html .= helper_tool::debug($form->fields);
 
 // Check for multilang tab
 $multilang_tab = isset($form->multilang) ? $form->multilang : false;
 
 echo Kohana::find_file('../assets/themes/'.$site->themes.'/css/general','form-'.$form->themes,'css') 
                    ? '<link 
                        type="text/css" 
                        rel="stylesheet" 
                        media="screen,projection" 
                        href="'.$site->bs_asset.'themes/'.$site->themes.'/css/general/form-'.$form->themes.'.css"/>'
                    : ''; 
 
 echo '<div class="form-container '.$form->themes.' container-'.$form->column.'-column">',"\n";
 echo Form::open($form->action,$form->attributes);
 
 // Language Tab
 if (!empty(Translate::$active_lang) && Translate::$multi_lang === true && $multilang_tab === true) {
    echo '<input type="hidden" name="multilang_form" value="1"/>';
    echo '<div class="tab">';
    echo '<ul class="tab-content tab-lang">';
    
    foreach (Translate::$active_lang as $lang) {
        echo '<li id="tab-'.$lang->id.'" class="'; echo empty($tab) ? 'active' : ''; echo '">';
            echo '<span class="'; echo empty($default) ? 'default' : ''; echo '">'; 
                echo $lang->label;
            echo '</span>'; 
        echo '</li>';        
        $tab = true;
        $default = true;        
    }
    echo '</ul>';
    echo '</div>';
    echo '<script type="text/javascript" src="'.$site->system_js.'custom/dtab.js"></script>';
 }
 
 $translation = empty($form->form_translation) ? null : $form->form_translation;
     
 foreach ($form->fields as $fields) {
    // Field data object
    $field = helper_tool::arr_to_object($fields,false);
        
    if (strtolower($field->type) === 'submit') {
        $submit = $field;
    } else {    
        // Stylesheet decoration
        if (!empty($field->attributes['open_decoration']) && empty($open_decoration)) {
            echo '<div class="decoration '.$field->attributes['open_decoration'].'">';        
            $field->attributes['open_decoration'] = null;
            $open_decoration  = true;
            $close_decoration = false;
            $decorated = true;
        }
        
        // Labeling form    
        if (isset($field->label)) {
            if ($form->column == 1) {
                echo '<div class="label-form">'.Form::label($field->name,$field->label).'</div>';
                echo '<div class="ls"></div>';
            } else {
                echo '<div class="fl label-form" ';
                echo !empty($form->label_width) ? 'style="width:'.$form->label_width.'px;" ' : '';
                echo '>';
                echo empty($field->label) ? '&nbsp;' : Form::label($field->name,$field->label);
                echo '</div>';           
                echo '<div class="fl center label-form" style="width:20px;">';
                echo empty($field->label) ? '&nbsp;' : ':';
                echo '</div>';
            }
        }           
        
        if ($field->type != 'hidden') {    
            echo '<div class="input-form ';
            echo $form->column == 2 ? "fl ": "";
            echo '" id="input_for_'.$field->name.'">';
        }
        
        // Value checker
        if (!empty($field->field) && !empty($form->form_data) && is_object($form->form_data)) {
            $db_name    = $field->field;
            $form_name  = $field->name;        
            $field->value = !empty($form->form_data->$form_name)
                                ? $form->form_data->$form_name
                                : (!empty($form->form_data->$db_name) ? $form->form_data->$db_name : $field->value);
        };
        
        // ;Predefine array for whichever used input as type
        $array_text = array ('hidden','radio','text','file','password');
        
        // ;Information Block
        if (!empty($field->attributes['info']) && $field->attributes['info'] === true) {
            $info = true;
            unset($field->attributes['info']);
        }
        
        
        // ;Wording for element form
        $wording = null;
        if (!empty($field->attributes['wording'])) {
            $wording = $field->attributes['wording'];
            unset($field->attributes['wording']);    
        }
        
        // ;Check for function instead do automatic render based on type
        if (!empty($field->attributes['function'])) {
            list($class_name,$method) = explode('::',$field->attributes['function'],2);
            
            unset($field->attributes['function']);
            
            // ;Check For Function Params;
            $function_params = array(
                        'name'  => $field->name,
                        'value' => $field->value,
                        'attribute' =>$field->attributes,
                    );
                    
            if (!empty($field->attributes['function_param'])){
                foreach ($field->attributes['function_param'] as $key_param => $value_param) {
                    $function_params[$key_param] = $value_param;
                }
                unset($field->attributes['function_param']);    
            }
                     
            if (method_exists($class_name,$method)) {
                /**
                 * ;Maybe call_user_func will need extra resource,
                 * ;but this is only way to handle unknown paramter we have
                 */
                if ( empty($field->attributes['job']) || empty($field->attributes['item_id']) ) {
                    $page_action = Request::$initial->action();
                    $page_param1 = Request::$initial->param('param1');
                    $page_param2 = Request::$initial->param('param2');
                    
                    if ($page_action == 'form' && $page_param1 === 'edit') {
                        
                        #$field->attributes['job'] = $page_param1;
                        #$field->attributes['item_id'] = $page_param2;
                    }          
                }
                
                $class  = new $class_name;
                echo call_user_func(array($class,$method),$function_params);
            } else {
                echo '<div class="label-form">'.__('no_method').'</div>';
            }
                
        } elseif (in_array($field->type,$array_text)) {
            $field->attributes['type'] = $field->type; 
            echo !empty($wording) ? '<span class="form-wording">&nbsp;'.__($wording).'</span>' : '';
            
            if (!empty(Translate::$active_lang) 
                && Translate::$multi_lang === true 
                && !empty($field->attributes['multilang'])
                && $multilang_tab === true) {
                    
                unset($field->attributes['multilang']);    
                $attribute_id = !empty($field->attributes['id']) ? $field->attributes['id'] : $field->name;
                    
                foreach (Translate::$active_lang as $lang) {    
                    echo '<div class="block-data block-'.$lang->id.'">';
                        $fi_name = $field->name."[".$lang->id."]";
                        if ($lang->ordering != 1 && !empty($field->attributes['class'])) {
                            $field->attributes['class'] = str_replace('required','',$field->attributes['class']);
                        }
                        $field->attributes['id'] = $attribute_id.'-'.$lang->id;
                        
                        if (!empty($translation) && $lang->id != Translate::SYS_LANG) {
                            $translate_lang  = $lang->id;
                            $translate_field = $db_name;
                            
                            $translate_input_value = isset($translation->$translate_lang->$translate_field)
                                        ? $translation->$translate_lang->$translate_field
                                        : '';
                        } else {
                            $translate_input_value = $field->value; 
                        }
                        echo Form::input($fi_name,$translate_input_value,$field->attributes);
                    echo '</div>';
                }
                           
            } else {
                $field->attributes['id'] = !empty($field->attributes['id'])
                    ? $field->attributes['id'].'-'.Translate::SYS_LANG
                    : $field->name.'-'.Translate::SYS_LANG;
                echo Form::input($field->name,$field->value,$field->attributes);
            }
            
        } elseif ($field->type == 'checkbox') {
            $check = !empty($field->attributes['value']) && $field->attributes['value'] == $field->value ? true : false;
            unset($field->attributes['value']);        
            echo '<div class="fl">'.Form::checkbox($field->name,$field->value,$check,$field->attributes).'</div>';
            echo '<div class="fl" style="margin-top:-2px;margin-left:5px;">';
            echo !empty($wording) ? '<span class="form-wording">&nbsp;'.__($wording).'</span>' : '';
            echo '</div>';
            echo '<div class="clear ls5"></div>';
            
        } elseif ($field->type == 'select') {        
            $field->selected = empty($field->selected) && !empty($field->value) ? $field->value : $field->selected;
            echo Form::select($field->name,$field->options,$field->selected,$field->attributes);
            echo !empty($wording) ? '<span class="form-wording">&nbsp;'.__($wording).'</span>' : '';
        
        // Input textarea    
        } elseif ($field->type == 'textarea'){
            if (!empty(Translate::$active_lang) 
                && Translate::$multi_lang === true 
                && !empty($field->attributes['multilang'])
                && $multilang_tab === true) {
                unset($field->attributes['multilang']);
                $attribute_id = !empty($field->attributes['id']) ? $field->attributes['id'] : $field->name;
                foreach (Translate::$active_lang as $lang) {    
                    echo '<div class="block-data block-'.$lang->id.'">';
                        $fi_name = $field->name."[".$lang->id."]";
                        $field->attributes['id'] = $attribute_id.'-'.$lang->id;
                        if ($lang->ordering != 1 && !empty($field->attributes['class'])) {
                            $field->attributes['class'] = str_replace('required','',$field->attributes['class']);
                        }
                        
                        if (!empty($translation) && $lang->id != Translate::SYS_LANG) {
                            $translate_lang  = $lang->id;
                            $translate_field = $db_name;
                            
                            $translate_input_value = isset($translation->$translate_lang->$translate_field)
                                        ? $translation->$translate_lang->$translate_field
                                        : '';
                        } else {
                            $translate_input_value = $field->value;
                        }
                        echo Form::textarea($fi_name,$translate_input_value,$field->attributes);
                    echo '</div>';
                }           
            } else {
                $field->attributes['id'] = !empty($field->attributes['id'])
                    ? $field->attributes['id'].'-'.Translate::SYS_LANG
                    : $field->name.'-'.Translate::SYS_LANG;
                echo Form::textarea($field->name,$field->value,$field->attributes);
            }
            echo !empty($wording) ? '<span class="form-wording">&nbsp;'.__($wording).'</span>' : '';
        } elseif ($field->type == 'ready') {
            echo !empty($field->attributes['print'])
                ? $field->attributes['print']
                : __('no_match_ready');
        } else {
            if ($field->type != 'submit')
                echo 'No Match Input Type for '.$field->type;
        }
        
        if ($field->type != 'hidden') {
            echo '<div class="error_field"></div>';            
            echo '</div>'; // Close div input-form
        }
        
        if (!empty($field->attributes['info'])) {
            echo '<div class="clear"></div>';
            echo '<div class="info_field" id="'.$field->name.'_info">'.$field->attributes['info'].'</div>';
            $field->attributes['info'] = false;    
        }   
        
        if ($field->type != 'hidden')         
            echo '<div class="clear ls8"></div>';
        
        if (!empty($field->attributes['close_decoration']) && !empty($open_decoration)) {
            echo '</div><div class="decoration_separator">&nbsp;</div>';
            $open_decoration  = false;
            $close_decoration = true;
        }
    }
 } // End for each  
 
 if (empty($close_decoration) && !empty($open_decoration)) {
    echo '</div>';
 }      
 
 if (!empty($form->banner) && is_array($form->banner)) {
    $table_applicant = $form->banner[0];
    $table_applicant_id = $form->banner[1];
    
    // Get media positions 
    $media_positions = Model::factory('base')
          ->select(array(DB::expr('COUNT(`id`)'),'total'))
          ->from('media_positions')
          ->execute()->current()->total;
    
    if (!empty($media_positions))                              
        echo Medialibrary::input_media($table_applicant,$table_applicant_id); 
 }
 
 
 if (!empty($submit)) {
    $submit->attributes['type'] = 'submit';
    echo '<div class="clear ls8"></div>';
    
    if ($form->column == 2) {
        echo '<div class="fl  label-form" ';
        echo !empty($form->label_width) ? 'style="width:'.$form->label_width.'px;" ' : '';
        echo '>&nbsp;</div>';
        echo '<div class="fl center label-form" style="width:';
        echo !empty($decorated) ? '40' : '20';
        echo 'px;">&nbsp;</div>';
        echo '<div class="fl">';
    }
        echo Form::input($submit->name,$submit->value,$submit->attributes);
    if ($form->column == 2) {
        echo '</div>';
    }    
    echo '<div class="clear"></div>';
 }
 
 echo Form::close();
 echo '</div>',"\n";
    
?>

<?php if (!empty($form->banner) && is_array($form->banner)) { ?>

<?php } ?>

<script>
    $(document).ready(function(){
        <?php if (!empty(Translate::$active_lang) && Translate::$multi_lang === true && $multilang_tab === true) { ?>
            $('.tab ul.tab-content').dtab({
                active_tab : '<?php echo Translate::$default_lang;?>'
            });
        <?php } ?>       
        
        if ($('#file_server_picker').length > 0) {
            $('#file_server_picker').click(function(){
                $('body').append('<div id="nous-waiting-layering">');
                $('#nous-waiting-layering').append('<div class="spinner"></div>');
                center_middle('.spinner');
                $.ajaxSetup({'async':false});
                $.post(bs_cms+'medialibrary/ajax/browse/image',function(response){
                    $('body').append(response);
                    center_middle('#container_ajax_banner');
                }); 
                $('#nous-waiting-layering').click(function(){
                   $('#container_ajax_banner').remove()
                   $(this).remove();
                });    
                $('.banner_item img').click(function(){
                    var _src = $(this).attr('src');
                    var _sty = $(this).attr('style');
                    var _id  = $(this).attr('id_mag');
                                        
                    if ($('#banner_selector_'+_id).length <= 0) {
                        $.post(bs_cms+'medialibrary/ajax/append-banner',{
                            'src' : _src,
                            'sty' : _sty,
                            'id'  : _id
                        },function(response){
                            $('#banner_field').append(response);
                        });
                        $('#nous-waiting-layering,#container_ajax_banner').remove();
                        $('.banner_selector_punish').click(function(){
                            var _selector = $(this).attr('selector');
                            $('#banner_selector_'+_selector).parent('li').remove();
                        });
                        $('#banner_field').sortable(); 
                    }else{
                        jAlert('<?php echo __('image_already_picked');?>','Warning');
                    }
                });     
            });
            $('.banner_selector_punish').click(function(){
                var _selector = $(this).attr('selector');
                $('#banner_selector_'+_selector).parent('li').remove();
            });
            if ($('#banner_field li').length > 0) {
                $('#banner_field').sortable(); 
            }
        }
    });    
</script>