<?php
defined( 'SYSPATH' ) or die( 'No direct script access.' ) ;

/**
 * Controller_Cms_Profile_List class 
 * @author Wulung Pambuko M.Kom.
 * @copyright (c) 2012 PT. Web Architect Technology
 * @license http://kohanaframework.org/license
 */

class Controller_Cms_Profile_List extends Controller_Space_Cms {
    
    /**
     * The site 
     * @access protected 
     * @var stdClass
     */
    protected $site;
    
    /**
     * The model 
     * @access protected 
     * @var Model_Profile 
     */
    protected $model_profile;
    
    public function before() {
        parent::before() ;
        
        /*** Set the active menu ***/
        $this->site->menu->active = 'profile_menu';
        
        /*** Build the permissions ***/
        /* @var $permissions string */
        $permissions = 'add_profile,modify_profile,delete_profile,view_profile' ;
        /*** Authorize ***/
        $this->authorized( 
                array( 
                    'profile' => $permissions
            )
        ) ;
        
        /*** Instantiate Model_Profile ***/
        $this->model_profile = Model::factory( 'profile' ) ;
        
        /*** Set the Javascripts ***/
        $this->scripts(
                array( 
                    $this->site->system_js.'plugin/jquery.validate.additional',
            )
        ) ;
    }
    
    public function action_index() {
        /*** Set the view ***/
        /* @var $view View */
        $view = View::factory( 'html/cms/profile/list' ) ;
        
        $this->meta( 'title', __( 'profile' ) )
             ->set( 'title', __( 'profile_list' ) )
             ->set( 'content', $view )
             ->render() ;
    }
    
    public function action_form() { 
        $this->authorized(array(
                'page' => 'add_profile,add_profile',
            ));
        
        if ($this->authorisation === true) {
            if ($this->param1 == 'create' || $this->param1 == 'edit') {
                $title = __($this->param1,array('%item'=>__('page_menu',array('%s'=>''))));
                $data  = $this->param1 == 'create' 
                    ? null 
                    : $this->model_page->get_page(false)->where('id = '.$this->param2)->execute()->current();
                
                $this->meta('title',__('manage_menu_page'))
                     ->set('title',$title)
                     ->set('content',$this->html('menu-form')
                            ->set('transaction',$this->param1)
                            ->set('data',$data)
                            ->set('form_action',$this->param1 == 'create' ? 'save' : 'update/'.$this->param2)
                          )
                     ->scripts($this->site->system_js.'plugin/jquery.validate')
                     ->render();
            }    
        }
    }
}
?>
