<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Class Cms Template
 * @Module      Templanation
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Space_Cms extends Controller_Space_Html {
    /**
     * @var object site content container
     */
    protected $site;
    
    /**
     * @var boolean access page state
     */
    protected $accessible;
    
    /**
     * @var string url parameter 
     */
    protected $param1;
    protected $param2;
    protected $param3;
    protected $param4;
    
    public function before() { 
        parent::before();        
        $this->layout = 'cms';        
                
        $cookie = Cookie::get('cms','absolutely_empty');  
        $this->site->cookie = $cookie;
        
        // Identify current session
        $this->site->user->identify($cookie);
        
        if (empty($this->site->user->profile->is_admin) && $this->request->controller() != 'auth') {
            $this->request->redirect($this->site->bs_cms.'user/auth/login');
        } else {                      
            $this->site->menu = Widget::$instance->load('base::cms-two-column-left'); 
        }
        
    }
    
    public function after() {
        if (!empty($this->site->user->profile->is_admin)) { 
            $this->styles(array(
                $this->site->system_css.'general/nous.css'=>'screen,projection',
                $this->site->themes_css.'general/cms-left-side.css'=>'screen,projection'
            ));
        }        
        $this->styles(array(
                $this->site->system_css.'general/jAlert.css' => 'screen,projection',
                $this->site->themes_css.'general/cms.css' => 'screen,projection'
            ));   
        $this->scripts(array(
                $this->site->system_js.'plugin/jquery.alert.js',            
                $this->site->themes_js.'process/trigger.js',
            ));     
        
        // Change return if not authorized       
        if ($this->authorisation === false) {
            $this->site->title   = __("error_401");
            $this->site->content = __('message_error_401');
            $this->render();
        }        
        parent::after();
    }
}    

?>