<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Cms Authentication Class
 * @Module      User
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_User_Auth extends Controller_Space_Cms {
    protected $site;
    
    public function before() {
        parent::before();
                
        if (!empty($this->site->user->profile->is_admin) && $this->request->action() != 'logout') {
            $this->request->redirect($this->site->bs_cms.'user/profile');
        }
    }
    
    public function action_index() {
        $this->action_login();
    }
    
    public function action_login() {
        $this->meta('title','Please login before to continue')
             ->styles($this->site->themes_css.'general/cms-login.css','screen,projection')
             ->scripts($this->site->bs_asset.'system/js/plugin/jquery.validate.additional.js')
             ->scripts($this->site->bs_asset.'system/js/plugin/jquery.validate.js')
             ->set('content',$this->html('form-login'))
             ->render('no-layout');
    }
    
    public function action_logout() {
        $this->site->user->logout($this->site->cookie);  
        if (empty($this->site->user->profile->is_admin)) {
            $this->request->redirect($this->site->bs_cms.'user/auth/login');
        }  
    }
    
    public function action_validate() {
        $post = $this->site->tool->arr_to_object($this->request->post());
        
        if (!empty($post->username) && !empty($post->password)) {
            $cookie = 'cms::'.$this->site->salt.'::'.$this->site->session->regenerate();
            $this->site->user->login($post->username,$post->password,$cookie);                
            if (!empty($this->site->user->profile->is_admin) && $this->request->action() != 'logout') {
                $this->request->redirect($this->site->bs_cms.'user/profile');
            }
            $this->site->session->set('error',__('error_login'));
            $this->request->redirect($this->site->bs_cms.'user/auth/login/error');
        }
        $this->request->redirect($this->site->bs_cms.'user/auth/login');
    }
}
   

?>