<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Cms Class Controller
 * @Module      Event
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_Event_Manage extends Controller_Space_Cms {
    protected $site;
    protected $model;
    
    public function before() {
        parent::before();
        $this->site->menu->active = 'event_list';
        $this->authorized(array(
                'event' => 'create,edit,delete,view',
            )); // Check permission           
         
        
        $this->scripts(array(
                $this->site->system_js.'plugin/jquery.validate.additional',
                $this->site->system_js.'plugin/jquery.validate',
                $this->site->system_js.'party3d/ckeditor/adapters/jquery',
                $this->site->system_js.'party3d/ckeditor/ckeditor',
            ));
    }  
    
    protected function condition() {
        // Condition Search
        $param_condition = array('search');
        if (in_array($this->param1,$param_condition)){
            $function = 'condition_'.$this->param1;
            $this->$function();    
        }
    } 
    
    protected function condition_search() {
        $this->site->search_value = $value_condition = $this->param2;
        
        Paging::$init->list_items->and_where_open()
            ->where('events.id = '.$value_condition)
            ->or_where('events.title like %'.$value_condition.'%')
            ->or_where('events.location like %'.$value_condition.'%')
            ->or_where('events.start_date like %'.$value_condition.'%')
            ->or_where('events.end_date like %'.$value_condition.'%')
            ->or_where('events.status like %'.$value_condition.'%')
            ->and_where_close();
    }
    
    public function action_index() {
        $this->action_list();
    }
    
    public function action_manage() {
        $this->action_list();
    }
        
    public function action_list() {    
        if ($this->authorisation === true) {
            Paging::factory(array(
                    'model' => 'event',
                    'items_per_page' => 10
                ));
            $this->condition();
            Paging::$init->compile();
            
            $this->meta('title',__('manage_event'))
                 ->set('title',__('manage_event'))
                 ->set('content',$this->html('list'))
                 ->scripts($this->site->system_js.'plugin/jquery.validate')
                 ->render();
        }
    }
    
    public function action_form() {
        $this->styles(array(
                 $this->site->system_css.'js/ui/base/jquery.ui.all' => 'screen,projection'
            ));
        $this->scripts(array(
                //$this->site->system_js.'party3d/ui/jquery.ui.datetimepicker.js',
                $this->site->system_js.'library/ui/jquery.ui.datetimepicker.js',
                $this->site->system_js.'library/ui/jquery-ui-1.8.16.custom.min.js',
            ));
        // Extend permission
        $class_action = $this->param1;
        $this->authorized(array('event' => $class_action));
        
        if ($this->authorisation === true) {
            if ($this->param1 == 'create' || $this->param1 == 'edit') {
                $title = __($this->param1,array('%item'=>__('event',array('%s'=>''))));
                
                /** Get data **/
                $data  = $this->param1 == 'create' 
                    ? null 
                    : Model::factory('event')->get_by('field','id',$this->param2)->current();
                           
                /** Form configuration **/
                /** Form action **/
                $form_action  = $this->param1 == 'create' ? 'save' : 'update';                
                $form_action .= !empty($data->id) ? '/'.$data->id : '';
                
                /** Form Build **/
                $form = $this->html('form')
                            ->set('transaction',$this->param1)
                            ->set('data',$data)
                            ->set('form_action',$form_action);
                                            
                /** Rendering **/        
                $this->meta('title',$title)
                     ->set('title',$title)
                     ->set('content',$form)
                     ->render();
            }    
        }
        
    }
    
    public function action_save() {        
        $this->authorized(array(
            'event' => 'create'
        ));
        
        if ($this->authorisation === true) {
            if($this->post){
                $result = false;
                
                $file_type = $_FILES['image_path']['type'];
                                
                if(strcmp($file_type, 'image/jpeg')== 0
                    or
                    strcmp($file_type, 'image/png'== 0
                    or
                    strcmp($file_type, 'image/gif')== 0))
                {
                    $image_name = $this->upload_file('image_path');
                    $image_path = 'media/images/event/' . $image_name;
                }
                else
                {
                    $image_path = null;
                }
                                
                if($image_name == null)
                {
                    $this->post['image_path'] = false;
                }
                else
                {
                    $this->post['image_path'] = $image_path;
                }
                
                $transaction =  Transaction::insert(array(
                       'package'        => 'event',
                       'form'           => 'event',
                       'owner'          => $this->site->user->profile->id,
                       'post'           => $this->post,
                  ));
                                
                $transaction->check(false);            
                $transaction->execute($result);   
                                           
                if ($result === false){
                    Session::instance()->set('message',__('transaction_failed',array('%item'=>strtolower(__('event')))));
                    $this->request->redirect('admin-cp/event/manage/form/create/error');
                }
            }
        }        
        $this->request->redirect('admin-cp/event/manage'); 
    }
    
    public function action_update() {        
        $this->authorized(array(
            'event' => 'edit'
        ));
         
        if ($this->authorisation === true) {
            if($this->post){
                                
                // echo Debug::vars($this->post['new_id']);
                $permalink = ($this->post['permalink']);
                
                $file_type = $_FILES['image_path']['type'];
                                
                if(strcmp($file_type, 'image/jpeg')== 0
                    or
                    strcmp($file_type, 'image/png'== 0
                    or
                    strcmp($file_type, 'image/gif')== 0))
                {
                    $image_name = $this->upload_file('image_path');
                    
                    $image_path = 'media/images/event/' . $image_name;
                }
                else
                {
                    $image_path = null;
                }
                                
                if($image_name == null)
                {
                    $this->post['image_path'] = false;
                }
                else
                {
                    $current_image_path = Model::factory('event')->get_image_path($permalink);
                                        
                    file_exists($current_image_path)?unlink($current_image_path):'';
                    
                    $this->post['image_path'] = $image_path;
                }
                
                $transaction =  Transaction::update(array(
                       'package'        => 'event',
                       'form'           => 'event',
                       'owner'          => $this->site->user->profile->id,
                       'post'           => $this->post,
                  ));
                
                $transaction->check(false);
                $transaction->execute($result);  
                
                if ($result === true) {
                    Session::instance()->set('message',__('success_update'));
                }else{
                    Session::instance()->set('message',__('no_transaction',array('%transaction'=>'update')));
                }
            }
        }    
        
        $this->request->redirect('admin-cp/event/manage/form/edit/'.$this->param1);
    }
    
    public function action_delete() {       
        $this->authorized('event','delete');
        if ($this->authorisation) {
            $delete = Transaction::delete('events')
                        ->owner($this->site->user->profile->id,$this->site->user->profile->full_name)
                        ->history_item('title')
                        ->row($this->param1)
                        ->execute($result);
                            
        }
        $this->request->redirect('admin-cp/event/manage');
    }
    
    /*** upload image file for news ***/
    private function upload_file($param)
    {   
        $data = $_FILES[$param]['name'];
        $pattern = "/ /";
        $replacement = "_";
        $data_ready = strtolower(preg_replace($pattern, $replacement, $data));
        $file_name = uniqid().'_'.$data_ready;
                  
        $upload_file = Upload::save($_FILES[$param],$file_name,'media/images/event/');
        
        // if upload success //
        if($upload_file)
        {
            $image_file_name = $file_name;
        }
        else
        {
            $image_file_name = null;
        }
        
        return $image_file_name; 
    }
    
}
   

?>