<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Cms Manage Class
 * @Module      User
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_User_Manage extends Controller_Space_Cms {
    protected $site;
    
    public function before() {
        parent::before();
        $this->site->menu->active = 'user_list';
        
        $this->model_user  = Model::factory('user'); 
        $this->authorized('user','manage_user'); // Check permission  
    }
    
    public function action_index() {    
        if ($this->authorisation === true) {  
            Paging::factory(array(
                    'model' => 'user',
                    'items_per_page' => 10
                ));                                       
           
            Paging::$init->list_items
                ->where('u.role_id >= '.$this->site->user->profile->role_id)
                ->and_where('r.is_admin = 1');
                  
            $this->condition();
            Paging::$init->compile();
                        
            $this->meta('title',__('manage_user'))
                 ->set('title',__('user_listing'))
                 ->set('content',$this->html('user-listing'))
                 ->scripts($this->site->system_js.'plugin/jquery.validate')
                 ->render();
        }
    }
    
    public function action_form() { 
        if ($this->authorisation === true) {
            if ($this->param1 == 'create' || $this->param1 == 'edit') {
                $title = __($this->param1,array('%item'=>__('user',array('%s'=>''))));
                $data  = $this->param1 == 'create' 
                    ? null 
                    : $this->model_user->get_by('field','id',$this->param2)->current();
                
                $this->meta('title',__('manage_user'))
                     ->set('title',$title)
                     ->set('content',$this->html('user-form')
                            ->set('transaction',$this->param1)
                            ->set('data',$data)
                            ->set('form_action',$this->param1 == 'create' ? 'save' : 'update/'.$this->param2)
                          )
                     ->scripts(array(
                            $this->site->system_js.'plugin/jquery.validate.additional',
                            $this->site->system_js.'plugin/jquery.validate'
                        ))
                     ->render();
            }    
        }
    }
    
    public function action_save() { 
        if ($this->authorisation === true) {  
            if($this->post) {     
                $this->post['password'] = $this->site->user->make_password($this->post['password']);
                $transaction =  Transaction::insert(array(
                       'package' => 'user',
                       'form'    => 'cms_user_form',
                       'owner'   => $this->site->user->profile->id,
                       'post'    => $this->post
                  ));                
                $transaction->execute($transaction);
                
                if ($transaction === false){
                    Session::instance()->set('message',__('transaction_failed',array('%item'=>'user')));
                    $this->request->redirect('admin-cp/user/manage/form/create/error');
                }
            }
        }        
        $this->request->redirect('admin-cp/user/manage');
    }
    
    public function action_update() {
        if ($this->authorisation === true) {  
            if($this->post) {     
                $this->post['password'] =
                    $this->post['password'] == $this->post['previous_password']
                        ? false 
                        : $this->site->user->make_password($this->post['password']);
                $transaction =  Transaction::update(array(
                       'package' => 'user',
                       'form'    => 'cms_user_form',
                       'owner'   => $this->site->user->profile->id,
                       'post'    => $this->post
                  ));
                $transaction->execute($transaction);
                
                if ($transaction === true) {
                    Session::instance()->set('message',__('success_update'));
                }else{
                    Session::instance()->set('message',__('no_transaction',array('%transaction'=>'update')));
                }
            }
        }
        $this->request->redirect('admin-cp/user/manage/form/edit/'.$this->param1);
    }
    
    protected function condition() {
        // Condition Search
        $param_condition = array('search');
        if (in_array($this->param1,$param_condition)){
            $function = 'condition_'.$this->param1;
            $this->$function();    
        }
    }    
    
    protected function condition_search() {
        $this->site->search_value = $value_condition = $this->param2;
        
        Paging::$init->list_items->and_where_open()
            ->where('u.id = '.$value_condition)
            ->or_where('r.label like %'.$value_condition.'%')
            ->or_where('u.email like %'.$value_condition.'%')
            ->or_where('d.first_name like %'.$value_condition.'%')
            ->or_where('d.last_name like %'.$value_condition.'%')
            ->and_where_close();
    }
}
   

?>