<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Cms Role User Class Controller
 * @Module      User
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

class Controller_Cms_User_Role extends Controller_Space_Cms {
//    /**
//     * @var object role model
//     */
//    protected $model_role;
//        
//    public function before() {
//        parent::before();
//        $this->model_role  = Model::factory('role'); 
//        
//        $this->authorized('user','manage_role'); // Check permission  
//    }
//    
//    public function action_index() {
//        $this->action_manage();
//    }
//    
//    public function action_manage() {     
//        if ($this->authorisation === true) {  
//            Paging::factory(array(
//                    'model' => 'role',
//                    'items_per_page' => 10,
//                ));                 
//                
//            Paging::$init->list_items->where('id >= '.$this->site->user->profile->role_id);        
//            $this->condition();
//            Paging::$init->compile();
//                        
//            $this->meta('title',__('manage_role'))
//                 ->set('title',__('roles'))
//                 ->set('content',$this->html('role-listing'))             
//                 ->scripts($this->site->system_js.'plugin/jquery.validate')
//                 ->render();
//        }
//    }
//    
//    
//    
//    public function action_form() { 
//        if ($this->authorisation === true) {
//            if ($this->param1 == 'create' || $this->param1 == 'edit') {
//                $title = __($this->param1,array('%item'=>__('role',array('%s'=>''))));
//                $data  = $this->param1 == 'create' 
//                    ? null 
//                    : $this->model_role->get_role($this->param2);
//                
//                $this->meta('title',__('manage_user'))
//                     ->set('title',$title)
//                     ->set('content',$this->html('role-form')
//                            ->set('transaction',$this->param1)
//                            ->set('data',$data)
//                            ->set('form_action',$this->param1 == 'create' ? 'save' : 'update/'.$this->param2)
//                          )
//                     ->scripts($this->site->system_js.'plugin/jquery.validate')
//                     ->render();
//            }    
//        }
//    }
//    
//    
//    public function action_save() {  
//        if ($this->authorisation === true) {  
//            if($this->post) {               
//                $transaction =  Transaction::insert(array(
//                       'package' => 'user',
//                       'form'    => 'cms_role_form',
//                       'owner'   => $this->site->user->profile->id
//                  ));                
//                $transaction->check(false);  
//                $transaction->execute($transaction);
//            }
//        }
//        
//        $this->request->redirect('admin-cp/user/role/manage');
//    }
//    
//    public function action_update() {
//        if ($this->authorisation === true) {  
//            if($this->post) {               
//                $transaction =  Transaction::update(array(
//                       'package' => 'user',
//                       'form'    => 'cms_role_form',
//                       'owner'   => $this->site->user->profile->id
//                  ));
//                $transaction->execute($transaction);
//                
//                if ($transaction === true) {
//                    Session::instance()->set('message',__('success_update'));
//                }else{
//                    Session::instance()->set('message',__('no_transaction',array('%transaction'=>'update')));
//                }
//            }
//        }
//        $this->request->redirect('admin-cp/user/role/form/edit/'.$this->param1);
//    }
//    
//    protected function condition() {
//        // Condition Search
//        $param_condition = array('search');
//        if (in_array($this->param1,$param_condition)){
//            $function = 'condition_'.$this->param1;
//            $this->$function();    
//        }
//    }    
//    
//    protected function condition_search() {
//        $this->site->search_value = $value_condition = $this->param2;
//        Paging::$init->list_items->and_where_open()
//            ->where('id = '.$value_condition)
//            ->or_where('label like %'.$value_condition.'%')
//            ->and_where_close();
//    }
//}

    /**
     * @var object role model
     */
    protected $model_role;
        
    public function before() {
        parent::before();
        $this->model_role  = Model::factory('role'); 
        
        $this->authorized('user','manage_role'); // Check permission  
    }
    
    public function action_index() {
        $this->action_manage();
    }
    
    public function action_manage() {     
        if ($this->authorisation === true) {  
            Paging::factory(array(
                    'model' => 'role',
                    'items_per_page' => 10,
                ));                 
                
            Paging::$init->list_items->where('id >= '.$this->site->user->profile->role_id);        
            $this->condition();
            Paging::$init->compile();
                        
            $this->meta('title',__('manage_role'))
                 ->set('title',__('roles'))
                 ->set('content',$this->html('role-listing'))             
                 ->scripts($this->site->system_js.'plugin/jquery.validate')
                 ->render();
        }
    }
    
    
    
    public function action_form() { 
        if ($this->authorisation === true) {
            if ($this->param1 == 'create' || $this->param1 == 'edit') {
                $title = __($this->param1,array('%item'=>__('role',array('%s'=>''))));
                $data  = $this->param1 == 'create' 
                    ? null 
                    : $this->model_role->get_role($this->param2);
                
                $this->meta('title',__('manage_user'))
                     ->set('title',$title)
                     ->set('content',$this->html('role-form')
                            ->set('transaction',$this->param1)
                            ->set('data',$data)
                            ->set('form_action',$this->param1 == 'create' ? 'save' : 'update/'.$this->param2)
                          )
                     ->scripts($this->site->system_js.'plugin/jquery.validate')
                     ->render();
            }    
        }
    }
    
    
    public function action_save() {  
        if ($this->authorisation === true) {  
            if($this->post) {               
                $transaction =  Transaction::insert(array(
                       'package' => 'user',
                       'form'    => 'cms_role_form',
                       'owner'   => $this->site->user->profile->id
                  ));                
                $transaction->check(false);  
                $transaction->execute($transaction);
            }
        }
        
        $this->request->redirect('admin-cp/user/role/manage');
    }
    
    public function action_update() {
        if ($this->authorisation === true) {  
            if($this->post) {               
                $transaction =  Transaction::update(array(
                       'package' => 'user',
                       'form'    => 'cms_role_form',
                       'owner'   => $this->site->user->profile->id
                  ));
                $transaction->execute($transaction);
                
                if ($transaction === true) {
                    Session::instance()->set('message',__('success_update'));
                }else{
                    Session::instance()->set('message',__('no_transaction',array('%transaction'=>'update')));
                }
            }
        }
        $this->request->redirect('admin-cp/user/role/form/edit/'.$this->param1);
    }
    
    protected function condition() {
        // Condition Search
        $param_condition = array('search');
        if (in_array($this->param1,$param_condition)){
            $function = 'condition_'.$this->param1;
            $this->$function();    
        }
    }    
    
    protected function condition_search() {
        $this->site->search_value = $value_condition = $this->param2;
        Paging::$init->list_items->and_where_open()
            ->where('id = '.$value_condition)
            ->or_where('label like %'.$value_condition.'%')
            ->and_where_close();
    }
    
}