<?php defined('SYSPATH') or die('No direct script access.'); 
 
/**
 * @Author 		Daniel Simangunsong
 * @Company		Webarq
 * @copyright 	2012
 * @Package	    Page Form
 * @Module      Page
 * @License		Kohana ~ Webarq ~ Daniel Simangunsong
 * 
 * Calm seas, never make skillfull sailors	
**/ 

?>

<?php   
    echo Config::check_message();
    
    if ($form_action != 'save' && empty($data->id)) {
        echo '<label class="no_data">'.__('no_data').'</label>';   
        return;    
    } else {
        // $form = Form::init(array('multilang' => false,'banner'=> array('pages',isset($data->id) ? $data->id : null)))
        $form = Form::init(array('multilang' => false))
                // Parsing form data                
                ->set_data($data)
                
                // Attribute form section
                ->attribute('class','frm-general frm-cms')
                ->attribute('id','frm_page')->attribute('class','frm_page no_validation')
                ->action($site->bs_cms.'page/manage/'.$form_action)
                
                // Altering input attribute, needed for update maximum page order                   
                ->before_form(1)
                ->inject('job',$transaction)
                ->inject('item_id',empty($data->site_menu_id) ? 0 : $data->site_menu_id)
                ->inject('parent_id',empty($data->parent_id) ? 0 : $data->parent_id);
        
        if (isset($data->id)) {
                // Add input to form
             $form    
                ->add('hidden')
                    ->set_name('previous_ordering')
                    ->set_value(!isset($data->ordering) ? null : $data->ordering)
                    ->order(28)
                    
                ->add('hidden')
                    ->set_name('previous_parent')
                    ->set_value(!isset($data->parent_id) ? null : $data->parent_id)
                    ->order(29)
                
                ->add('hidden')
                    ->set_name('page_id')
                    ->set_value(!isset($data->id) ? null : $data->id)
                    ->order(30)
                
                ->add('hidden')
                    ->set_name('site_menu_id')
                    ->set_value(!isset($data->site_menu_id) ? null : $data->site_menu_id)
                    ->order(31);
        }
        
        echo $form
            ->add('submit')->set_value('')->order(100)->set_label('')
            ->build(array('base::page','page::page'));
        
           
        
    }
?>

<script>
    $(document).ready(function(){
        init_ckeditor('intro');
        init_ckeditor('description');
        
        <?php if ($transaction == 'create') { ?>
        $('.menu_title').keyup(function(){
            var lang_id = $(this).attr('id').split("-").pop();
            $('#page_title-'+lang_id).val($(this).val());
            $('#permalink-'+lang_id).val(cute_url($(this).val()));
        });
        $('.menu_title').blur(function(){
            var lang_id = $(this).attr('id').split("-").pop();
            $('#page_title-'+lang_id).val($(this).val());
            $('#permalink-'+lang_id).val(cute_url($(this).val()));
        });
        <?php } ?>
        
        // 3 is id of about us
        $('select[name="parent"]').val(<?php echo empty($data->parent_id) ? 3 : $data->parent_id;?>);
        
        $('select[name="parent"]').change(function(){
            var val = $(this).val();
            $.ajaxSetup({ async: false });
            $.post(bs_cms+'page/ajax/remake-order-max',{
                'parent' : val,
                'session' : '<?php echo $site->cookie;?>',
                'job'   : "<?php echo $transaction;?>",
                'previous' : $(this).attr('parent_id')         
            },function(response){
                if(response.status === true) {
                    $('input[name="ordering"]').attr('max',response.max).val(response.max);
                    $('input[name="ordering"]').siblings('span').text(response.tooltip);
                }else{
                    jAlert('Error');
                }
            },'json');
        });
        $('form#frm_page').validate({
            onkeyup: false,
            errorPlacement  : function(error, element) {
                $(element).closest('.input-form').find('.error_field').after(error); 
            }
        });
        
        $('.menu_title').each(function(){
            var lang_id = $(this).attr('id').split("-").pop();
            $('#menu_title-'+lang_id).rules("add",{
                minlength : 3,
                check_availablity : {
                    "table"   : "site_menus",
                    "field"   : "menu_title",
                    "job"     : "<?php echo $transaction;?>",
                    "prev"    : "<?php echo empty($data->menu_title) ? '' : $data->menu_title; ?>",
                    "src_id"  : "<?php echo empty($data->site_menu_id) ? '' : $data->site_menu_id ;?>",
                    "lang_id" : lang_id
                }
            });
        });
        
        $('.permalink').each(function(){
            var lang_id = $(this).attr('id').split("-").pop();
            $('#permalink-'+lang_id).rules("add",{
                minlength : 3,
                check_availablity : {
                    "table" : "site_menus",
                    "field" : "permalink",
                    "job"   : "<?php echo $transaction;?>",
                    "prev"  : "<?php echo empty($data->permalink) ? '' : $data->permalink; ?>",
                    "src_id": "<?php echo empty($data->site_menu_id) ? '' : $data->site_menu_id ;?>",
                    "lang_id" : lang_id
                }
            });
        });
        
        
        <?php if (!empty($data->is_system)) { ?>
        $('input.permalink').attr('readonly',true);
        <?php } ?>
        
    });
</script>