<?php

defined('SYSPATH') or die('No direct access allowed');
/**
 * 
 * @author Deni Budhi Santana
 * @copyright PT Web Architect Technology 2012
 */

?>

<style type="text/css">
 .holder {
    dmargin:15px 0;
	float:left;
	width: auto;
	text-align:justify !important;
}
.holder a {
    font-size:12px;
    cursor:pointer;
    padding: 1px 5px;
    color: #959595;
    margin-left:1px;
    text-decoration: none;
	 background-color: #D8D8D8;
}
.holder a:hover {
    background-color: #959595;
    color:#fff;  
}
.holder a.jp-previous {
   margin-left:5px;
   margin-right:5px;
   float:left;
}
.holder a.jp-next {
    margin-right:5px;
	float:right;
}
.holder a.jp-previous:hover, .holder a.jp-next:hover {
	background:none !important;
	color: #0083CA;
	text-decoration:underline;
}

.holder a.jp-current,
a.jp-current:hover {
    color: #0083CA;
    background:#959595;
    color: #FFF;
}

.holder a.jp-disabled,
a.jp-disabled:hover {
  /* color:#bbb;   */
}
.holder span {
    margin: 0 5px;
}
</style>

<?php
switch ($section) {
    case 'read':
        echo '<div class = "contentWrp unreseted">';
        echo '<h2>News</h2>';
        
        if($news==null){
            echo "Currently, we have no news.";
            echo '</div>';
        } else {
            foreach ($news as $data) {
                echo '<span class = "title">'.$data->news_title.'</span><br/>';
                echo '<span class = "date">'. date('M d, Y', strtotime($data->news_date)) .'</span> <br/>';
                echo ($data->image_path != null)
                        ? '<div class = "bgBigImage">'.HTML::image(URL::base(true).'imagefly/w380-h255-c/'.$data->image_path).'</div>'
                        : '';        
                echo $data->description;
                echo '<div class = "paging">';
                echo '<a href = "'.URL::base(true).'news'.'" class = "more1">Back to News List</a>';
                echo '</div>';
            }
        }
        echo '</div>';

        break;

    default:
        echo '<div class="pathway">';
        echo HTML::anchor(URL::base(true), 'Home / ');
        echo HTML::anchor(URL::base(true) . 'news-event', 'News & Event / ');
        echo HTML::anchor(URL::base(true) . 'news', 'News');
        echo '</div>';

        /** listing all active news * */
        echo '<div class="contentWrp">';
        echo '<h2>News</h2>';
        
        if($news==null){
            echo "Currently, we have no news.";
            echo '</div>';
        } else {
            echo '<ul class="newsListing" id="newsListing">';
            foreach ($news as $data) {
                echo '<li>';
                echo '<div class="imgNews">';
                echo ($data->image_path != null)
                        ? HTML::image(URL::base(true).'imagefly/w220-h88-c/'.$data->image_path)
                        : HTML::image(URL::base(true).'imagefly/w220-h88-c/' . 'assets/themes/webarq/images/content/image-news.jpg');
                echo '</div>';
                echo '<div class="newsPrev">';
                echo '<a href="' . URL::base(true) . 'news/read/' . $data->permalink . '" class="titleNews">' . $data->news_title . '</a><br/>';
                echo '<span class="date">' . date('M d, Y', strtotime($data->news_date)) . '</span>';
                echo '<p>' . substr(strip_tags($data->description), 0, 100) . '...' . '</p>';
                echo '<a class="more1" href="' . URL::base(true) . 'news/read/' . $data->permalink . '">Read more</a>';
                echo '</div>';
                echo '<div class="line"></div>';
                echo '</li>';
            }
            echo '</ul>';

            echo '<div class="paging">';
            echo '<span>Page </span>';
            echo '<span class="holder"></span>';
    //        echo '<ul class="paging-ul">';
    //        echo '<li><a href="" class="active">1</a/></li>';
    //        echo '<li><a href="">2</a/></li>';
    //        echo '</ul>';
            echo '</div>'; // paging;

            echo '</div>'; // contentWrp end;
        }

        break;
}
?>


<script type="text/javascript">
    
    $(function(){
            
        $("span.holder").jPages({ 
            containerID : "newsListing",
            previous : false,
            next : false,
            perPage : 10,
            delay : 3
        });
        
        
        
    });

</script>